package rubik;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

//import edu.cornell.cs.cs2110.DelimitedStringBuilder;

import rubik.geometry.Matrix;
import rubik.geometry.ThreeDPoint;

/**
 * A {@code Cube} consists of six {@code Square}s.
 */
public class Cube {

   // index Cubes by their centers
   static Map<ThreeDPoint, Cube> cubes = new HashMap<ThreeDPoint, Cube>();

   ThreeDPoint center;
   Square[] faces = new Square[6];
   CubeGroup position = CubeGroup.elements.get(Matrix.IDENTITY);
   CubeGroup oldPosition;

   enum Type { CORNER, EDGE, FACE, CENTER }
   Type type;

   static Cube centralCube;

   // create the cubes
   static void create() {
      // central cube must be created first
      centralCube = new Cube(ThreeDPoint.ZERO, Type.CENTER);
      for (int i = -2; i <= 2; i += 2) {
         for (int j = -2; j <= 2; j += 2) {
            for (int k = -2; k <= 2; k += 2) {
               int t = Math.abs(i) + Math.abs(j) + Math.abs(k);
               if (t == 0) continue;
               Type type = t == 6? Type.CORNER : t == 4? Type.EDGE : Type.FACE;
               new Cube(new ThreeDPoint(i, j, k), type);
            }
         }
      }     
   }

   static final ThreeDPoint[] normals = {
      new ThreeDPoint(1, 0, 0), new ThreeDPoint(-1, 0, 0), new ThreeDPoint(0, 1, 0),
      new ThreeDPoint(0, -1, 0), new ThreeDPoint(0, 0, 1), new ThreeDPoint(0, 0, -1)
   };

   static final Color[] colors = { Color.WHITE, Color.YELLOW, Color.BLUE,
      Color.GREEN, Color.RED, new Color(255, 100, 0) // orange
   };

   Cube(ThreeDPoint center, Type type) {
      this.type = type;
      this.center = center;
      // a cube has 6 faces
      for (int i = 0; i < 6; ++i) {
         // scale center of square a little toward center of cube so BSP tree works
         faces[i] = new Square(this, center.plus(normals[i].scale(1 - 1e-10)), normals[i]);
      }
      setFaceColors();
      cubes.put(center, this);
   }
   
   void setFaceColors() {
      for (int i = 0; i < 6; ++i) {
         // is the face pointing outward?
         Color color = (normals[i].cos(center) > 0) ? colors[i] : Color.BLACK;
         faces[i].setColor(color);
      }
   }
   
   static void setAllColors() {
      for (Cube c : cubes.values()) c.setFaceColors();
   }
   
   public String toString() {
      return String.format("type= %s center= %s\nposition=\n%s", type.toString(), center.toString(), position.toString());
   }
   
   static Cube cubeAt(int x, int y, int z) {
      return cubes.get(new ThreeDPoint(x, y, z));
   }
   
   // encode the state as a string
   static String encode() {
//    DelimitedStringBuilder dsb = new DelimitedStringBuilder("\n");
      StringBuilder sb = new StringBuilder();
      // save cube positions
      for (Cube c : Cube.cubes.values()) {
         sb.append(c.toString());
         sb.append('\n');
      }
      // colors
      for (int i = 0; i < Cube.colors.length; i++) {
         Color c = Cube.colors[i];
//       dsb.append(String.format("color %d = %d %d %d", i, c.getRed(), c.getGreen(), c.getBlue()));
         sb.append(String.format("color %d = %d %d %d", i, c.getRed(), c.getGreen(), c.getBlue()));
         sb.append('\n');
      }
      return sb.toString().trim();
   }
   
   public int hashCode() {
      return center.hashCode();
   }

   public boolean equals(Object o) {
      try {
         return center.equals(((Cube)o).center);
      } catch (ClassCastException cce) {
         return false;
      }
   }

   // reconstitute state from the encoded version
   static void decode(Scanner sc) throws Exception {
      for (Cube c : Cube.cubes.values()) {
         sc.nextLine();
         sc.nextLine();
         Matrix m = new Matrix();
         m.x.x = sc.nextDouble();
         m.x.y = sc.nextDouble();
         m.x.z = sc.nextDouble();
         m.y.x = sc.nextDouble();
         m.y.y = sc.nextDouble();
         m.y.z = sc.nextDouble();
         m.z.x = sc.nextDouble();
         m.z.y = sc.nextDouble();
         m.z.z = sc.nextDouble();
         c.position = CubeGroup.elements.get(m);
         sc.nextLine();
      }
      for (int i = 0; i < Cube.colors.length; i++) {
         sc.next();
         sc.next();
         sc.next();
         Cube.colors[i] = new Color(sc.nextInt(), sc.nextInt(), sc.nextInt());
      }
      sc.nextLine();
      if (sc.hasNext()) throw new Exception();
      setAllColors();
   }

}