package rubik;

import java.io.InputStream;

import javax.sound.sampled.AudioSystem;

public class Clip {
   
   javax.sound.sampled.Clip clip;
   private boolean enabled = true;
   
   Clip(String name) {
      try {
         clip = AudioSystem.getClip();
         InputStream is = getClass().getClassLoader().getResourceAsStream("resources/sounds/" + name);
         clip.open(AudioSystem.getAudioInputStream(is));
      } catch (Exception e) {
         clip = null;
      }
   }
   
   void play() {
      if (clip != null && enabled) {
         clip.setFramePosition(0);
         clip.loop(0);
      }
   }

   void setEnabled(boolean enabled) {
      this.enabled = enabled;
   }

}
