/*
 * Decompiled with CFR 0.152.
 */
package randoop.util;

import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import randoop.main.GenInputsAbstract;
import randoop.main.RandoopBug;
import randoop.util.CollectionsExt;
import randoop.util.Log;
import randoop.util.RandoopLoggingError;
import randoop.util.SimpleList;

public final class Randomness {
    public static @SignatureUnknown int verbosity = 1;
    public static final @SignatureUnknown long DEFAULT_SEED = 0L;
    private static @SignatureUnknown Random random = new Random(0L);
    private static @SignatureUnknown int totalCallsToRandom = 0;

    private Randomness() {
        throw new IllegalStateException("no instances");
    }

    public static void setSeed(@SignatureUnknown long seed) {
        random.setSeed(seed);
        totalCallsToRandom = 0;
        Randomness.logSelection("[Random object]", "setSeed", seed);
    }

    private static void incrementCallsToRandom(@SignatureUnknown String caller) {
        Log.logPrintf("randoop.util.Randomness called by %s: %d calls to Random so far%n", caller, ++totalCallsToRandom);
    }

    public static @SignatureUnknown int nextRandomInt(@SignatureUnknown int i) {
        Randomness.incrementCallsToRandom("nextRandomInt");
        int value = random.nextInt(i);
        Randomness.logSelection(value, "nextRandomInt", i);
        return value;
    }

    public static <T> T randomMember(@SignatureUnknown List<T> list) {
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("Expected non-empty list");
        }
        int position = Randomness.nextRandomInt(list.size());
        Randomness.logSelection(position, "randomMember", list);
        return list.get(position);
    }

    public static <T> T randomMember(@SignatureUnknown SimpleList<T> list) {
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("Expected non-empty list");
        }
        int position = Randomness.nextRandomInt(list.size());
        Randomness.logSelection(position, "randomMember", list);
        return list.get(position);
    }

    public static <T> T randomMemberWeighted(@SignatureUnknown SimpleList<T> list, @SignatureUnknown Map<T, @SignatureUnknown Double> weights) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Empty list");
        }
        double totalWeight = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            T elt = list.get(i);
            double weight = weights.get(elt);
            if (weight < 0.0) {
                throw new RandoopBug("Weight should be positive: " + weight);
            }
            totalWeight += weight;
        }
        return Randomness.randomMemberWeighted(list, weights, totalWeight);
    }

    public static <T> T randomMemberWeighted(@SignatureUnknown SimpleList<T> list, @SignatureUnknown Map<T, @SignatureUnknown Double> weights, @SignatureUnknown double totalWeight) {
        int i;
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Empty list");
        }
        Randomness.incrementCallsToRandom("randomMemberWeighted(SimpleList)");
        double chosenPoint = random.nextDouble() * totalWeight;
        if (GenInputsAbstract.selection_log != null) {
            try {
                GenInputsAbstract.selection_log.write(String.format("chosenPoint = %s%n", chosenPoint));
            }
            catch (IOException e) {
                throw new Error("Problem writing to selection-log", e);
            }
        }
        double currentPoint = 0.0;
        for (i = 0; i < list.size(); ++i) {
            if (!((currentPoint += weights.get(list.get(i)).doubleValue()) > chosenPoint)) continue;
            Randomness.logSelection(i, "randomMemberWeighted", list);
            return list.get(i);
        }
        System.out.printf("totalWeight=%f%n", totalWeight);
        System.out.printf("currentPoint=%f%n", currentPoint);
        System.out.printf("list.size()=%d%n", list.size());
        for (i = 0; i < list.size(); ++i) {
            System.out.printf("%d, %f%n", i, weights.get(list.get(i)));
        }
        throw new RandoopBug("Unable to select random member");
    }

    public static <T> T randomSetMember(@SignatureUnknown Collection<T> set) {
        int setSize = set.size();
        int randIndex = Randomness.nextRandomInt(setSize);
        Randomness.logSelection(randIndex, "randomSetMember", set);
        return CollectionsExt.getNthIteratedElement(set, randIndex);
    }

    public static @SignatureUnknown boolean weightedCoinFlip(@SignatureUnknown double trueProb) {
        if (trueProb < 0.0 || trueProb > 1.0) {
            throw new IllegalArgumentException("arg must be between 0 and 1.");
        }
        double falseProb = 1.0 - trueProb;
        Randomness.incrementCallsToRandom("weightedCoinFlip");
        boolean result = random.nextDouble() >= falseProb;
        Randomness.logSelection(result, "weightedCoinFlip", trueProb);
        return result;
    }

    public static @SignatureUnknown boolean randomBoolFromDistribution(@SignatureUnknown double falseProb, @SignatureUnknown double trueProb) {
        if (falseProb < 0.0) {
            throw new IllegalArgumentException("falseProb is " + falseProb + ", must be non-negative");
        }
        if (trueProb < 0.0) {
            throw new IllegalArgumentException("trueProb is " + trueProb + ", must be non-negative");
        }
        double totalProb = falseProb + trueProb;
        if (totalProb == 0.0) {
            throw new IllegalArgumentException("falseProb and trueProb are both 0");
        }
        double falseProbNormalized = falseProb / totalProb;
        Randomness.incrementCallsToRandom("randomBoolFromDistribution");
        boolean result = random.nextDouble() >= falseProbNormalized;
        Randomness.logSelection(result, "randomBoolFromDistribution", falseProb + ", " + trueProb);
        return result;
    }

    private static void logSelection(@SignatureUnknown Object returnValue, @SignatureUnknown String methodName, @SignatureUnknown Object argument) {
        if (GenInputsAbstract.selection_log != null && verbosity > 0) {
            StackTraceElement[] trace = Thread.currentThread().getStackTrace();
            String methodWithArg = methodName;
            if (argument != null) {
                methodWithArg = methodWithArg + "(" + Randomness.toString(argument) + ")";
            }
            try {
                String msg = String.format("#%d: %s => %s; calls so far %d; called from %s%n", totalCallsToRandom, methodWithArg, returnValue, totalCallsToRandom, trace[3]);
                GenInputsAbstract.selection_log.write(msg);
                GenInputsAbstract.selection_log.flush();
            }
            catch (IOException e) {
                throw new RandoopLoggingError("Error writing to selection-log: " + e.getMessage());
            }
        }
    }

    private static @SignatureUnknown String toString(@SignatureUnknown Object o) {
        if (o instanceof Collection) {
            Collection coll = (Collection)o;
            switch (verbosity) {
                case 1: {
                    return coll.getClass() + " of size " + coll.size();
                }
                case 2: {
                    return coll.toString();
                }
            }
            throw new Error("verbosity = " + verbosity);
        }
        if (o instanceof SimpleList) {
            SimpleList sl = (SimpleList)o;
            switch (verbosity) {
                case 1: {
                    return sl.getClass() + " of size " + sl.size();
                }
                case 2: {
                    return sl.toJDKList().toString();
                }
            }
            throw new Error("verbosity = " + verbosity);
        }
        return o.toString();
    }
}

