/*
 * Decompiled with CFR 0.152.
 */
package randoop.util;

import coveredclass.org.checkerframework.checker.signature.qual.SignatureBottom;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import randoop.util.SimpleList;

public final class OneMoreElementList<@SignatureBottom T>
implements SimpleList<T>,
Serializable {
    private static final @SignatureUnknown long serialVersionUID = 1332963552183905833L;
    public final T lastElement;
    public final @SignatureUnknown SimpleList<T> list;
    public final @SignatureUnknown int size;

    public OneMoreElementList(@SignatureUnknown SimpleList<T> list, T extraElement) {
        this.list = list;
        this.lastElement = extraElement;
        this.size = list.size() + 1;
    }

    @Override
    public @SignatureUnknown int size() {
        return this.size;
    }

    @Override
    public @SignatureUnknown boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public T get(@SignatureUnknown int index) {
        if (index < this.size - 1) {
            return this.list.get(index);
        }
        if (index == this.size - 1) {
            return this.lastElement;
        }
        throw new IndexOutOfBoundsException("No such element: " + index);
    }

    @Override
    public @SignatureUnknown SimpleList<T> getSublist(@SignatureUnknown int index) {
        if (index == this.size - 1) {
            return this;
        }
        if (index < this.size - 1) {
            return this.list.getSublist(index);
        }
        throw new IndexOutOfBoundsException("No such index: " + index);
    }

    @Override
    public @SignatureUnknown List<T> toJDKList() {
        ArrayList<T> result = new ArrayList<T>();
        result.addAll(this.list.toJDKList());
        result.add(this.lastElement);
        return result;
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        return this.toJDKList().toString();
    }
}

