/*
 * Decompiled with CFR 0.152.
 */
package randoop.util;

import coveredclass.org.checkerframework.checker.signature.qual.SignatureBottom;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class MultiSet<@SignatureBottom T> {
    private final @SignatureUnknown Map<T, @SignatureUnknown Integer> frequencyMap = new LinkedHashMap<T, Integer>();

    public void add(T obj) {
        Integer i = this.frequencyMap.get(obj);
        if (i == null) {
            i = 0;
        }
        this.frequencyMap.put(obj, i + 1);
    }

    public void remove(T obj) {
        Integer i = this.frequencyMap.get(obj);
        if (i == null || i < 1) {
            throw new IllegalStateException("Variable not found when trying to remove from multiset. Variable: " + obj);
        }
        if (i == 1) {
            this.frequencyMap.remove(obj);
        } else {
            this.frequencyMap.put(obj, i - 1);
        }
    }

    public @SignatureUnknown Set<T> getElements() {
        return this.frequencyMap.keySet();
    }

    public @SignatureUnknown boolean isEmpty() {
        return this.frequencyMap.isEmpty();
    }

    public void removeAllInstances(@SignatureUnknown Set<T> values) {
        for (T value : values) {
            this.frequencyMap.remove(value);
        }
    }
}

