/*
 * Decompiled with CFR 0.152.
 */
package randoop.util;

import coveredclass.org.checkerframework.checker.signature.qual.SignatureBottom;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import randoop.util.IMultiMap;

public class MultiMap<@SignatureBottom T1, @SignatureBottom T2>
implements IMultiMap<T1, T2> {
    private final @SignatureUnknown Map<T1, @SignatureUnknown Set<T2>> map;

    public MultiMap() {
        this.map = new LinkedHashMap<T1, Set<T2>>();
    }

    public MultiMap(@SignatureUnknown int initialCapacity) {
        this.map = new LinkedHashMap<T1, Set<T2>>(initialCapacity);
    }

    public void put(T1 key, @SignatureUnknown Collection<@SignatureBottom ? extends T2> values) {
        if (this.contains(key)) {
            this.remove(key);
        }
        this.map.put(key, new LinkedHashSet<T2>(values));
    }

    public void addAll(@SignatureUnknown Map<@SignatureBottom ? extends T1, @SignatureBottom ? extends T2> m3) {
        for (T1 t1 : m3.keySet()) {
            this.add(t1, m3.get(t1));
        }
    }

    public void addAll(T1 key, @SignatureUnknown Collection<@SignatureBottom ? extends T2> values) {
        for (T2 t2 : values) {
            this.add(key, t2);
        }
    }

    public void addAll(@SignatureUnknown MultiMap<T1, T2> mmap) {
        for (Map.Entry<T1, Set<T2>> entry : mmap.map.entrySet()) {
            this.addAll(entry.getKey(), (Collection)entry.getValue());
        }
    }

    @Override
    public void add(T1 key, T2 value) {
        Set<T2> values = this.map.get(key);
        if (values == null) {
            values = new LinkedHashSet<T2>(1);
            this.map.put(key, values);
        }
        values.add(value);
    }

    @Override
    public void remove(T1 key, T2 value) {
        Set<T2> values = this.map.get(key);
        if (values == null) {
            throw new IllegalStateException("No values where found when trying to remove from multiset. Key: " + key + " Variable: " + value);
        }
        values.remove(value);
    }

    public void remove(T1 key) {
        Set<T2> values = this.map.get(key);
        if (values == null) {
            throw new IllegalStateException("No values where found when trying to remove from multiset. Key: " + key);
        }
        this.map.remove(key);
    }

    @Override
    public @SignatureUnknown Set<T2> getValues(T1 key) {
        Set<T2> values = this.map.get(key);
        if (values == null) {
            return Collections.emptySet();
        }
        return values;
    }

    @Override
    public @SignatureUnknown Set<T1> keySet() {
        return this.map.keySet();
    }

    public @SignatureUnknown boolean contains(T1 obj) {
        return this.map.containsKey(obj);
    }

    public void clear() {
        this.map.clear();
    }

    @Override
    public @SignatureUnknown int size() {
        return this.map.size();
    }

    public @SignatureUnknown boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    @SideEffectFree
    public @SignatureUnknown String toString() {
        return this.map.toString();
    }
}

