/*
 * Decompiled with CFR 0.152.
 */
package randoop.util;

import coveredclass.org.checkerframework.checker.formatter.qual.FormatMethod;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureBottom;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import org.plumelib.util.UtilPlume;
import randoop.main.GenInputsAbstract;
import randoop.main.RandoopBug;

public final class Log {
    private Log() {
        throw new IllegalStateException("no instance");
    }

    public static @SignatureUnknown boolean isLoggingOn() {
        return GenInputsAbstract.log != null;
    }

    @FormatMethod
    public static void logPrintf(@SignatureUnknown String fmt, Object ... args) {
        String msg;
        if (!Log.isLoggingOn()) {
            return;
        }
        try {
            msg = String.format(fmt, args);
        }
        catch (Throwable t) {
            Log.logPrintf("A user-defined toString() method failed.%n", new Object[0]);
            Object[] argTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argTypes[i] = args[i].getClass();
            }
            Log.logPrintf("  fmt = %s%n", fmt);
            Log.logPrintf("  arg types = %s%n", Arrays.toString(argTypes));
            Log.logStackTrace(t);
            return;
        }
        try {
            GenInputsAbstract.log.write(msg);
            GenInputsAbstract.log.flush();
        }
        catch (IOException e) {
            throw new RandoopBug("Exception while writing to log", e);
        }
    }

    @FormatMethod
    public static void logPrintln(@SignatureUnknown String msg) {
        if (!Log.isLoggingOn()) {
            return;
        }
        try {
            GenInputsAbstract.log.write(msg);
            GenInputsAbstract.log.write(System.lineSeparator());
            GenInputsAbstract.log.flush();
        }
        catch (IOException e) {
            throw new RandoopBug("Exception while writing to log", e);
        }
    }

    public static void logStackTrace(@SignatureUnknown Throwable t) {
        if (!Log.isLoggingOn()) {
            return;
        }
        try {
            PrintWriter pw = new PrintWriter(GenInputsAbstract.log);
            t.printStackTrace(pw);
            pw.flush();
            GenInputsAbstract.log.flush();
        }
        catch (IOException e) {
            throw new RandoopBug("Exception while writing to log", e);
        }
    }

    @SideEffectFree
    public static @SignatureUnknown String toStringAndClass(@SignatureUnknown Object v) {
        return Log.toStringAndClass(v, false);
    }

    @SideEffectFree
    private static @SignatureUnknown String toStringAndClass(@SignatureUnknown Object v, @SignatureUnknown boolean shallow) {
        if (v == null) {
            return "null";
        }
        if (v.getClass() == Object.class) {
            return "a value of class " + v.getClass();
        }
        if (v.getClass().isArray()) {
            return Log.arrayToStringAndClass(v);
        }
        if (v instanceof List) {
            return Log.listToStringAndClass((List)v, shallow);
        }
        try {
            String formatted = UtilPlume.escapeJava(v.toString());
            return String.format("%s [%s]", formatted, v.getClass());
        }
        catch (Exception e) {
            return String.format("exception_when_calling_toString [%s]", v.getClass());
        }
    }

    @SideEffectFree
    public static @SignatureUnknown String listToStringAndClass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown List<@SignatureUnknown @SignatureBottom ?> lst, @SignatureUnknown boolean shallow) {
        if (lst == null) {
            return "null";
        }
        return Log.listToString(lst, false) + " [" + lst.getClass() + "]";
    }

    @SideEffectFree
    public static @SignatureUnknown String listToString(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown List<@SignatureUnknown @SignatureBottom ?> lst, @SignatureUnknown boolean shallow) {
        if (lst == null) {
            return "null";
        }
        if (shallow) {
            return lst.toString();
        }
        StringJoiner sj = new StringJoiner(", ", "[", "]");
        for (Object o : lst) {
            sj.add(Log.toStringAndClass(o, true));
        }
        return sj.toString();
    }

    @SideEffectFree
    public static @SignatureUnknown String arrayToStringAndClass(@SignatureUnknown Object a) {
        if (a == null) {
            return "null";
        }
        String theClass = " [" + a.getClass() + "]";
        if (a instanceof boolean[]) {
            return Arrays.toString((boolean[])a) + theClass;
        }
        if (a instanceof byte[]) {
            return Arrays.toString((byte[])a) + theClass;
        }
        if (a instanceof char[]) {
            return Arrays.toString((char[])a) + theClass;
        }
        if (a instanceof double[]) {
            return Arrays.toString((double[])a) + theClass;
        }
        if (a instanceof float[]) {
            return Arrays.toString((float[])a) + theClass;
        }
        if (a instanceof int[]) {
            return Arrays.toString((int[])a) + theClass;
        }
        if (a instanceof long[]) {
            return Arrays.toString((long[])a) + theClass;
        }
        if (a instanceof short[]) {
            return Arrays.toString((short[])a) + theClass;
        }
        if (a instanceof Object[]) {
            try {
                return Log.listToString(Arrays.asList((Object[])a), false) + theClass;
            }
            catch (Exception e) {
                return String.format("exception_when_printing_array" + theClass, new Object[0]);
            }
        }
        throw new IllegalArgumentException("Argument is not an array; its class is " + a.getClass().getName());
    }
}

