/*
 * Decompiled with CFR 0.152.
 */
package randoop.util;

import coveredclass.org.checkerframework.checker.signature.qual.SignatureBottom;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import randoop.util.MultiSet;

public class KeyToMultiSet<@SignatureBottom T1, @SignatureBottom T2> {
    private final @SignatureUnknown Map<T1, @SignatureUnknown MultiSet<T2>> map = new LinkedHashMap<T1, MultiSet<T2>>();

    public void addAll(@SignatureUnknown Map<@SignatureBottom ? extends T1, @SignatureBottom ? extends T2> m3) {
        for (T1 t1 : m3.keySet()) {
            this.add(t1, m3.get(t1));
        }
    }

    public void addAll(T1 key, @SignatureUnknown Collection<@SignatureBottom ? extends T2> values) {
        for (T2 t2 : values) {
            this.add(key, t2);
        }
    }

    public void add(T1 key, T2 value) {
        MultiSet<Object> values = this.map.get(key);
        if (values == null) {
            values = new MultiSet();
        }
        values.add(value);
        this.map.put(key, values);
    }

    public void remove(T1 key, T2 value) {
        MultiSet<T2> values = this.map.get(key);
        if (values == null) {
            throw new IllegalStateException("No values where found when trying to remove from multiset. Key: " + key + " Variable: " + value);
        }
        values.remove(value);
    }

    public void remove(T1 key) {
        MultiSet<T2> values = this.map.get(key);
        if (values == null) {
            throw new IllegalStateException("No values where found when trying to remove from multiset. Key: " + key);
        }
        this.map.remove(key);
    }

    public @SignatureUnknown Set<T2> getVariables(T1 key) {
        MultiSet<T2> values = this.map.get(key);
        if (values == null) {
            return Collections.emptySet();
        }
        return values.getElements();
    }

    public @SignatureUnknown Set<T1> keySet() {
        return this.map.keySet();
    }

    public @SignatureUnknown boolean contains(T1 obj) {
        return this.map.containsKey(obj);
    }

    public void clean() {
        Iterator<Map.Entry<T1, MultiSet<T2>>> iter = this.map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<T1, MultiSet<T2>> element = iter.next();
            if (!element.getValue().isEmpty()) continue;
            iter.remove();
        }
    }

    public void removeAllInstances(@SignatureUnknown Set<T2> values) {
        for (MultiSet<T2> multiSet : this.map.values()) {
            multiSet.removeAllInstances(values);
        }
    }

    public void clear() {
        this.map.clear();
    }

    public @SignatureUnknown int size() {
        return this.map.size();
    }

    public @SignatureUnknown boolean isEmpty() {
        return this.map.isEmpty();
    }
}

