/*
 * Decompiled with CFR 0.152.
 */
package randoop.util;

import coveredclass.org.checkerframework.checker.signature.qual.SignatureBottom;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import randoop.util.IMultiMap;
import randoop.util.Log;

public class CheckpointingMultiMap<@SignatureBottom T1, @SignatureBottom T2>
implements IMultiMap<T1, T2> {
    public static @SignatureUnknown boolean verbose_log = false;
    private final @SignatureUnknown Map<T1, @SignatureUnknown Set<T2>> map = new LinkedHashMap<T1, Set<T2>>();
    public final @SignatureUnknown List<@SignatureUnknown Integer> marks = new ArrayList<Integer>();
    private final @SignatureUnknown List<@SignatureUnknown CheckpointingMultiMap. @SignatureUnknown OpKeyVal> ops = new ArrayList<OpKeyVal>();
    private @SignatureUnknown int steps = 0;

    @Override
    public void add(T1 key, T2 value) {
        if (verbose_log) {
            Log.logPrintf("ADD %s -> %s%n", key, value);
        }
        this.add_bare(key, value);
        this.ops.add(new OpKeyVal(Ops.ADD, key, value));
        ++this.steps;
    }

    private void add_bare(T1 key, T2 value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("args cannot be null.");
        }
        Set<T2> values = this.map.get(key);
        if (values == null) {
            values = new LinkedHashSet<T2>(1);
            this.map.put(key, values);
        }
        if (values.contains(value)) {
            throw new IllegalArgumentException("Mapping already present: " + key + " -> " + value);
        }
        values.add(value);
    }

    @Override
    public void remove(T1 key, T2 value) {
        if (verbose_log) {
            Log.logPrintf("REMOVE %s -> %s%n", key, value);
        }
        this.remove_bare(key, value);
        this.ops.add(new OpKeyVal(Ops.REMOVE, key, value));
        ++this.steps;
    }

    private void remove_bare(T1 key, T2 value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("args cannot be null.");
        }
        Set<T2> values = this.map.get(key);
        if (values == null) {
            throw new IllegalArgumentException("Mapping not present: " + key + " -> " + value);
        }
        values.remove(value);
        if (values.isEmpty()) {
            this.map.remove(key);
        }
    }

    public void mark() {
        this.marks.add(this.steps);
        this.steps = 0;
    }

    public void undoToLastMark() {
        if (this.marks.isEmpty()) {
            throw new IllegalArgumentException("No marks.");
        }
        Log.logPrintf("marks: %s%n", this.marks);
        for (int i = 0; i < this.steps; ++i) {
            this.undoLastOp();
        }
        this.steps = this.marks.remove(this.marks.size() - 1);
    }

    private void undoLastOp() {
        if (this.ops.isEmpty()) {
            throw new IllegalStateException("ops empty.");
        }
        OpKeyVal last = this.ops.remove(this.ops.size() - 1);
        Ops op = last.op;
        Object key = last.key;
        Object val = last.val;
        if (op == Ops.ADD) {
            Log.logPrintf("REMOVE %s%n", key + " ->" + val);
            this.remove_bare(key, val);
        } else if (op == Ops.REMOVE) {
            Log.logPrintf("ADD %s -> %s%n", key, val);
            this.add_bare(key, val);
        } else {
            throw new IllegalStateException("Unhandled op: " + (Object)((Object)op));
        }
    }

    @Override
    public @SignatureUnknown Set<T2> getValues(T1 key) {
        if (key == null) {
            throw new IllegalArgumentException("arg cannot be null.");
        }
        Set<T2> values = this.map.get(key);
        if (values == null) {
            return Collections.emptySet();
        }
        return values;
    }

    @Override
    public @SignatureUnknown Set<T1> keySet() {
        return this.map.keySet();
    }

    @Override
    public @SignatureUnknown int size() {
        return this.map.size();
    }

    @Override
    @SideEffectFree
    public @SignatureUnknown String toString() {
        return this.map.toString();
    }

    private class OpKeyVal {
        final @SignatureUnknown Ops op;
        final T1 key;
        final T2 val;

        OpKeyVal(Ops op, T1 key, T2 val) {
            this.op = op;
            this.key = key;
            this.val = val;
        }
    }

    private static enum Ops {
        ADD,
        REMOVE;

    }
}

