/*
 * Decompiled with CFR 0.152.
 */
package randoop.types;

import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.util.HashSet;
import java.util.Objects;
import randoop.types.EagerReferenceBound;
import randoop.types.JavaTypes;
import randoop.types.ParameterBound;
import randoop.types.ParameterType;
import randoop.types.Substitution;

class WildcardType
extends ParameterType {
    private final @SignatureUnknown boolean hasUpperBound;

    private WildcardType() {
        this.hasUpperBound = false;
    }

    WildcardType(@SignatureUnknown ParameterBound bound, @SignatureUnknown boolean hasUpperBound) {
        this.hasUpperBound = hasUpperBound;
        if (hasUpperBound) {
            this.setUpperBound(bound);
        } else {
            this.setLowerBound(bound);
        }
    }

    public static @SignatureUnknown WildcardType forType(@SignatureUnknown java.lang.reflect.WildcardType type) {
        if (type.getLowerBounds().length > 0) {
            assert (type.getLowerBounds().length == 1) : "a wildcard is defined by the JLS to only have one bound";
            return new WildcardType(ParameterBound.forTypes(new HashSet(), type.getLowerBounds()), false);
        }
        if (type.getUpperBounds().length > 0) {
            assert (type.getUpperBounds().length == 1) : "a wildcard is defined by the JLS to only have one bound";
            return new WildcardType(ParameterBound.forTypes(new HashSet(), type.getUpperBounds()), true);
        }
        throw new IllegalArgumentException("A wildcard must have either upper or lower bounds");
    }

    @Override
    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WildcardType)) {
            return false;
        }
        WildcardType otherType = (WildcardType)obj;
        return otherType.hasUpperBound == this.hasUpperBound && super.equals(otherType);
    }

    @Override
    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.hasUpperBound, super.hashCode());
    }

    @Override
    @SideEffectFree
    public @SignatureUnknown String toString() {
        if (this.hasUpperBound) {
            if (this.getUpperTypeBound().isObject()) {
                return "?";
            }
            return "? extends " + this.getUpperTypeBound().toString();
        }
        return "? super " + this.getLowerTypeBound().toString();
    }

    @Override
    public @SignatureUnknown String getFqName() {
        if (this.hasUpperBound) {
            if (this.getUpperTypeBound().isObject()) {
                return "?";
            }
            return "? extends " + this.getUpperTypeBound().toString();
        }
        return "? super " + this.getLowerTypeBound().toString();
    }

    @Override
    public @SignatureUnknown String getBinaryName() {
        if (this.hasUpperBound) {
            if (this.getUpperTypeBound().isObject()) {
                return "?";
            }
            return "? extends " + this.getUpperTypeBound().toString();
        }
        return "? super " + this.getLowerTypeBound().toString();
    }

    @Override
    public @SignatureUnknown String getSimpleName() {
        return this.toString();
    }

    public @SignatureUnknown ParameterBound getTypeBound() {
        if (this.hasUpperBound) {
            return this.getUpperTypeBound();
        }
        return this.getLowerTypeBound();
    }

    @Override
    public @SignatureUnknown WildcardType substitute(@SignatureUnknown Substitution substitution) {
        ParameterBound bound = this.getTypeBound().substitute(substitution);
        if (bound.equals(this.getTypeBound())) {
            return this;
        }
        return new WildcardType(bound, this.hasUpperBound);
    }

    @Override
    public @SignatureUnknown WildcardType applyCaptureConversion() {
        if (this.getTypeBound().hasWildcard()) {
            EagerReferenceBound convertedType = (EagerReferenceBound)this.getTypeBound().applyCaptureConversion();
            return new WildcardType((ParameterBound)convertedType, this.hasUpperBound);
        }
        return this;
    }

    public @SignatureUnknown boolean contains(@SignatureUnknown WildcardType otherType) {
        if (this.hasUpperBound) {
            return otherType.hasUpperBound && this.getUpperTypeBound().isSubtypeOf(otherType.getUpperTypeBound());
        }
        if (otherType.hasUpperBound) {
            return otherType.getUpperTypeBound().equals(new EagerReferenceBound(JavaTypes.OBJECT_TYPE));
        }
        return otherType.getLowerTypeBound().isSubtypeOf(this.getLowerTypeBound());
    }

    @Override
    public @SignatureUnknown boolean isGeneric(@SignatureUnknown boolean ignoreWildcards) {
        return this.getTypeBound().isGeneric(ignoreWildcards);
    }

    @SignatureUnknown boolean hasUpperBound() {
        return this.hasUpperBound;
    }
}

