/*
 * Decompiled with CFR 0.152.
 */
package randoop.types;

import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import randoop.types.ExplicitTypeVariable;
import randoop.types.ReferenceType;
import randoop.types.TypeVariable;

public class Substitution {
    private @SignatureUnknown Map<@SignatureUnknown TypeVariable, @SignatureUnknown ReferenceType> map;
    private @SignatureUnknown Map<@SignatureUnknown Type, @SignatureUnknown ReferenceType> rawMap;
    private static @SignatureUnknown BiFunction<@SignatureUnknown ReferenceType, @SignatureUnknown ReferenceType, @SignatureUnknown ReferenceType> requireSameEntry = (v1, v2) -> {
        if (v1 == null) {
            return v2;
        }
        if (v2 == null) {
            return v1;
        }
        if (v1.equals(v2)) {
            return v1;
        }
        throw new IllegalArgumentException(String.format("Substitutions map a key to distinct types %s and %s", v1, v2));
    };

    public Substitution() {
        this.map = new LinkedHashMap<TypeVariable, ReferenceType>();
        this.rawMap = new LinkedHashMap<Type, ReferenceType>();
    }

    public Substitution(@SignatureUnknown Substitution substitution) {
        this.map = new LinkedHashMap<TypeVariable, ReferenceType>(substitution.map);
        this.rawMap = new LinkedHashMap<Type, ReferenceType>(substitution.rawMap);
    }

    public Substitution(@SignatureUnknown TypeVariable parameter, @SignatureUnknown ReferenceType argument) {
        this();
        this.put(parameter, argument);
    }

    public Substitution(@SignatureUnknown List<@SignatureUnknown TypeVariable> parameters, ReferenceType ... arguments) {
        this();
        assert (parameters.size() == arguments.length) : "parameters=" + parameters + "  arguments=" + Arrays.toString(arguments);
        for (int i = 0; i < parameters.size(); ++i) {
            this.put(parameters.get(i), arguments[i]);
        }
    }

    public Substitution(@SignatureUnknown List<@SignatureUnknown TypeVariable> parameters, @SignatureUnknown List<@SignatureUnknown ReferenceType> arguments) {
        this();
        assert (parameters.size() == arguments.size());
        for (int i = 0; i < parameters.size(); ++i) {
            this.put(parameters.get(i), arguments.get(i));
        }
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Substitution)) {
            return false;
        }
        Substitution s2 = (Substitution)obj;
        return this.map.equals(s2.map);
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.map);
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        return this.map.toString();
    }

    public @SignatureUnknown boolean isConsistentWith(@SignatureUnknown Substitution substitution) {
        for (Map.Entry<TypeVariable, ReferenceType> entry : substitution.map.entrySet()) {
            if (!this.map.containsKey(entry.getKey()) || this.get(entry.getKey()).equals(entry.getValue())) continue;
            return false;
        }
        for (Map.Entry<Object, ReferenceType> entry : substitution.rawMap.entrySet()) {
            if (!this.rawMap.containsKey(entry.getKey()) || this.get((Type)entry.getKey()).equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public @SignatureUnknown Substitution extend(@SignatureUnknown List<@SignatureUnknown TypeVariable> parameters, @SignatureUnknown List<@SignatureUnknown ReferenceType> arguments) {
        return this.extend(new Substitution(parameters, arguments));
    }

    public @SignatureUnknown Substitution extend(@SignatureUnknown Substitution other) {
        Substitution result = new Substitution(this);
        for (Map.Entry<TypeVariable, ReferenceType> entry : other.map.entrySet()) {
            result.map.merge(entry.getKey(), entry.getValue(), requireSameEntry);
        }
        for (Map.Entry<Object, ReferenceType> entry : other.rawMap.entrySet()) {
            result.rawMap.merge((Type)entry.getKey(), entry.getValue(), requireSameEntry);
        }
        return result;
    }

    public @SignatureUnknown ReferenceType get(@SignatureUnknown TypeVariable parameter) {
        return this.map.get(parameter);
    }

    public @SignatureUnknown ReferenceType get(@SignatureUnknown Type parameter) {
        return this.rawMap.get(parameter);
    }

    public @SignatureUnknown Set<@SignatureUnknown TypeVariable> keySet() {
        return this.map.keySet();
    }

    public void print() {
        for (Map.Entry<TypeVariable, ReferenceType> entry : this.map.entrySet()) {
            System.out.println(entry.getKey() + "(" + entry.getKey() + ") := " + entry.getValue());
        }
    }

    private void put(@SignatureUnknown TypeVariable typeParameter, @SignatureUnknown ReferenceType type) {
        this.map.put(typeParameter, type);
        if (typeParameter instanceof ExplicitTypeVariable) {
            this.rawMap.put(((ExplicitTypeVariable)typeParameter).getReflectionTypeVariable(), type);
        }
    }

    public @SignatureUnknown boolean isEmpty() {
        return this.map.isEmpty();
    }
}

