/*
 * Decompiled with CFR 0.152.
 */
package randoop.types;

import coveredclass.org.checkerframework.checker.signature.qual.SignatureBottom;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.lang.reflect.GenericArrayType;
import java.util.ArrayList;
import java.util.List;
import randoop.types.ArrayType;
import randoop.types.ClassOrInterfaceType;
import randoop.types.Substitution;
import randoop.types.Type;
import randoop.types.TypeVariable;

public abstract class ReferenceType
extends Type {
    public static @SignatureUnknown ReferenceType forClass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> classType) {
        if (classType.isPrimitive()) {
            throw new IllegalArgumentException("type must be a reference type");
        }
        if (classType.isArray()) {
            return ArrayType.forClass(classType);
        }
        return ClassOrInterfaceType.forClass(classType);
    }

    public static @SignatureUnknown ReferenceType forType(@SignatureUnknown java.lang.reflect.Type type) {
        if (type instanceof GenericArrayType) {
            return ArrayType.forType(type);
        }
        if (type instanceof java.lang.reflect.TypeVariable) {
            return TypeVariable.forType(type);
        }
        if (type instanceof Class && ((Class)type).isArray()) {
            return ArrayType.forType(type);
        }
        return ClassOrInterfaceType.forType(type);
    }

    @Override
    public abstract @SignatureUnknown ReferenceType substitute(@SignatureUnknown Substitution var1);

    @Override
    public @SignatureUnknown ReferenceType applyCaptureConversion() {
        return this;
    }

    public @SignatureUnknown List<@SignatureUnknown TypeVariable> getTypeParameters() {
        return new ArrayList<TypeVariable>();
    }

    @Override
    public @SignatureUnknown boolean isAssignableFrom(@SignatureUnknown Type sourceType) {
        return super.isAssignableFrom(sourceType) || sourceType.isReferenceType() && sourceType.isSubtypeOf(this);
    }

    public @SignatureUnknown boolean isCaptureVariable() {
        return false;
    }

    public @SignatureUnknown boolean isInstantiationOf(@SignatureUnknown ReferenceType otherType) {
        if (this.equals(otherType)) {
            return true;
        }
        if (otherType.isVariable()) {
            TypeVariable variable = (TypeVariable)otherType;
            return variable.canBeInstantiatedBy(this);
        }
        return false;
    }

    public @SignatureUnknown Substitution getInstantiatingSubstitution(@SignatureUnknown ReferenceType goalType) {
        return ReferenceType.getInstantiatingSubstitutionforTypeVariable(this, goalType);
    }

    public static @SignatureUnknown Substitution getInstantiatingSubstitutionforTypeVariable(@SignatureUnknown ReferenceType instantiatedType, @SignatureUnknown ReferenceType goalType) {
        if (instantiatedType.equals(goalType)) {
            return new Substitution();
        }
        if (goalType.isVariable()) {
            TypeVariable variable = (TypeVariable)goalType;
            Substitution substitution = new Substitution(variable, instantiatedType);
            if (variable.getLowerTypeBound().isLowerBound(instantiatedType, substitution) && variable.getUpperTypeBound().isUpperBound(instantiatedType, substitution)) {
                return substitution;
            }
        }
        return null;
    }

    @Override
    public @SignatureUnknown boolean isReferenceType() {
        return true;
    }

    @Override
    public @SignatureUnknown boolean isSubtypeOf(@SignatureUnknown Type otherType) {
        if (otherType == null) {
            throw new IllegalArgumentException("type may not be null");
        }
        return super.isSubtypeOf(otherType) || otherType.isObject();
    }
}

