/*
 * Decompiled with CFR 0.152.
 */
package randoop.types;

import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.util.Objects;
import randoop.types.ParameterBound;
import randoop.types.ReferenceType;
import randoop.types.Substitution;

public abstract class ReferenceBound
extends ParameterBound {
    private final @SignatureUnknown ReferenceType boundType;

    ReferenceBound(@SignatureUnknown ReferenceType boundType) {
        this.boundType = boundType;
    }

    public @SignatureUnknown ReferenceType getBoundType() {
        return this.boundType;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ReferenceBound)) {
            return false;
        }
        ReferenceBound bound = (ReferenceBound)obj;
        return this.boundType.equals(bound.boundType);
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.boundType);
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        return this.boundType.toString();
    }

    @Override
    public abstract @SignatureUnknown ReferenceBound substitute(@SignatureUnknown Substitution var1);

    @Override
    public abstract @SignatureUnknown ReferenceBound applyCaptureConversion();

    @Override
    @SignatureUnknown boolean hasWildcard() {
        return this.boundType.hasWildcard();
    }

    @Override
    public @SignatureUnknown boolean hasCaptureVariable() {
        return this.boundType.hasCaptureVariable();
    }

    @Override
    public @SignatureUnknown boolean isGeneric(@SignatureUnknown boolean ignoreWildcards) {
        return this.boundType.isGeneric(ignoreWildcards);
    }

    @Override
    public @SignatureUnknown boolean isObject() {
        return this.boundType.isObject();
    }

    @Override
    public @SignatureUnknown boolean isVariable() {
        return this.boundType.isVariable();
    }
}

