/*
 * Decompiled with CFR 0.152.
 */
package randoop.types;

import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import randoop.types.CaptureTypeVariable;
import randoop.types.ClassOrInterfaceType;
import randoop.types.EagerReferenceBound;
import randoop.types.ParameterBound;
import randoop.types.ReferenceType;
import randoop.types.Substitution;
import randoop.types.TypeArgument;
import randoop.types.TypeVariable;
import randoop.types.WildcardArgument;

public class ReferenceArgument
extends TypeArgument {
    private final @SignatureUnknown ReferenceType referenceType;

    private ReferenceArgument(@SignatureUnknown ReferenceType referenceType) {
        this.referenceType = referenceType;
    }

    public static @SignatureUnknown ReferenceArgument forType(@SignatureUnknown Type type) {
        return ReferenceArgument.forType(ReferenceType.forType(type));
    }

    public static @SignatureUnknown ReferenceArgument forType(@SignatureUnknown ReferenceType referenceType) {
        return new ReferenceArgument(referenceType);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ReferenceArgument)) {
            return false;
        }
        ReferenceArgument referenceArgument = (ReferenceArgument)obj;
        return this.referenceType.equals(referenceArgument.referenceType);
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.referenceType);
    }

    @Override
    public @SignatureUnknown String getFqName() {
        return this.referenceType.getFqName();
    }

    @Override
    public @SignatureUnknown String getBinaryName() {
        return this.referenceType.getBinaryName();
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        return this.referenceType.toString();
    }

    @Override
    public @SignatureUnknown TypeArgument substitute(@SignatureUnknown Substitution substitution) {
        return TypeArgument.forType(this.referenceType.substitute(substitution));
    }

    @Override
    public @SignatureUnknown boolean contains(@SignatureUnknown TypeArgument otherArgument) {
        if (otherArgument.isWildcard()) {
            ParameterBound boundType = ((WildcardArgument)otherArgument).getTypeBound();
            return boundType.equals(new EagerReferenceBound(this.referenceType));
        }
        return this.referenceType.equals(((ReferenceArgument)otherArgument).getReferenceType());
    }

    public @SignatureUnknown ReferenceType getReferenceType() {
        return this.referenceType;
    }

    @Override
    public @SignatureUnknown List<@SignatureUnknown TypeVariable> getTypeParameters() {
        return this.referenceType.getTypeParameters();
    }

    @Override
    public @SignatureUnknown boolean hasWildcard() {
        return this.referenceType.isParameterized() && ((ClassOrInterfaceType)this.referenceType).hasWildcard();
    }

    @Override
    public @SignatureUnknown boolean hasCaptureVariable() {
        return this.referenceType instanceof CaptureTypeVariable || this.referenceType.isParameterized() && ((ClassOrInterfaceType)this.referenceType).hasCaptureVariable();
    }

    @Override
    public @SignatureUnknown boolean isGeneric(@SignatureUnknown boolean ignoreWildcards) {
        return this.referenceType.isGeneric(ignoreWildcards);
    }

    @Override
    @SignatureUnknown boolean isInstantiationOfTypeArgument(@SignatureUnknown TypeArgument otherArgument) {
        if (!(otherArgument instanceof ReferenceArgument)) {
            return false;
        }
        ReferenceType otherReferenceType = ((ReferenceArgument)otherArgument).getReferenceType();
        return this.referenceType.isInstantiationOf(otherReferenceType);
    }

    @Override
    public @SignatureUnknown Substitution getInstantiatingSubstitution(@SignatureUnknown TypeArgument otherArgument) {
        if (!(otherArgument instanceof ReferenceArgument)) {
            return null;
        }
        ReferenceType otherReferenceType = ((ReferenceArgument)otherArgument).getReferenceType();
        return this.referenceType.getInstantiatingSubstitution(otherReferenceType);
    }

    @Override
    public @SignatureUnknown boolean isVariable() {
        return this.referenceType.isVariable();
    }
}

