/*
 * Decompiled with CFR 0.152.
 */
package randoop.types;

import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureBottom;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import randoop.types.JavaTypes;
import randoop.types.ReferenceType;
import randoop.types.Substitution;
import randoop.types.Type;

class NullReferenceType
extends ReferenceType {
    private static final @SignatureUnknown NullReferenceType value = new NullReferenceType();

    private NullReferenceType() {
    }

    static @SignatureUnknown NullReferenceType getNullType() {
        return value;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NullReferenceType)) {
            return false;
        }
        return obj == value;
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> getRuntimeClass() {
        return null;
    }

    @Override
    public @SignatureUnknown ReferenceType substitute(@SignatureUnknown Substitution substitution) {
        return this;
    }

    @Override
    public @SignatureUnknown String getFqName() {
        return "NullType";
    }

    @Override
    public @SignatureUnknown String getBinaryName() {
        return "NullType";
    }

    @Override
    public @SignatureUnknown String getSimpleName() {
        return this.getFqName();
    }

    @Override
    public @SignatureUnknown String getCanonicalName() {
        return this.getFqName();
    }

    @Override
    public @SignatureUnknown boolean hasWildcard() {
        return false;
    }

    @Override
    public @SignatureUnknown boolean hasCaptureVariable() {
        return false;
    }

    @Override
    public @SignatureUnknown boolean isSubtypeOf(@SignatureUnknown Type otherType) {
        return !otherType.equals(JavaTypes.VOID_TYPE) && otherType.isReferenceType();
    }
}

