/*
 * Decompiled with CFR 0.152.
 */
package randoop.types;

import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureBottom;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import randoop.types.ClassOrInterfaceType;
import randoop.types.JavaTypes;
import randoop.types.PrimitiveType;
import randoop.types.PrimitiveTypes;
import randoop.types.ReferenceType;
import randoop.types.Substitution;
import randoop.types.Type;

public class NonParameterizedType
extends ClassOrInterfaceType {
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> runtimeType;
    private static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Map<@SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?>, @SignatureUnknown NonParameterizedType> cache = new HashMap();

    public static @SignatureUnknown NonParameterizedType forClass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> runtimeType) {
        NonParameterizedType cached = cache.get(runtimeType);
        if (cached == null) {
            cached = new NonParameterizedType(runtimeType);
            cache.put(runtimeType, cached);
        }
        return cached;
    }

    public NonParameterizedType(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> runtimeType) {
        assert (!runtimeType.isPrimitive()) : "must be reference type, got " + runtimeType.getName();
        this.runtimeType = runtimeType;
        Class<?> enclosingClass = runtimeType.getEnclosingClass();
        if (enclosingClass != null) {
            this.setEnclosingType(ClassOrInterfaceType.forClass(enclosingClass));
        }
    }

    @Override
    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NonParameterizedType)) {
            return false;
        }
        NonParameterizedType other = (NonParameterizedType)obj;
        return super.equals(obj) && this.runtimeType.equals(other.runtimeType);
    }

    @Override
    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.runtimeType);
    }

    @Override
    public @SignatureUnknown NonParameterizedType substitute(@SignatureUnknown Substitution substitution) {
        return (NonParameterizedType)this.substitute(substitution, new NonParameterizedType(this.runtimeType));
    }

    @Override
    public @SignatureUnknown NonParameterizedType applyCaptureConversion() {
        return (NonParameterizedType)this.applyCaptureConversion(this);
    }

    @Override
    public @SignatureUnknown List<@SignatureUnknown ClassOrInterfaceType> getInterfaces() {
        if (this.isRawtype()) {
            return this.getRawTypeInterfaces();
        }
        return this.getGenericInterfaces();
    }

    private @SignatureUnknown List<@SignatureUnknown ClassOrInterfaceType> getGenericInterfaces() {
        ArrayList<ClassOrInterfaceType> interfaces = new ArrayList<ClassOrInterfaceType>();
        for (java.lang.reflect.Type type : this.runtimeType.getGenericInterfaces()) {
            interfaces.add(ClassOrInterfaceType.forType(type));
        }
        return interfaces;
    }

    @Override
    public @SignatureUnknown NonParameterizedType getRawtype() {
        return this;
    }

    private @SignatureUnknown List<@SignatureUnknown ClassOrInterfaceType> getRawTypeInterfaces() {
        ArrayList<ClassOrInterfaceType> interfaces = new ArrayList<ClassOrInterfaceType>();
        for (Class<?> c : this.runtimeType.getInterfaces()) {
            interfaces.add(NonParameterizedType.forClass(c));
        }
        return interfaces;
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> getRuntimeClass() {
        return this.runtimeType;
    }

    @Override
    public @SignatureUnknown ClassOrInterfaceType getSuperclass() {
        if (this.isObject()) {
            return this;
        }
        if (this.isRawtype()) {
            Class<?> superclass = this.runtimeType.getSuperclass();
            if (superclass != null) {
                return NonParameterizedType.forClass(superclass);
            }
        } else {
            java.lang.reflect.Type supertype = this.runtimeType.getGenericSuperclass();
            if (supertype != null) {
                return ClassOrInterfaceType.forType(supertype);
            }
        }
        return JavaTypes.OBJECT_TYPE;
    }

    @Override
    public @SignatureUnknown boolean isAbstract() {
        return Modifier.isAbstract(Modifier.classModifiers() & this.runtimeType.getModifiers());
    }

    @Override
    public @SignatureUnknown boolean isAssignableFrom(@SignatureUnknown Type sourceType) {
        if (super.isAssignableFrom(sourceType)) {
            return true;
        }
        return sourceType.isPrimitive() && !sourceType.isVoid() && this.isAssignableFrom(((PrimitiveType)sourceType).toBoxedPrimitive());
    }

    @Override
    public @SignatureUnknown boolean isBoxedPrimitive() {
        return PrimitiveTypes.isBoxedPrimitive(this.getRuntimeClass());
    }

    @Override
    public @SignatureUnknown boolean isEnum() {
        return this.runtimeType.isEnum();
    }

    @Override
    public @SignatureUnknown boolean isInstantiationOf(@SignatureUnknown ReferenceType otherType) {
        boolean instantiationOf = super.isInstantiationOf(otherType);
        if (otherType instanceof NonParameterizedType) {
            return instantiationOf && this.runtimeClassIs(otherType.getRuntimeClass());
        }
        return instantiationOf;
    }

    @Override
    public @SignatureUnknown boolean isInterface() {
        return this.runtimeType.isInterface();
    }

    @Override
    public @SignatureUnknown boolean isRawtype() {
        return this.runtimeType.getTypeParameters().length > 0;
    }

    @Override
    public @SignatureUnknown boolean isStatic() {
        return Modifier.isStatic(this.runtimeType.getModifiers() & Modifier.classModifiers());
    }

    public @SignatureUnknown PrimitiveType toPrimitive() {
        if (this.isBoxedPrimitive()) {
            Class<?> primitiveClass = PrimitiveTypes.toUnboxedType(this.getRuntimeClass());
            return PrimitiveType.forClass(primitiveClass);
        }
        throw new IllegalArgumentException("Type must be boxed primitive");
    }
}

