/*
 * Decompiled with CFR 0.152.
 */
package randoop.types;

import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import randoop.main.RandoopBug;
import randoop.types.ClassOrInterfaceType;
import randoop.types.EagerReferenceBound;
import randoop.types.GenericClassType;
import randoop.types.InstantiatedType;
import randoop.types.LazyReferenceBound;
import randoop.types.ParameterBound;
import randoop.types.ReferenceType;
import randoop.types.Substitution;
import randoop.types.Type;
import randoop.types.TypeArgument;
import randoop.types.TypeVariable;
import randoop.types.WildcardArgument;
import randoop.types.WildcardType;

class LazyParameterBound
extends ParameterBound {
    private final @SignatureUnknown java.lang.reflect.Type boundType;

    LazyParameterBound(@SignatureUnknown java.lang.reflect.Type boundType) {
        this.boundType = boundType;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LazyParameterBound)) {
            return false;
        }
        LazyParameterBound b = (LazyParameterBound)obj;
        return this.boundType.equals(b.boundType);
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.boundType);
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        return this.boundType.toString();
    }

    @Override
    public @SignatureUnknown ParameterBound substitute(@SignatureUnknown Substitution substitution) {
        if (substitution.isEmpty()) {
            return this;
        }
        if (this.boundType instanceof java.lang.reflect.TypeVariable) {
            ReferenceType referenceType = substitution.get(this.boundType);
            if (referenceType != null) {
                if (referenceType.isVariable()) {
                    return new LazyReferenceBound(referenceType);
                }
                return new EagerReferenceBound(referenceType);
            }
            return this;
        }
        if (this.boundType instanceof ParameterizedType) {
            boolean isLazy = false;
            ArrayList<TypeArgument> argumentList = new ArrayList<TypeArgument>();
            for (java.lang.reflect.Type parameter : ((ParameterizedType)this.boundType).getActualTypeArguments()) {
                TypeArgument typeArgument = LazyParameterBound.substitute(parameter, substitution);
                if (typeArgument == null) {
                    return this;
                }
                isLazy = LazyParameterBound.isTypeVariable(parameter) && typeArgument.isVariable();
                argumentList.add(typeArgument);
            }
            GenericClassType classType = GenericClassType.forClass((Class)((ParameterizedType)this.boundType).getRawType());
            InstantiatedType instantiatedType = new InstantiatedType(classType, argumentList);
            if (isLazy) {
                return new LazyReferenceBound(instantiatedType);
            }
            return new EagerReferenceBound(instantiatedType);
        }
        throw new RandoopBug("lazy parameter bounds should be either a type variable or parameterized type");
    }

    private static @SignatureUnknown TypeArgument substitute(@SignatureUnknown java.lang.reflect.Type type, @SignatureUnknown Substitution substitution) {
        if (type instanceof java.lang.reflect.TypeVariable) {
            ReferenceType referenceType = substitution.get(type);
            if (referenceType != null) {
                return TypeArgument.forType(referenceType);
            }
            return null;
        }
        if (type instanceof ParameterizedType) {
            ArrayList<TypeArgument> argumentList = new ArrayList<TypeArgument>();
            for (java.lang.reflect.Type parameter : ((ParameterizedType)type).getActualTypeArguments()) {
                TypeArgument paramType = LazyParameterBound.substitute(parameter, substitution);
                argumentList.add(paramType);
            }
            GenericClassType classType = GenericClassType.forClass((Class)((ParameterizedType)type).getRawType());
            InstantiatedType instantiatedType = new InstantiatedType(classType, argumentList);
            return TypeArgument.forType(instantiatedType);
        }
        if (type instanceof Class) {
            return TypeArgument.forType(ClassOrInterfaceType.forType(type));
        }
        if (type instanceof java.lang.reflect.WildcardType) {
            java.lang.reflect.WildcardType wildcardType = (java.lang.reflect.WildcardType)type;
            if (wildcardType.getLowerBounds().length > 0) {
                ReferenceType boundType;
                assert (wildcardType.getLowerBounds().length == 1) : "a wildcard is defined by the JLS to only have one bound";
                java.lang.reflect.Type lowerBound = wildcardType.getLowerBounds()[0];
                ParameterBound bound = lowerBound instanceof java.lang.reflect.TypeVariable ? ((boundType = substitution.get(lowerBound)) != null ? ParameterBound.forType(boundType) : new LazyParameterBound(lowerBound)) : ParameterBound.forType(new HashSet(), lowerBound).substitute(substitution);
                return new WildcardArgument(new WildcardType(bound, false));
            }
            assert (wildcardType.getUpperBounds().length == 1) : "a wildcard is defined by the JLS to only have one bound";
            ParameterBound bound = ParameterBound.forTypes(new HashSet(), wildcardType.getUpperBounds());
            bound = bound.substitute(substitution);
            return new WildcardArgument(new WildcardType(bound, true));
        }
        return null;
    }

    @Override
    public @SignatureUnknown ParameterBound applyCaptureConversion() {
        throw new LazyBoundException();
    }

    @Override
    public @SignatureUnknown List<@SignatureUnknown TypeVariable> getTypeParameters() {
        return LazyParameterBound.getTypeParameters(this.boundType);
    }

    private static @SignatureUnknown List<@SignatureUnknown TypeVariable> getTypeParameters(@SignatureUnknown java.lang.reflect.Type type) {
        ArrayList<TypeVariable> variableList;
        block4: {
            block5: {
                block3: {
                    variableList = new ArrayList<TypeVariable>();
                    if (!(type instanceof java.lang.reflect.TypeVariable)) break block3;
                    variableList.add(TypeVariable.forType(type));
                    break block4;
                }
                if (!(type instanceof ParameterizedType)) break block5;
                ParameterizedType pt = (ParameterizedType)type;
                for (java.lang.reflect.Type argType : pt.getActualTypeArguments()) {
                    variableList.addAll(LazyParameterBound.getTypeParameters(argType));
                }
                break block4;
            }
            if (!(type instanceof java.lang.reflect.WildcardType)) break block4;
            java.lang.reflect.WildcardType wt = (java.lang.reflect.WildcardType)type;
            for (java.lang.reflect.Type boundType : wt.getUpperBounds()) {
                variableList.addAll(LazyParameterBound.getTypeParameters(boundType));
            }
            for (java.lang.reflect.Type boundType : wt.getLowerBounds()) {
                variableList.addAll(LazyParameterBound.getTypeParameters(boundType));
            }
        }
        return variableList;
    }

    @Override
    @SignatureUnknown boolean hasWildcard() {
        return LazyParameterBound.hasWildcard(this.boundType);
    }

    private static @SignatureUnknown boolean hasWildcard(@SignatureUnknown java.lang.reflect.Type type) {
        if (type instanceof java.lang.reflect.WildcardType) {
            return true;
        }
        if (type instanceof java.lang.reflect.TypeVariable) {
            for (java.lang.reflect.Type bound : ((java.lang.reflect.TypeVariable)type).getBounds()) {
                if (!LazyParameterBound.hasWildcard(bound)) continue;
                return true;
            }
            return false;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            for (java.lang.reflect.Type argType : pt.getActualTypeArguments()) {
                if (!LazyParameterBound.hasWildcard(argType)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public @SignatureUnknown boolean hasCaptureVariable() {
        return LazyParameterBound.hasCaptureVariable(this.boundType);
    }

    private static @SignatureUnknown boolean hasCaptureVariable(@SignatureUnknown java.lang.reflect.Type type) {
        if (type instanceof java.lang.reflect.TypeVariable) {
            for (java.lang.reflect.Type bound : ((java.lang.reflect.TypeVariable)type).getBounds()) {
                if (!LazyParameterBound.hasCaptureVariable(bound)) continue;
                return true;
            }
            return false;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            for (java.lang.reflect.Type argType : pt.getActualTypeArguments()) {
                if (!LazyParameterBound.hasCaptureVariable(argType)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public @SignatureUnknown boolean isGeneric(@SignatureUnknown boolean ignoreWildcards) {
        return true;
    }

    @Override
    public @SignatureUnknown boolean isLowerBound(@SignatureUnknown Type argType, @SignatureUnknown Substitution substitution) {
        ParameterBound b = this.substitute(substitution);
        if (b.equals(this)) {
            throw new IllegalArgumentException("substitution " + substitution + " does not instantiate " + this);
        }
        return b.isLowerBound(argType, substitution);
    }

    @Override
    public @SignatureUnknown boolean isObject() {
        return false;
    }

    @Override
    public @SignatureUnknown boolean isSubtypeOf(@SignatureUnknown ParameterBound boundType) {
        throw new LazyBoundException();
    }

    @Override
    public @SignatureUnknown boolean isUpperBound(@SignatureUnknown Type argType, @SignatureUnknown Substitution substitution) {
        ParameterBound b = this.substitute(substitution);
        if (b.equals(this)) {
            throw new IllegalArgumentException("substitution " + substitution + " does not instantiate " + this);
        }
        return b.isUpperBound(argType, substitution);
    }

    @Override
    @SignatureUnknown boolean isUpperBound(@SignatureUnknown ParameterBound bound, @SignatureUnknown Substitution substitution) {
        throw new LazyBoundException();
    }

    @Override
    public @SignatureUnknown boolean isVariable() {
        return this.boundType instanceof java.lang.reflect.TypeVariable;
    }

    static class LazyBoundException
    extends RuntimeException {
        private static final @SignatureUnknown long serialVersionUID = 20190508L;

        LazyBoundException() {
        }
    }
}

