/*
 * Decompiled with CFR 0.152.
 */
package randoop.types;

import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.plumelib.util.UtilPlume;
import randoop.types.ParameterBound;
import randoop.types.Substitution;
import randoop.types.Type;
import randoop.types.TypeVariable;

class IntersectionTypeBound
extends ParameterBound {
    private @SignatureUnknown List<@SignatureUnknown ParameterBound> boundList;

    IntersectionTypeBound(@SignatureUnknown List<@SignatureUnknown ParameterBound> boundList) {
        if (boundList == null) {
            throw new IllegalArgumentException("bounds list may not be null");
        }
        this.boundList = boundList;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntersectionTypeBound)) {
            return false;
        }
        IntersectionTypeBound b = (IntersectionTypeBound)obj;
        return this.boundList.equals(b.boundList);
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.boundList);
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        return UtilPlume.join((CharSequence)" & ", this.boundList);
    }

    @Override
    public @SignatureUnknown IntersectionTypeBound substitute(@SignatureUnknown Substitution substitution) {
        ArrayList<ParameterBound> bounds = new ArrayList<ParameterBound>();
        for (ParameterBound bound : this.boundList) {
            bounds.add(bound.substitute(substitution));
        }
        return new IntersectionTypeBound(bounds);
    }

    @Override
    public @SignatureUnknown ParameterBound applyCaptureConversion() {
        ArrayList<ParameterBound> convertedBoundList = new ArrayList<ParameterBound>();
        for (ParameterBound b : this.boundList) {
            convertedBoundList.add(b.applyCaptureConversion());
        }
        return new IntersectionTypeBound(convertedBoundList);
    }

    @Override
    public @SignatureUnknown List<@SignatureUnknown TypeVariable> getTypeParameters() {
        ArrayList<TypeVariable> paramList = new ArrayList<TypeVariable>();
        for (ParameterBound b : this.boundList) {
            paramList.addAll(b.getTypeParameters());
        }
        return paramList;
    }

    @Override
    @SignatureUnknown boolean hasWildcard() {
        for (ParameterBound b : this.boundList) {
            if (!b.hasWildcard()) continue;
            return true;
        }
        return false;
    }

    @Override
    public @SignatureUnknown boolean hasCaptureVariable() {
        for (ParameterBound b : this.boundList) {
            if (!b.hasCaptureVariable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public @SignatureUnknown boolean isGeneric(@SignatureUnknown boolean ignoreWildcards) {
        for (ParameterBound b : this.boundList) {
            if (!b.isGeneric(ignoreWildcards)) continue;
            return true;
        }
        return false;
    }

    @Override
    public @SignatureUnknown boolean isLowerBound(@SignatureUnknown Type otherType, @SignatureUnknown Substitution subst) {
        for (ParameterBound b : this.boundList) {
            if (b.isLowerBound(otherType, subst)) continue;
            return false;
        }
        return true;
    }

    @Override
    public @SignatureUnknown boolean isObject() {
        for (ParameterBound b : this.boundList) {
            if (b.isObject()) continue;
            return false;
        }
        return true;
    }

    @Override
    public @SignatureUnknown boolean isSubtypeOf(@SignatureUnknown ParameterBound boundType) {
        assert (false) : "intersection type bound isSubTypeOf not implemented";
        return false;
    }

    @Override
    public @SignatureUnknown boolean isUpperBound(@SignatureUnknown Type argType, @SignatureUnknown Substitution subst) {
        for (ParameterBound b : this.boundList) {
            if (b.isUpperBound(argType, subst)) continue;
            return false;
        }
        return true;
    }

    @Override
    @SignatureUnknown boolean isUpperBound(@SignatureUnknown ParameterBound bound, @SignatureUnknown Substitution substitution) {
        for (ParameterBound b : this.boundList) {
            if (b.isUpperBound(bound, substitution)) continue;
            return false;
        }
        return true;
    }
}

