/*
 * Decompiled with CFR 0.152.
 */
package randoop.types;

import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureBottom;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import randoop.types.ClassOrInterfaceType;
import randoop.types.InstantiatedType;
import randoop.types.JavaTypes;
import randoop.types.NonParameterizedType;
import randoop.types.ParameterizedType;
import randoop.types.ReferenceType;
import randoop.types.Substitution;
import randoop.types.Type;
import randoop.types.TypeArgument;
import randoop.types.TypeVariable;

public class GenericClassType
extends ParameterizedType {
    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> rawType;
    private @SignatureUnknown List<@SignatureUnknown TypeVariable> parameters;

    GenericClassType(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> rawType) {
        this.rawType = rawType;
        this.parameters = new ArrayList<TypeVariable>();
        for (java.lang.reflect.TypeVariable<Class<?>> v : rawType.getTypeParameters()) {
            TypeVariable variable = TypeVariable.forType(v);
            this.parameters.add(variable);
        }
    }

    @Override
    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GenericClassType)) {
            return false;
        }
        GenericClassType t = (GenericClassType)obj;
        return this.rawType.equals(t.rawType);
    }

    @Override
    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.rawType);
    }

    @Override
    public @SignatureUnknown InstantiatedType substitute(@SignatureUnknown Substitution substitution) {
        ArrayList<TypeArgument> argumentList = new ArrayList<TypeArgument>();
        for (TypeVariable variable : this.parameters) {
            ReferenceType referenceType = substitution.get(variable);
            if (referenceType == null) {
                referenceType = variable;
            }
            argumentList.add(TypeArgument.forType(referenceType));
        }
        return (InstantiatedType)this.substitute(substitution, new InstantiatedType(new GenericClassType(this.rawType), argumentList));
    }

    @Override
    public @SignatureUnknown GenericClassType applyCaptureConversion() {
        return (GenericClassType)this.applyCaptureConversion(this);
    }

    @Override
    public @SignatureUnknown List<@SignatureUnknown ClassOrInterfaceType> getInterfaces() {
        ArrayList<ClassOrInterfaceType> interfaceTypes = new ArrayList<ClassOrInterfaceType>();
        for (Class<?> c : this.rawType.getInterfaces()) {
            interfaceTypes.add(ClassOrInterfaceType.forClass(c));
        }
        return interfaceTypes;
    }

    @SignatureUnknown List<@SignatureUnknown ClassOrInterfaceType> getInterfaces(@SignatureUnknown Substitution substitution) {
        ArrayList<ClassOrInterfaceType> interfaces = new ArrayList<ClassOrInterfaceType>();
        for (java.lang.reflect.Type type : this.rawType.getGenericInterfaces()) {
            interfaces.add(ClassOrInterfaceType.forType(type).substitute(substitution));
        }
        return interfaces;
    }

    @Override
    public @SignatureUnknown GenericClassType getGenericClassType() {
        return this;
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> getRuntimeClass() {
        return this.rawType;
    }

    @Override
    public @SignatureUnknown ClassOrInterfaceType getSuperclass() {
        Class<?> superclass = this.rawType.getSuperclass();
        if (superclass != null) {
            return ClassOrInterfaceType.forClass(superclass);
        }
        return JavaTypes.OBJECT_TYPE;
    }

    @SignatureUnknown ClassOrInterfaceType getSuperclass(@SignatureUnknown Substitution substitution) {
        java.lang.reflect.Type superclass = this.rawType.getGenericSuperclass();
        if (superclass == null) {
            return JavaTypes.OBJECT_TYPE;
        }
        return ClassOrInterfaceType.forType(superclass).substitute(substitution);
    }

    @Override
    public @SignatureUnknown List<@SignatureUnknown TypeArgument> getTypeArguments() {
        ArrayList<TypeArgument> argumentList = new ArrayList<TypeArgument>();
        for (TypeVariable v : this.parameters) {
            argumentList.add(TypeArgument.forType(v));
        }
        return argumentList;
    }

    @Override
    public @SignatureUnknown List<@SignatureUnknown TypeVariable> getTypeParameters() {
        List<TypeVariable> params = super.getTypeParameters();
        params.addAll(this.parameters);
        return params;
    }

    public @SignatureUnknown InstantiatedType instantiate(ReferenceType ... typeArguments) {
        if (typeArguments.length != this.getTypeParameters().size()) {
            throw new IllegalArgumentException("number of arguments and parameters must match");
        }
        Substitution substitution = new Substitution(this.getTypeParameters(), typeArguments);
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (this.parameters.get(i).getUpperTypeBound().isUpperBound(typeArguments[i], substitution)) continue;
            throw new IllegalArgumentException("type argument " + typeArguments[i] + " does not match parameter bound " + this.parameters.get(i).getUpperTypeBound());
        }
        return this.substitute(substitution);
    }

    public @SignatureUnknown InstantiatedType instantiate(@SignatureUnknown List<@SignatureUnknown ReferenceType> typeArguments) {
        if (typeArguments.size() != this.getTypeParameters().size()) {
            throw new IllegalArgumentException("number of arguments and parameters must match");
        }
        Substitution substitution = new Substitution(this.getTypeParameters(), typeArguments);
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (this.parameters.get(i).getUpperTypeBound().isUpperBound(typeArguments.get(i), substitution)) continue;
            throw new IllegalArgumentException("type argument " + typeArguments.get(i) + " does not match parameter bound " + this.parameters.get(i).getUpperTypeBound());
        }
        return this.substitute(substitution);
    }

    @Override
    public @SignatureUnknown boolean isAbstract() {
        return Modifier.isAbstract(Modifier.classModifiers() & this.rawType.getModifiers());
    }

    @Override
    public @SignatureUnknown boolean isGeneric(@SignatureUnknown boolean ignoreWildcards) {
        return true;
    }

    @Override
    public @SignatureUnknown boolean isInterface() {
        return this.rawType.isInterface();
    }

    @Override
    public @SignatureUnknown boolean isStatic() {
        return Modifier.isStatic(this.rawType.getModifiers() & Modifier.classModifiers());
    }

    @Override
    public @SignatureUnknown boolean isSubtypeOf(@SignatureUnknown Type otherType) {
        if (otherType == null) {
            throw new IllegalArgumentException("type must be non-null");
        }
        return super.isSubtypeOf(otherType) || otherType.isRawtype() && otherType.runtimeClassIs(this.getRuntimeClass());
    }

    @Override
    public @SignatureUnknown NonParameterizedType getRawtype() {
        return NonParameterizedType.forClass(this.rawType);
    }
}

