/*
 * Decompiled with CFR 0.152.
 */
package randoop.types;

import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureBottom;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import randoop.types.GenericClassType;
import randoop.types.InstantiatedType;
import randoop.types.NonParameterizedType;
import randoop.types.ParameterizedType;
import randoop.types.ReferenceType;
import randoop.types.Substitution;
import randoop.types.Type;
import randoop.types.TypeArgument;
import randoop.types.TypeVariable;
import randoop.util.Log;

public abstract class ClassOrInterfaceType
extends ReferenceType {
    private static @SignatureUnknown boolean debug = false;
    protected @SignatureUnknown ClassOrInterfaceType enclosingType = null;

    public static @SignatureUnknown ClassOrInterfaceType forClass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> classType) {
        if (classType.isArray() || classType.isPrimitive()) {
            throw new IllegalArgumentException("type must be a class or interface, got " + classType);
        }
        ClassOrInterfaceType type = classType.getTypeParameters().length > 0 ? ParameterizedType.forClass(classType) : NonParameterizedType.forClass(classType);
        Class<?> enclosingClass = classType.getEnclosingClass();
        if (enclosingClass != null) {
            type.setEnclosingType(ClassOrInterfaceType.forClass(enclosingClass));
        }
        return type;
    }

    public static @SignatureUnknown ClassOrInterfaceType forType(@SignatureUnknown java.lang.reflect.Type type) {
        if (type instanceof java.lang.reflect.ParameterizedType) {
            java.lang.reflect.ParameterizedType t = (java.lang.reflect.ParameterizedType)type;
            Class rawType = (Class)t.getRawType();
            if (rawType.getTypeParameters().length == 0) {
                return ClassOrInterfaceType.forClass(rawType);
            }
            return ParameterizedType.forType(t);
        }
        if (type instanceof Class) {
            Class classType = (Class)type;
            return new NonParameterizedType(classType);
        }
        throw new IllegalArgumentException("Unable to create class type from type " + type);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClassOrInterfaceType)) {
            return false;
        }
        ClassOrInterfaceType otherType = (ClassOrInterfaceType)obj;
        return !this.isNestedClass() || !otherType.isNestedClass() || this.enclosingType.equals(otherType.enclosingType);
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.enclosingType);
    }

    @Override
    public abstract @SignatureUnknown ClassOrInterfaceType substitute(@SignatureUnknown Substitution var1);

    final @SignatureUnknown ClassOrInterfaceType substitute(@SignatureUnknown Substitution substitution, @SignatureUnknown ClassOrInterfaceType type) {
        if (this.isMemberClass()) {
            type.setEnclosingType(this.enclosingType.substitute(substitution));
        }
        return type;
    }

    @Override
    public abstract @SignatureUnknown ClassOrInterfaceType applyCaptureConversion();

    final @SignatureUnknown ClassOrInterfaceType applyCaptureConversion(@SignatureUnknown ClassOrInterfaceType type) {
        if (this.isMemberClass()) {
            type.setEnclosingType(this.enclosingType.applyCaptureConversion());
        }
        return type;
    }

    @Override
    public @SignatureUnknown String getSimpleName() {
        return this.getRuntimeClass().getSimpleName();
    }

    @Override
    public @SignatureUnknown String getCanonicalName() {
        return this.getRuntimeClass().getCanonicalName();
    }

    @Override
    public @SignatureUnknown String getFqName() {
        if (this.isNestedClass()) {
            if (this.isStatic()) {
                return this.enclosingType.getCanonicalName() + "." + this.getSimpleName();
            }
            return this.enclosingType.getFqName() + "." + this.getSimpleName();
        }
        return this.getCanonicalName();
    }

    @Override
    public @SignatureUnknown String getBinaryName() {
        if (this.isNestedClass()) {
            if (this.isStatic()) {
                return this.enclosingType.getBinaryName().replaceAll("<[^<]*>$", "") + "$" + this.getSimpleName();
            }
            return this.enclosingType.getBinaryName() + "$" + this.getSimpleName();
        }
        return this.getRuntimeClass().getName();
    }

    @Override
    public @SignatureUnknown String getUnqualifiedBinaryName() {
        String prefix = "";
        if (this.isNestedClass()) {
            prefix = this.enclosingType.getUnqualifiedBinaryName() + "$";
        }
        return prefix + this.getSimpleName();
    }

    public abstract @SignatureUnknown List<@SignatureUnknown ClassOrInterfaceType> getInterfaces();

    public @SignatureUnknown Package getPackage() {
        Class<?> c = this.getRuntimeClass();
        if (c == null) {
            throw new IllegalArgumentException("Class " + this.toString() + " has no runtime class");
        }
        return c.getPackage();
    }

    @SignatureUnknown String getPackagePrefix() {
        Package pkg = this.getPackage();
        if (pkg == null) {
            return "";
        }
        return pkg.getName() + ".";
    }

    @Override
    public abstract @SignatureUnknown NonParameterizedType getRawtype();

    public @SignatureUnknown InstantiatedType getMatchingSupertype(@SignatureUnknown GenericClassType goalType) {
        ClassOrInterfaceType superclass;
        if (goalType.isInterface()) {
            for (ClassOrInterfaceType interfaceType : this.getInterfaces()) {
                if (!goalType.getRuntimeClass().isAssignableFrom(interfaceType.getRuntimeClass())) continue;
                if (interfaceType.isParameterized()) {
                    InstantiatedType type = (InstantiatedType)interfaceType;
                    if (type.isInstantiationOf(goalType)) {
                        return (InstantiatedType)interfaceType;
                    }
                    InstantiatedType result = type.getMatchingSupertype(goalType);
                    if (result == null) continue;
                    return result;
                }
                return interfaceType.getMatchingSupertype(goalType);
            }
        }
        if ((superclass = this.getSuperclass()) != null && !superclass.isObject() && goalType.getRuntimeClass().isAssignableFrom(superclass.getRuntimeClass())) {
            if (superclass.isInstantiationOf(goalType)) {
                return (InstantiatedType)superclass;
            }
            return superclass.getMatchingSupertype(goalType);
        }
        return null;
    }

    @Override
    public @SignatureUnknown Substitution getInstantiatingSubstitution(@SignatureUnknown ReferenceType goalType) {
        InstantiatedType supertype;
        Substitution superResult = ReferenceType.getInstantiatingSubstitutionforTypeVariable(this, goalType);
        if (superResult != null) {
            return superResult;
        }
        assert (goalType.isGeneric()) : "goal type must be generic";
        Substitution substitution = new Substitution();
        if (this.isMemberClass() && (substitution = this.enclosingType.getInstantiatingSubstitution(goalType)) == null) {
            return null;
        }
        if (goalType instanceof GenericClassType && (supertype = this.getMatchingSupertype((GenericClassType)goalType)) != null) {
            Substitution supertypeSubstitution = supertype.getTypeSubstitution();
            if (supertypeSubstitution == null) {
                return null;
            }
            substitution = substitution.extend(supertypeSubstitution);
        }
        return substitution;
    }

    public abstract @SignatureUnknown ClassOrInterfaceType getSuperclass();

    public @SignatureUnknown Collection<@SignatureUnknown ClassOrInterfaceType> getSuperTypes() {
        ArrayList<ClassOrInterfaceType> supertypes = new ArrayList<ClassOrInterfaceType>();
        if (this.isObject()) {
            return supertypes;
        }
        ClassOrInterfaceType superclass = this.getSuperclass();
        if (superclass != null) {
            supertypes.add(superclass);
            supertypes.addAll(superclass.getSuperTypes());
        }
        for (ClassOrInterfaceType interfaceType : this.getInterfaces()) {
            supertypes.add(interfaceType);
            supertypes.addAll(interfaceType.getSuperTypes());
        }
        return supertypes;
    }

    public @SignatureUnknown List<@SignatureUnknown ClassOrInterfaceType> getImmediateSupertypes() {
        if (this.isObject()) {
            return Collections.emptyList();
        }
        ArrayList<ClassOrInterfaceType> supertypes = new ArrayList<ClassOrInterfaceType>();
        ClassOrInterfaceType superclass = this.getSuperclass();
        supertypes.add(superclass);
        supertypes.addAll(this.getInterfaces());
        return supertypes;
    }

    public @SignatureUnknown Collection<@SignatureUnknown ClassOrInterfaceType> getAllSupertypesInclusive() {
        LinkedHashSet<ClassOrInterfaceType> result = new LinkedHashSet<ClassOrInterfaceType>();
        ArrayDeque<ClassOrInterfaceType> worklist = new ArrayDeque<ClassOrInterfaceType>();
        worklist.add(this);
        while (!worklist.isEmpty()) {
            ClassOrInterfaceType type = (ClassOrInterfaceType)worklist.remove();
            if (!result.add(type)) continue;
            worklist.addAll(type.getImmediateSupertypes());
        }
        return result;
    }

    public abstract @SignatureUnknown boolean isAbstract();

    @Override
    public @SignatureUnknown boolean isGeneric(@SignatureUnknown boolean ignoreWildcards) {
        return this.isMemberClass() && this.enclosingType.isGeneric(ignoreWildcards);
    }

    @Override
    public @SignatureUnknown boolean isInstantiationOf(@SignatureUnknown ReferenceType otherType) {
        if (super.isInstantiationOf(otherType)) {
            return true;
        }
        if (this.isNestedClass() && otherType instanceof ClassOrInterfaceType) {
            ClassOrInterfaceType otherClassType = (ClassOrInterfaceType)otherType;
            return otherClassType.isNestedClass() && this.enclosingType.isInstantiationOf(otherClassType.enclosingType);
        }
        return false;
    }

    public final @SignatureUnknown boolean isNestedClass() {
        return this.enclosingType != null;
    }

    public final @SignatureUnknown boolean isMemberClass() {
        return this.isNestedClass() && !this.isStatic();
    }

    @Override
    public @SignatureUnknown boolean isParameterized() {
        return this.isMemberClass() && this.enclosingType.isParameterized();
    }

    public abstract @SignatureUnknown boolean isStatic();

    @Override
    public @SignatureUnknown boolean isSubtypeOf(@SignatureUnknown Type otherType) {
        if (debug) {
            System.out.printf("isSubtypeOf(%s, %s) [%s, %s]%n", this, otherType, this.getClass(), otherType.getClass());
        }
        if (otherType.isObject()) {
            return true;
        }
        if (super.isSubtypeOf(otherType)) {
            return true;
        }
        if (this instanceof NonParameterizedType && otherType.isGeneric() && this.getRuntimeClass() == otherType.getRuntimeClass()) {
            return true;
        }
        if (!otherType.isReferenceType()) {
            return false;
        }
        if (otherType.isInterface()) {
            for (ClassOrInterfaceType iface : this.getInterfaces()) {
                if (debug) {
                    System.out.printf("  iface: %s%n", Log.toStringAndClass(iface));
                }
                if (iface.equals(otherType)) {
                    return true;
                }
                if (!iface.isSubtypeOf(otherType)) continue;
                return true;
            }
        }
        if (this.isInterface()) {
            return false;
        }
        ClassOrInterfaceType superClassType = this.getSuperclass();
        if (debug) {
            System.out.printf("  superClassType: %s%n", superClassType);
        }
        if (superClassType == null || superClassType.isObject()) {
            return false;
        }
        return superClassType.isSubtypeOf(otherType);
    }

    @Override
    public @SignatureUnknown boolean hasWildcard() {
        return false;
    }

    @Override
    public @SignatureUnknown boolean hasCaptureVariable() {
        return false;
    }

    protected void setEnclosingType(@SignatureUnknown ClassOrInterfaceType enclosingType) {
        this.enclosingType = enclosingType;
    }

    public @SignatureUnknown List<@SignatureUnknown TypeArgument> getTypeArguments() {
        return new ArrayList<TypeArgument>();
    }

    @Override
    public @SignatureUnknown List<@SignatureUnknown TypeVariable> getTypeParameters() {
        if (this.isMemberClass()) {
            return this.enclosingType.getTypeParameters();
        }
        return new ArrayList<TypeVariable>();
    }

    @Override
    public @SignatureUnknown boolean isClassOrInterfaceType() {
        return true;
    }
}

