/*
 * Decompiled with CFR 0.152.
 */
package randoop.types;

import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.util.ArrayList;
import java.util.Objects;
import randoop.types.IntersectionTypeBound;
import randoop.types.ParameterBound;
import randoop.types.ReferenceType;
import randoop.types.Substitution;
import randoop.types.TypeVariable;
import randoop.types.WildcardArgument;

class CaptureTypeVariable
extends TypeVariable {
    private static @SignatureUnknown int count = 0;
    private final @SignatureUnknown int varID;
    private final @SignatureUnknown WildcardArgument wildcard;

    CaptureTypeVariable(@SignatureUnknown WildcardArgument wildcard) {
        this.varID = count++;
        this.wildcard = wildcard;
        if (wildcard.hasUpperBound()) {
            this.setUpperBound(wildcard.getTypeBound());
        } else {
            this.setLowerBound(wildcard.getTypeBound());
        }
    }

    private CaptureTypeVariable(@SignatureUnknown int varID, @SignatureUnknown WildcardArgument wildcard, @SignatureUnknown ParameterBound lowerBound, @SignatureUnknown ParameterBound upperBound) {
        super(lowerBound, upperBound);
        this.varID = varID;
        this.wildcard = wildcard;
    }

    @SignatureUnknown WildcardArgument getWildcard() {
        return this.wildcard;
    }

    @Override
    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CaptureTypeVariable)) {
            return false;
        }
        CaptureTypeVariable variable = (CaptureTypeVariable)obj;
        return this.varID == variable.varID && this.wildcard.equals(variable.wildcard) && super.equals(variable);
    }

    @Override
    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.varID, this.wildcard, super.hashCode());
    }

    @Override
    @SideEffectFree
    public @SignatureUnknown String toString() {
        return this.getBinaryName() + " of " + this.wildcard;
    }

    public void convert(@SignatureUnknown TypeVariable typeParameter, @SignatureUnknown Substitution substitution) {
        ParameterBound parameterBound = typeParameter.getUpperTypeBound().substitute(substitution);
        if (this.getUpperTypeBound().isObject()) {
            this.setUpperBound(parameterBound);
        } else {
            ArrayList<ParameterBound> boundList = new ArrayList<ParameterBound>();
            boundList.add(parameterBound);
            boundList.add(this.getUpperTypeBound());
            this.setUpperBound(new IntersectionTypeBound(boundList));
        }
    }

    @Override
    public @SignatureUnknown String getFqName() {
        return "Capture" + this.varID;
    }

    @Override
    public @SignatureUnknown String getBinaryName() {
        return "Capture" + this.varID;
    }

    @Override
    public @SignatureUnknown String getSimpleName() {
        return this.getFqName();
    }

    @Override
    public @SignatureUnknown boolean isCaptureVariable() {
        return true;
    }

    @Override
    public @SignatureUnknown boolean hasCaptureVariable() {
        return true;
    }

    @Override
    public @SignatureUnknown boolean isGeneric(@SignatureUnknown boolean ignoreWildcards) {
        return !ignoreWildcards;
    }

    @Override
    public @SignatureUnknown ReferenceType substitute(@SignatureUnknown Substitution substitution) {
        ReferenceType type = substitution.get(this);
        if (type != null && !type.isVariable()) {
            return type;
        }
        ParameterBound lowerBound = this.getLowerTypeBound().substitute(substitution);
        ParameterBound upperBound = this.getUpperTypeBound().substitute(substitution);
        if (type == null) {
            if (!lowerBound.equals(this.getLowerTypeBound()) || !upperBound.equals(this.getUpperTypeBound())) {
                WildcardArgument updatedWildcard = this.wildcard.substitute(substitution);
                return new CaptureTypeVariable(this.varID, updatedWildcard, lowerBound, upperBound);
            }
            return this;
        }
        if (!lowerBound.equals(this.getLowerTypeBound()) || !upperBound.equals(this.getUpperTypeBound())) {
            return ((TypeVariable)type).createCopyWithBounds(lowerBound, upperBound);
        }
        return type;
    }

    @Override
    public @SignatureUnknown TypeVariable createCopyWithBounds(@SignatureUnknown ParameterBound lowerBound, @SignatureUnknown ParameterBound upperBound) {
        return new CaptureTypeVariable(this.varID, this.wildcard, lowerBound, upperBound);
    }
}

