/*
 * Decompiled with CFR 0.152.
 */
package randoop.types;

import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureBottom;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import randoop.types.ClassOrInterfaceType;
import randoop.types.JavaTypes;
import randoop.types.ReferenceType;
import randoop.types.Substitution;
import randoop.types.Type;
import randoop.types.TypeVariable;

public class ArrayType
extends ReferenceType {
    private final @SignatureUnknown Type componentType;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> runtimeClass;

    private ArrayType(@SignatureUnknown Type componentType, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> runtimeClass) {
        this.componentType = componentType;
        this.runtimeClass = runtimeClass;
    }

    public static @SignatureUnknown ArrayType forClass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> arrayClass) {
        if (!arrayClass.isArray()) {
            throw new IllegalArgumentException("type must be an array");
        }
        Type componentType = Type.forClass(arrayClass.getComponentType());
        return new ArrayType(componentType, arrayClass);
    }

    public static @SignatureUnknown ArrayType forType(@SignatureUnknown java.lang.reflect.Type type) {
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            Type componentType = Type.forType(arrayType.getGenericComponentType());
            return ArrayType.ofComponentType(componentType);
        }
        if (type instanceof Class && ((Class)type).isArray()) {
            Type componentType = Type.forType(((Class)type).getComponentType());
            return ArrayType.ofComponentType(componentType);
        }
        throw new IllegalArgumentException("type " + type + " must be an array type");
    }

    public static @SignatureUnknown ArrayType ofComponentType(@SignatureUnknown Type componentType) {
        if (componentType instanceof TypeVariable) {
            return new ArrayType(componentType, Array.newInstance(Object.class, 0).getClass());
        }
        return new ArrayType(componentType, Array.newInstance(componentType.getRuntimeClass(), 0).getClass());
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ArrayType)) {
            return false;
        }
        ArrayType t = (ArrayType)obj;
        return this.componentType.equals(t.componentType) && this.runtimeClass.equals(t.runtimeClass);
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.componentType, this.runtimeClass);
    }

    @Override
    public @SignatureUnknown ArrayType substitute(@SignatureUnknown Substitution substitution) {
        Type type = this.componentType.substitute(substitution);
        if (!type.equals(this)) {
            return ArrayType.ofComponentType(type);
        }
        return this;
    }

    public @SignatureUnknown Type getComponentType() {
        return this.componentType;
    }

    public @SignatureUnknown Type getElementType() {
        if (this.componentType.isArray()) {
            return ((ArrayType)this.componentType).getElementType();
        }
        return this.componentType;
    }

    @Override
    public @SignatureUnknown String getFqName() {
        return this.componentType.getFqName() + "[]";
    }

    @Override
    public @SignatureUnknown String getBinaryName() {
        return this.componentType.getBinaryName() + "[]";
    }

    @Override
    public @SignatureUnknown String getSimpleName() {
        return this.componentType.getSimpleName() + "[]";
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> getRuntimeClass() {
        return this.runtimeClass;
    }

    @Override
    public @SignatureUnknown List<@SignatureUnknown TypeVariable> getTypeParameters() {
        if (this.componentType.isReferenceType()) {
            return ((ReferenceType)this.componentType).getTypeParameters();
        }
        return new ArrayList<TypeVariable>();
    }

    @Override
    public @SignatureUnknown boolean isArray() {
        return true;
    }

    @Override
    public @SignatureUnknown boolean isAssignableFrom(@SignatureUnknown Type otherType) {
        if (super.isAssignableFrom(otherType)) {
            return true;
        }
        if (otherType.isArray() && this.componentType.isParameterized()) {
            Type otherElementType = ((ArrayType)otherType).componentType;
            return otherElementType.isRawtype() && otherElementType.runtimeClassIs(this.componentType.getRuntimeClass());
        }
        return false;
    }

    @Override
    public @SignatureUnknown boolean isGeneric(@SignatureUnknown boolean ignoreWildcards) {
        return this.componentType.isGeneric(ignoreWildcards);
    }

    @Override
    public @SignatureUnknown boolean isSubtypeOf(@SignatureUnknown Type otherType) {
        if (super.isSubtypeOf(otherType)) {
            return true;
        }
        if (otherType.equals(JavaTypes.CLONEABLE_TYPE)) {
            return true;
        }
        if (otherType.equals(JavaTypes.SERIALIZABLE_TYPE)) {
            return true;
        }
        if (otherType.isArray() && this.componentType.isReferenceType()) {
            ArrayType otherArrayType = (ArrayType)otherType;
            return otherArrayType.componentType.isReferenceType() && this.componentType.isSubtypeOf(otherArrayType.componentType);
        }
        return false;
    }

    @Override
    public @SignatureUnknown Type getRawtype() {
        if (!this.componentType.isGeneric()) {
            return this;
        }
        return new ArrayType(this.componentType.getRawtype(), this.runtimeClass);
    }

    @Override
    public @SignatureUnknown boolean hasWildcard() {
        return this.componentType.hasWildcard();
    }

    @Override
    public @SignatureUnknown boolean hasCaptureVariable() {
        return this.componentType.hasCaptureVariable();
    }

    public @SignatureUnknown boolean hasParameterizedElementType() {
        return this.getElementType().isParameterized();
    }

    public @SignatureUnknown ArrayType getRawTypeArray() {
        ReferenceType rawElementType;
        if (this.componentType.isArray()) {
            rawElementType = ((ArrayType)this.componentType).getRawTypeArray();
        } else if (this.componentType.isClassOrInterfaceType()) {
            rawElementType = ((ClassOrInterfaceType)this.componentType).getRawtype();
        } else {
            return this;
        }
        return ArrayType.ofComponentType(rawElementType);
    }

    public @SignatureUnknown int getDimensions() {
        int dimensions = 1;
        if (this.componentType.isArray()) {
            dimensions += ((ArrayType)this.componentType).getDimensions();
        }
        return dimensions;
    }
}

