/*
 * Decompiled with CFR 0.152.
 */
package randoop.test;

import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.ExceptionalExecution;
import randoop.ExecutionOutcome;
import randoop.main.ExceptionBehaviorClassifier;
import randoop.main.GenInputsAbstract;
import randoop.sequence.ExecutableSequence;
import randoop.sequence.SequenceExceptionError;
import randoop.test.InvalidChecks;
import randoop.test.InvalidExceptionCheck;
import randoop.test.TestCheckGenerator;
import randoop.util.TimeoutExceededException;

public class ValidityCheckingGenerator
extends TestCheckGenerator {
    private @SignatureUnknown boolean throwExceptionOnFlakyTest;

    public ValidityCheckingGenerator(@SignatureUnknown boolean throwExceptionOnFlakyTest) {
        this.throwExceptionOnFlakyTest = throwExceptionOnFlakyTest;
    }

    public @SignatureUnknown InvalidChecks generateTestChecks(@SignatureUnknown ExecutableSequence eseq) {
        int finalIndex = eseq.sequence.size() - 1;
        for (int i = 0; i < eseq.sequence.size(); ++i) {
            ExecutionOutcome result = eseq.getResult(i);
            if (!(result instanceof ExceptionalExecution)) continue;
            ExceptionalExecution exec = (ExceptionalExecution)result;
            Throwable e = exec.getException();
            if (i != finalIndex) {
                if (this.throwExceptionOnFlakyTest && !(e instanceof OutOfMemoryError) && !(e instanceof StackOverflowError) && !(e instanceof TimeoutExceededException)) {
                    throw new SequenceExceptionError(eseq, i, e);
                }
                return new InvalidChecks(new InvalidExceptionCheck(e, i, e.getClass().getName()));
            }
            if (ExceptionBehaviorClassifier.classify(exec, eseq) != GenInputsAbstract.BehaviorType.INVALID) continue;
            return new InvalidChecks(new InvalidExceptionCheck(e, i, e.getClass().getName()));
        }
        return InvalidChecks.EMPTY;
    }
}

