/*
 * Decompiled with CFR 0.152.
 */
package randoop.test;

import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import randoop.main.RandoopBug;
import randoop.test.Check;
import randoop.test.ExceptionCheck;
import randoop.test.TestChecks;

public class RegressionChecks
implements TestChecks<RegressionChecks> {
    public static @SignatureUnknown RegressionChecks EMPTY = new RegressionChecks();
    private @SignatureUnknown Set<@SignatureUnknown Check> checks;
    private @SignatureUnknown ExceptionCheck exceptionCheck;

    public RegressionChecks() {
        this.checks = new LinkedHashSet<Check>();
        this.exceptionCheck = null;
    }

    public RegressionChecks(@SignatureUnknown Check check) {
        if (check instanceof ExceptionCheck) {
            this.checks = Collections.emptySet();
            this.exceptionCheck = (ExceptionCheck)check;
        } else {
            this.checks = Collections.singleton(check);
            this.exceptionCheck = null;
        }
    }

    @Override
    public @SignatureUnknown int count() {
        int result = this.checks.size();
        if (this.exceptionCheck != null) {
            ++result;
        }
        return result;
    }

    @Override
    public void add(@SignatureUnknown Check check) {
        if (this == EMPTY) {
            throw new RandoopBug("Don't add to EMPTY");
        }
        if (check instanceof ExceptionCheck) {
            if (this.exceptionCheck != null) {
                throw new IllegalArgumentException("Sequence already has a check of type " + this.exceptionCheck.getClass().getCanonicalName());
            }
            this.exceptionCheck = (ExceptionCheck)check;
        } else {
            this.checks.add(check);
        }
    }

    @Override
    public @SignatureUnknown Set<@SignatureUnknown Check> checks() {
        return this.checks;
    }

    @Override
    public @SignatureUnknown boolean hasChecks() {
        return !this.checks.isEmpty() || this.exceptionCheck != null;
    }

    @Override
    public @SignatureUnknown boolean hasErrorBehavior() {
        return false;
    }

    @Override
    public @SignatureUnknown ExceptionCheck getExceptionCheck() {
        return this.exceptionCheck;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RegressionChecks)) {
            return false;
        }
        RegressionChecks cks = (RegressionChecks)obj;
        if (!this.checks.equals(cks.checks)) {
            return false;
        }
        if (this.exceptionCheck == null) {
            return cks.exceptionCheck == null;
        }
        return cks.exceptionCheck != null && this.exceptionCheck.equals(cks.exceptionCheck);
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.checks, this.exceptionCheck);
    }

    @Override
    public @SignatureUnknown RegressionChecks commonChecks(@SignatureUnknown RegressionChecks other) {
        RegressionChecks common = new RegressionChecks();
        for (Check ck : this.checks) {
            if (!other.checks.contains(ck)) continue;
            common.add(ck);
        }
        if (this.exceptionCheck.equals(other.exceptionCheck)) {
            common.add(this.exceptionCheck);
        }
        return common;
    }

    @Override
    public @SignatureUnknown boolean hasInvalidBehavior() {
        return false;
    }
}

