/*
 * Decompiled with CFR 0.152.
 */
package randoop.test;

import coveredclass.org.checkerframework.checker.signature.qual.SignatureBottom;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.util.ArrayList;
import java.util.List;
import randoop.ExecutionOutcome;
import randoop.NormalExecution;
import randoop.NotExecuted;
import randoop.condition.ExecutableBooleanExpression;
import randoop.sequence.DummyVariable;
import randoop.sequence.ExecutableSequence;
import randoop.sequence.Variable;
import randoop.test.ErrorRevealingChecks;
import randoop.test.PostConditionCheck;
import randoop.test.RegressionChecks;
import randoop.test.TestCheckGenerator;
import randoop.test.TestChecks;

public class PostConditionCheckGenerator
extends TestCheckGenerator {
    private final @SignatureUnknown List<@SignatureUnknown ExecutableBooleanExpression> postConditions;

    public PostConditionCheckGenerator(@SignatureUnknown List<@SignatureUnknown ExecutableBooleanExpression> postConditions) {
        this.postConditions = postConditions;
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown TestChecks<@SignatureUnknown @SignatureBottom ?> generateTestChecks(@SignatureUnknown ExecutableSequence eseq) {
        int finalIndex = eseq.sequence.size() - 1;
        ExecutionOutcome result = eseq.getResult(finalIndex);
        if (result instanceof NotExecuted) {
            throw new Error("Abnormal execution in sequence: " + eseq);
        }
        if (result instanceof NormalExecution) {
            ArrayList<Variable> inputs = new ArrayList<Variable>(eseq.sequence.getInputs(finalIndex));
            inputs.add(eseq.sequence.getVariable(finalIndex));
            Object[] inputValues = eseq.getRuntimeInputs(inputs);
            if (eseq.sequence.getStatement(finalIndex).getOperation().isStatic()) {
                inputValues = this.addNullReceiver(inputValues);
                inputs.add(0, DummyVariable.DUMMY);
            }
            ArrayList<ExecutableBooleanExpression> failed = new ArrayList<ExecutableBooleanExpression>();
            for (ExecutableBooleanExpression postCondition : this.postConditions) {
                if (postCondition.check(inputValues)) continue;
                failed.add(postCondition);
            }
            eseq.sequence.doNotInlineLiterals();
            if (failed.isEmpty()) {
                return new RegressionChecks(new PostConditionCheck(this.postConditions, inputs));
            }
            return new ErrorRevealingChecks(new PostConditionCheck(failed, inputs));
        }
        return ErrorRevealingChecks.EMPTY;
    }

    private @SignatureUnknown Object @SignatureUnknown [] addNullReceiver(@SignatureUnknown Object @SignatureUnknown [] values) {
        Object[] args = new Object[values.length + 1];
        args[0] = null;
        System.arraycopy(values, 0, args, 1, values.length);
        return args;
    }
}

