/*
 * Decompiled with CFR 0.152.
 */
package randoop.test;

import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.plumelib.util.UtilPlume;
import randoop.Globals;
import randoop.condition.ExecutableBooleanExpression;
import randoop.contract.ObjectContractUtils;
import randoop.sequence.Variable;
import randoop.test.Check;

public class PostConditionCheck
implements Check {
    private final @SignatureUnknown List<@SignatureUnknown ExecutableBooleanExpression> postConditions;
    private final @SignatureUnknown Variable @SignatureUnknown [] inputVariables;

    public PostConditionCheck(@SignatureUnknown List<@SignatureUnknown ExecutableBooleanExpression> postConditions, @SignatureUnknown List<@SignatureUnknown Variable> inputVariables) {
        this.postConditions = postConditions;
        this.inputVariables = inputVariables.toArray(new Variable[0]);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PostConditionCheck)) {
            return false;
        }
        PostConditionCheck other = (PostConditionCheck)object;
        if (!this.postConditions.equals(other.postConditions)) {
            return false;
        }
        if (this.inputVariables.length != other.inputVariables.length) {
            return false;
        }
        for (int i = 0; i < this.inputVariables.length; ++i) {
            if (this.inputVariables[i].equals(other.inputVariables[i])) continue;
            return false;
        }
        return true;
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.postConditions, Arrays.hashCode(this.inputVariables));
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        ArrayList<String> conditionStrings = new ArrayList<String>();
        for (ExecutableBooleanExpression condition : this.postConditions) {
            conditionStrings.add(condition.getContractSource());
        }
        return UtilPlume.join((CharSequence)" && ", conditionStrings);
    }

    @Override
    public @SignatureUnknown String toCodeStringPreStatement() {
        return "";
    }

    @Override
    public @SignatureUnknown String toCodeStringPostStatement() {
        StringBuilder builder = new StringBuilder();
        for (ExecutableBooleanExpression postCondition : this.postConditions) {
            String conditionString = ObjectContractUtils.localizeContractCode(postCondition.getContractSource(), this.inputVariables);
            builder.append("// Checks the post-condition: ").append(postCondition.getComment()).append(Globals.lineSep);
            builder.append("org.junit.Assert.assertTrue(\"Post-condition: ").append(postCondition.getComment()).append("\", ").append(conditionString).append(");").append(Globals.lineSep);
        }
        return builder.toString();
    }

    public @SignatureUnknown List<@SignatureUnknown ExecutableBooleanExpression> getPostConditions() {
        return this.postConditions;
    }
}

