/*
 * Decompiled with CFR 0.152.
 */
package randoop.test;

import coveredclass.org.checkerframework.checker.signature.qual.SignatureBottom;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.ExceptionalExecution;
import randoop.main.ExceptionBehaviorClassifier;
import randoop.main.GenInputsAbstract;
import randoop.reflection.VisibilityPredicate;
import randoop.sequence.ExecutableSequence;
import randoop.test.EmptyExceptionCheck;
import randoop.test.ExceptionCheck;
import randoop.test.ExpectedExceptionCheck;

public class ExpectedExceptionCheckGen {
    private @SignatureUnknown VisibilityPredicate visibility;

    public ExpectedExceptionCheckGen(@SignatureUnknown VisibilityPredicate visibility) {
        this.visibility = visibility;
    }

    @SignatureUnknown ExceptionCheck getExceptionCheck(@SignatureUnknown ExceptionalExecution exec, @SignatureUnknown ExecutableSequence eseq, @SignatureUnknown int statementIndex) {
        Throwable e = exec.getException();
        String catchClassName = ExpectedExceptionCheckGen.getCatchClassName(e.getClass(), this.visibility);
        if (ExceptionBehaviorClassifier.classify(exec, eseq) == GenInputsAbstract.BehaviorType.EXPECTED) {
            return new ExpectedExceptionCheck(e, statementIndex, catchClassName);
        }
        return new EmptyExceptionCheck(e, statementIndex, catchClassName);
    }

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> nearestVisibleSuperclass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> c, @SignatureUnknown VisibilityPredicate visibility) {
        while (!visibility.isVisible(c)) {
            c = c.getSuperclass();
        }
        return c;
    }

    public static @SignatureUnknown String getCatchClassName(@SignatureUnknown Class<@SignatureBottom ? extends @SignatureUnknown Throwable> c, @SignatureUnknown VisibilityPredicate visibility) {
        Class<?> catchClass = ExpectedExceptionCheckGen.nearestVisibleSuperclass(c, visibility);
        return catchClass.getCanonicalName();
    }

    public static @SignatureUnknown String getCatchClassName(@SignatureUnknown Class<@SignatureBottom ? extends @SignatureUnknown Throwable> c) {
        Class<?> catchClass = ExpectedExceptionCheckGen.nearestVisibleSuperclass(c, VisibilityPredicate.IS_PUBLIC);
        return catchClass.getCanonicalName();
    }
}

