/*
 * Decompiled with CFR 0.152.
 */
package randoop.test;

import coveredclass.org.checkerframework.checker.nullness.qual.PolyNull;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.text.Normalizer;
import org.plumelib.util.UtilPlume;
import randoop.Globals;
import randoop.test.ExceptionCheck;

public class ExpectedExceptionCheck
extends ExceptionCheck {
    public ExpectedExceptionCheck(@SignatureUnknown Throwable exception, @SignatureUnknown int statementIndex, @SignatureUnknown String catchClassName) {
        super(exception, statementIndex, catchClassName);
    }

    @Override
    protected void appendTryBehavior(@SignatureUnknown StringBuilder b) {
        String message;
        if (this.exception.getClass().isAnonymousClass()) {
            message = "Expected anonymous exception";
        } else {
            String exceptionMessage;
            try {
                exceptionMessage = "; message: " + this.toAscii(this.exception.getMessage());
            }
            catch (Throwable t) {
                exceptionMessage = " whose getMessage() throws an exception";
            }
            message = "Expected exception of type " + this.getExceptionName() + exceptionMessage;
        }
        String assertion = "org.junit.Assert.fail(\"" + UtilPlume.escapeJava(message) + "\")";
        b.append(Globals.lineSep).append("  ").append(assertion).append(";").append(Globals.lineSep);
    }

    private @PolyNull @SignatureUnknown String toAscii(@PolyNull @SignatureUnknown String str) {
        if (str == null) {
            return null;
        }
        String normalized = Normalizer.normalize(str, Normalizer.Form.NFD);
        String ascii = normalized.replaceAll("[^ -~]", "?");
        return ascii;
    }

    @Override
    protected void appendCatchBehavior(@SignatureUnknown StringBuilder b) {
        if (this.exception.getClass().isAnonymousClass()) {
            String condition = "e.getClass().isAnonymousClass()";
            String message = "Expected anonymous exception, got \" + e.getClass().getCanonicalName()";
            String assertion = "org.junit.Assert.fail(\"" + message + ")";
            b.append("  if (! ").append(condition).append(") {").append(Globals.lineSep);
            b.append("    ").append(assertion).append(";").append(Globals.lineSep);
            b.append("  }").append(Globals.lineSep);
        }
    }
}

