/*
 * Decompiled with CFR 0.152.
 */
package randoop.test;

import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import randoop.test.Check;
import randoop.test.ExceptionCheck;
import randoop.test.ExpectedExceptionCheck;
import randoop.test.TestChecks;

public class ErrorRevealingChecks
implements TestChecks<ErrorRevealingChecks> {
    public static final @SignatureUnknown ErrorRevealingChecks EMPTY = new ErrorRevealingChecks();
    private @SignatureUnknown Set<@SignatureUnknown Check> checks;

    public ErrorRevealingChecks() {
        this.checks = new LinkedHashSet<Check>();
    }

    public ErrorRevealingChecks(@SignatureUnknown Check check) {
        ErrorRevealingChecks.validateCheck(check);
        this.checks = Collections.singleton(check);
    }

    private static void validateCheck(@SignatureUnknown Check check) {
        if (check instanceof ExceptionCheck && !(check instanceof ExpectedExceptionCheck)) {
            throw new Error("No expected exceptions in error-revealing tests (class " + check.getClass() + "): " + check);
        }
    }

    @Override
    public @SignatureUnknown int count() {
        return this.checks.size();
    }

    @Override
    public @SignatureUnknown Set<@SignatureUnknown Check> checks() {
        return this.checks;
    }

    @Override
    public @SignatureUnknown boolean hasChecks() {
        return !this.checks.isEmpty();
    }

    @Override
    public @SignatureUnknown boolean hasErrorBehavior() {
        return this.hasChecks();
    }

    @Override
    public @SignatureUnknown ExceptionCheck getExceptionCheck() {
        return null;
    }

    @Override
    public void add(@SignatureUnknown Check check) {
        ErrorRevealingChecks.validateCheck(check);
        this.checks.add(check);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ErrorRevealingChecks)) {
            return false;
        }
        ErrorRevealingChecks cks = (ErrorRevealingChecks)obj;
        return this.checks.equals(cks.checks);
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.checks);
    }

    @Override
    public @SignatureUnknown ErrorRevealingChecks commonChecks(@SignatureUnknown ErrorRevealingChecks other) {
        ErrorRevealingChecks common = new ErrorRevealingChecks();
        for (Check ck : this.checks) {
            if (!other.checks.contains(ck)) continue;
            common.add(ck);
        }
        return common;
    }

    @Override
    public @SignatureUnknown boolean hasInvalidBehavior() {
        return false;
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        return this.getClass() + " of size " + this.checks.size() + ": " + this.checks.toString();
    }

    static {
        ErrorRevealingChecks.EMPTY.checks = Collections.emptySet();
    }
}

