/*
 * Decompiled with CFR 0.152.
 */
package randoop.test;

import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import randoop.contract.ObjectContract;

public class ContractSet {
    private final @SignatureUnknown Map<@SignatureUnknown Integer, @SignatureUnknown List<@SignatureUnknown ObjectContract>> contractMap = new LinkedHashMap<Integer, List<ObjectContract>>();
    private @SignatureUnknown int maxArity = 0;

    public @SignatureUnknown List<@SignatureUnknown ObjectContract> getWithArity(@SignatureUnknown int arity) {
        List<ObjectContract> contractList = this.contractMap.get(arity);
        if (contractList == null) {
            contractList = new ArrayList<ObjectContract>();
        }
        return contractList;
    }

    public void add(@SignatureUnknown ObjectContract contract) {
        int arity = contract.getArity();
        List<ObjectContract> contractList = this.contractMap.get(arity);
        if (contractList == null) {
            contractList = new ArrayList<ObjectContract>();
            if (arity > this.maxArity) {
                this.maxArity = contract.getArity();
            }
        }
        contractList.add(contract);
        this.contractMap.put(arity, contractList);
    }

    @SignatureUnknown int getMaxArity() {
        return this.maxArity;
    }

    public @SignatureUnknown boolean isEmpty() {
        return this.contractMap.isEmpty();
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        int cardinality = 0;
        StringBuilder contractString = new StringBuilder("");
        for (int i = 0; i <= this.maxArity; ++i) {
            List<ObjectContract> contracts = this.contractMap.get(i);
            if (contracts == null) continue;
            contractString.append(String.format("    arity %d: %s%n", i, contracts));
            cardinality += contracts.size();
        }
        return String.format("ContractSet[size=%d]%n%s", cardinality, contractString.toString());
    }
}

