/*
 * Decompiled with CFR 0.152.
 */
package randoop.sequence;

import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.util.ArrayList;
import java.util.List;
import randoop.sequence.Sequence;
import randoop.sequence.Variable;
import randoop.types.Type;
import randoop.util.Randomness;
import randoop.util.SimpleList;

public final class TupleSequence {
    public @SignatureUnknown Sequence sequence;
    private @SignatureUnknown List<@SignatureUnknown Integer> outputIndices;

    public TupleSequence(@SignatureUnknown List<@SignatureUnknown Sequence> sequences, @SignatureUnknown List<@SignatureUnknown Integer> variables) {
        assert (sequences.size() == variables.size()) : "must be one variable for each sequence";
        this.sequence = Sequence.concatenate(sequences);
        this.outputIndices = new ArrayList<Integer>();
        int size = 0;
        for (int i = 0; i < sequences.size(); ++i) {
            this.outputIndices.add(size + variables.get(i));
            size += sequences.get(i).size();
        }
    }

    public @SignatureUnknown List<@SignatureUnknown Integer> getOutputIndices() {
        return this.outputIndices;
    }

    public static @SignatureUnknown TupleSequence createElementsSequence(@SignatureUnknown SimpleList<@SignatureUnknown Sequence> candidates, @SignatureUnknown int length, @SignatureUnknown Type elementType) {
        ArrayList<Sequence> sequences = new ArrayList<Sequence>();
        ArrayList<Integer> variables = new ArrayList<Integer>();
        for (int i = 0; i < length; ++i) {
            Sequence sequence = candidates.get(Randomness.nextRandomInt(candidates.size()));
            sequences.add(sequence);
            Variable element = sequence.randomVariableForTypeLastStatement(elementType, false);
            assert (element != null);
            variables.add(element.index);
        }
        return new TupleSequence(sequences, variables);
    }
}

