/*
 * Decompiled with CFR 0.152.
 */
package randoop.sequence;

import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import randoop.Globals;
import randoop.SubTypeSet;
import randoop.main.GenInputsAbstract;
import randoop.reflection.TypeInstantiator;
import randoop.sequence.Sequence;
import randoop.sequence.Variable;
import randoop.types.ClassOrInterfaceType;
import randoop.types.Type;
import randoop.util.ListOfLists;
import randoop.util.Log;
import randoop.util.SimpleArrayList;
import randoop.util.SimpleList;

public class SequenceCollection {
    private @SignatureUnknown Map<@SignatureUnknown Type, @SignatureUnknown SimpleArrayList<@SignatureUnknown Sequence>> sequenceMap = new LinkedHashMap<Type, SimpleArrayList<Sequence>>();
    private @SignatureUnknown SubTypeSet typeSet = new SubTypeSet(false);
    private @SignatureUnknown Set<@SignatureUnknown Type> typesAndSupertypes = new TreeSet<Type>();
    private @SignatureUnknown int sequenceCount = 0;

    private void checkRep() {
        if (!GenInputsAbstract.debug_checks) {
            return;
        }
        if (this.sequenceMap.size() != this.typeSet.size()) {
            String b = "sequenceMap.keySet()=" + Globals.lineSep + this.sequenceMap.keySet() + ", typeSet.types=" + Globals.lineSep + this.typeSet.types;
            throw new IllegalStateException(b);
        }
    }

    public @SignatureUnknown int size() {
        return this.sequenceCount;
    }

    public void clear() {
        Log.logPrintf("Clearing sequence collection.%n", new Object[0]);
        this.sequenceMap = new LinkedHashMap<Type, SimpleArrayList<Sequence>>();
        this.typeSet = new SubTypeSet(false);
        this.sequenceCount = 0;
        this.checkRep();
    }

    public SequenceCollection() {
        this(new ArrayList<Sequence>());
    }

    public SequenceCollection(@SignatureUnknown Collection<@SignatureUnknown Sequence> initialSequences) {
        if (initialSequences == null) {
            throw new IllegalArgumentException("initialSequences is null.");
        }
        this.sequenceMap = new LinkedHashMap<Type, SimpleArrayList<Sequence>>();
        this.typeSet = new SubTypeSet(false);
        this.sequenceCount = 0;
        this.addAll(initialSequences);
        this.checkRep();
    }

    public void addAll(@SignatureUnknown Collection<@SignatureUnknown Sequence> col) {
        if (col == null) {
            throw new IllegalArgumentException("col is null");
        }
        for (Sequence c : col) {
            this.add(c);
        }
    }

    public void addAll(@SignatureUnknown SequenceCollection components) {
        for (SimpleArrayList<Sequence> s2 : components.sequenceMap.values()) {
            for (Sequence seq : s2) {
                this.add(seq);
            }
        }
    }

    public void add(@SignatureUnknown Sequence sequence) {
        List<Type> formalTypes = sequence.getTypesForLastStatement();
        List<Variable> arguments = sequence.getVariablesOfLastStatement();
        assert (formalTypes.size() == arguments.size());
        for (int i = 0; i < formalTypes.size(); ++i) {
            Variable argument = arguments.get(i);
            assert (formalTypes.get(i).isAssignableFrom(argument.getType())) : formalTypes.get(i).getBinaryName() + " should be assignable from " + argument.getType().getBinaryName();
            if (!sequence.isActive(argument.getDeclIndex())) continue;
            Type type = formalTypes.get(i);
            this.typesAndSupertypes.add(type);
            if (type.isClassOrInterfaceType()) {
                this.typesAndSupertypes.addAll(((ClassOrInterfaceType)type).getSuperTypes());
            }
            this.typeSet.add(type);
            this.updateCompatibleMap(sequence, type);
        }
        this.checkRep();
    }

    private void updateCompatibleMap(@SignatureUnknown Sequence sequence, @SignatureUnknown Type type) {
        SimpleArrayList<Sequence> set = this.sequenceMap.get(type);
        if (set == null) {
            set = new SimpleArrayList();
            this.sequenceMap.put(type, set);
        }
        Log.logPrintf("Adding sequence #%d of type %s of length %d%n", set.size() + 1, type, sequence.size());
        boolean added = set.add(sequence);
        assert (added);
        ++this.sequenceCount;
    }

    public @SignatureUnknown SimpleList<@SignatureUnknown Sequence> getSequencesForType(@SignatureUnknown Type type, @SignatureUnknown boolean exactMatch, @SignatureUnknown boolean onlyReceivers) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        Log.logPrintf("getSequencesForType(%s, %s, %s)%n", type, exactMatch, onlyReceivers);
        ArrayList resultList = new ArrayList();
        if (exactMatch) {
            SimpleList l = this.sequenceMap.get(type);
            if (l != null) {
                resultList.add(l);
            }
        } else {
            for (Type compatibleType : this.typeSet.getMatches(type)) {
                Log.logPrintf("candidate compatibleType (isNonreceiverType=%s): %s%n", compatibleType.isNonreceiverType(), compatibleType);
                if (onlyReceivers && compatibleType.isNonreceiverType()) continue;
                SimpleArrayList<Sequence> newMethods = this.sequenceMap.get(compatibleType);
                Log.logPrintf("  Adding %d methods.%n", newMethods.size());
                resultList.add(newMethods);
            }
        }
        if (resultList.isEmpty()) {
            Log.logPrintf("getSequencesForType: found no sequences matching type %s%n", type);
        }
        ListOfLists<Sequence> selector = new ListOfLists<Sequence>(resultList);
        Log.logPrintf("getSequencesForType(%s) => %s sequences.%n", type, selector.size());
        return selector;
    }

    public @SignatureUnknown Set<@SignatureUnknown Sequence> getAllSequences() {
        LinkedHashSet<Sequence> result = new LinkedHashSet<Sequence>();
        for (SimpleArrayList<Sequence> a : this.sequenceMap.values()) {
            result.addAll(a);
        }
        return result;
    }

    public @SignatureUnknown TypeInstantiator getTypeInstantiator() {
        return new TypeInstantiator(this.typesAndSupertypes);
    }

    public void log() {
        if (!Log.isLoggingOn()) {
            return;
        }
        for (Type t : this.sequenceMap.keySet()) {
            SimpleArrayList<Sequence> a = this.sequenceMap.get(t);
            int asize = a.size();
            Log.logPrintf("Type %s: %d sequences%n", t, asize);
            for (int i = 0; i < asize; ++i) {
                Log.logPrintf("  #%d: %s%n", i, ((Sequence)a.get(i)).toString().trim().replace("\n", "\n       "));
            }
        }
    }
}

