/*
 * Decompiled with CFR 0.152.
 */
package randoop.sequence;

import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Pattern;
import randoop.Globals;
import randoop.main.GenInputsAbstract;
import randoop.main.RandoopBug;
import randoop.operation.OperationParseException;
import randoop.operation.OperationParser;
import randoop.operation.TypedOperation;
import randoop.sequence.SequenceParseException;
import randoop.sequence.Statement;
import randoop.sequence.StringTooLongException;
import randoop.sequence.TupleSequence;
import randoop.sequence.Value;
import randoop.sequence.Variable;
import randoop.types.JavaTypes;
import randoop.types.NonParameterizedType;
import randoop.types.Type;
import randoop.util.ListOfLists;
import randoop.util.Log;
import randoop.util.OneMoreElementList;
import randoop.util.Randomness;
import randoop.util.SimpleArrayList;
import randoop.util.SimpleList;

public final class Sequence {
    public final @SignatureUnknown SimpleList<@SignatureUnknown Statement> statements;
    private transient @SignatureUnknown List<@SignatureUnknown Variable> lastStatementVariables;
    private transient @SignatureUnknown List<@SignatureUnknown Type> lastStatementTypes;
    private transient @SignatureUnknown boolean shouldInlineLiterals = true;
    private @SignatureUnknown BitSet activeFlags;
    private final @SignatureUnknown int savedHashCode;
    private final @SignatureUnknown int savedNetSize;

    public Sequence() {
        this(new SimpleArrayList<Statement>(), 0, 0);
    }

    private Sequence(@SignatureUnknown SimpleList<@SignatureUnknown Statement> statements, @SignatureUnknown int hashCode, @SignatureUnknown int netSize) {
        if (statements == null) {
            throw new IllegalArgumentException("`statements' argument cannot be null");
        }
        this.statements = statements;
        this.savedHashCode = hashCode;
        this.savedNetSize = netSize;
        this.computeLastStatementInfo();
        this.activeFlags = new BitSet(this.size());
        this.setAllActiveFlags();
        this.checkRep();
    }

    public Sequence(@SignatureUnknown SimpleList<@SignatureUnknown Statement> statements) {
        this(statements, Sequence.computeHashcode(statements), Sequence.computeNetSize(statements));
    }

    public static @SignatureUnknown Sequence zero(@SignatureUnknown Type c) {
        return new Sequence().extend(TypedOperation.createNullOrZeroInitializationForType(c), new ArrayList<Variable>());
    }

    public static @SignatureUnknown Sequence createSequenceForPrimitive(@SignatureUnknown Object value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        Type type = Type.forValue(value);
        if (!type.isNonreceiverType()) {
            throw new IllegalArgumentException("value is not a (boxed) primitive or String");
        }
        if (type.isBoxedPrimitive()) {
            type = ((NonParameterizedType)type).toPrimitive();
        }
        if (type.equals(JavaTypes.STRING_TYPE) && !Value.stringLengthOk((String)value)) {
            throw new StringTooLongException((String)value);
        }
        return new Sequence().extend(TypedOperation.createPrimitiveInitialization(type, value), new Variable[0]);
    }

    public static @SignatureUnknown Sequence createSequence(@SignatureUnknown TypedOperation operation, @SignatureUnknown List<@SignatureUnknown Sequence> inputSequences, @SignatureUnknown List<@SignatureUnknown Integer> indexes) {
        Sequence inputSequence = Sequence.concatenate(inputSequences);
        ArrayList<Variable> inputs = new ArrayList<Variable>();
        for (Integer inputIndex : indexes) {
            Variable v = inputSequence.getVariable(inputIndex);
            inputs.add(v);
        }
        return inputSequence.extend(operation, inputs);
    }

    public static @SignatureUnknown Sequence createSequence(@SignatureUnknown TypedOperation operation, @SignatureUnknown TupleSequence elementsSequence) {
        ArrayList<Variable> inputs = new ArrayList<Variable>();
        for (int index : elementsSequence.getOutputIndices()) {
            inputs.add(elementsSequence.sequence.getVariable(index));
        }
        return elementsSequence.sequence.extend(operation, inputs);
    }

    public final @SignatureUnknown Sequence extend(@SignatureUnknown TypedOperation operation, @SignatureUnknown List<@SignatureUnknown Variable> inputVariables) {
        this.checkInputs(operation, inputVariables);
        ArrayList<RelativeNegativeIndex> indexList = new ArrayList<RelativeNegativeIndex>(1);
        for (Variable v : inputVariables) {
            indexList.add(Sequence.getRelativeIndexForVariable(this.size(), v));
        }
        Statement statement = new Statement(operation, indexList);
        int newNetSize = operation.isNonreceivingValue() ? this.savedNetSize : this.savedNetSize + 1;
        return new Sequence(new OneMoreElementList<Statement>(this.statements, statement), this.savedHashCode + statement.hashCode(), newNetSize);
    }

    public final @SignatureUnknown Sequence extend(@SignatureUnknown TypedOperation operation, Variable ... inputs) {
        return this.extend(operation, Arrays.asList(inputs));
    }

    public final @SignatureUnknown Sequence extend(@SignatureUnknown Statement statement, @SignatureUnknown List<@SignatureUnknown Variable> inputs) {
        return this.extend(statement.getOperation(), inputs);
    }

    public static @SignatureUnknown Sequence concatenate(@SignatureUnknown List<@SignatureUnknown Sequence> sequences) {
        ArrayList statements1 = new ArrayList();
        int newHashCode = 0;
        int newNetSize = 0;
        for (Sequence c : sequences) {
            newHashCode += c.savedHashCode;
            newNetSize += c.savedNetSize;
            statements1.add(c.statements);
        }
        return new Sequence(new ListOfLists<Statement>(statements1), newHashCode, newNetSize);
    }

    public final @SignatureUnknown Statement getStatement(@SignatureUnknown int index) {
        return this.getStatementWithInputs(index);
    }

    @Pure
    public final @SignatureUnknown int size() {
        return this.statements.size();
    }

    public @SignatureUnknown Variable getVariable(@SignatureUnknown int i) {
        this.checkIndex(i);
        return new Variable(this, i);
    }

    @SignatureUnknown List<@SignatureUnknown Variable> getVariablesOfLastStatement() {
        return this.lastStatementVariables;
    }

    @SignatureUnknown List<@SignatureUnknown Type> getTypesForLastStatement() {
        return this.lastStatementTypes;
    }

    public @SignatureUnknown Variable getLastVariable() {
        return new Variable(this, this.statements.size() - 1);
    }

    public @SignatureUnknown Statement getCreatingStatement(@SignatureUnknown Variable value) {
        if (value.sequence != this) {
            throw new IllegalArgumentException("value.owner != this");
        }
        return this.statements.get(value.index);
    }

    public @SignatureUnknown List<@SignatureUnknown Variable> getInputs(@SignatureUnknown int statementIndex) {
        ArrayList<Variable> inputsAsVariables = new ArrayList<Variable>();
        for (RelativeNegativeIndex relIndex : this.statements.get((int)statementIndex).inputs) {
            inputsAsVariables.add(this.getVariableForInput(statementIndex, relIndex));
        }
        return inputsAsVariables;
    }

    @SideEffectFree
    public @SignatureUnknown String toCodeString() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            if (i != this.size() - 1 && this.shouldInlineLiterals() && this.getStatement(i).getInlinedForm() != null) continue;
            this.appendCode(b, i);
            b.append(Globals.lineSep);
        }
        return b.toString();
    }

    private @SignatureUnknown String toFullCodeString() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            this.appendCode(b, i);
        }
        return b.toString();
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        return this.toCodeString();
    }

    public @SignatureUnknown boolean hasActiveFlags() {
        return !this.activeFlags.isEmpty();
    }

    @SignatureUnknown boolean isActive(@SignatureUnknown int i) {
        return this.activeFlags.get(i);
    }

    private void setAllActiveFlags() {
        this.activeFlags.set(0, this.size());
    }

    public void clearAllActiveFlags() {
        this.activeFlags.clear(0, this.size());
    }

    public void clearActiveFlag(@SignatureUnknown int i) {
        this.activeFlags.clear(i);
    }

    private static @SignatureUnknown RelativeNegativeIndex getRelativeIndexForVariable(@SignatureUnknown int statementPosition, @SignatureUnknown Variable v) {
        if (v.index >= statementPosition) {
            throw new IllegalArgumentException();
        }
        return new RelativeNegativeIndex(-(statementPosition - v.index));
    }

    private @SignatureUnknown Variable getVariableForInput(@SignatureUnknown int statementPosition, @SignatureUnknown RelativeNegativeIndex input) {
        int absoluteIndex = statementPosition + input.index;
        if (absoluteIndex < 0) {
            throw new IllegalArgumentException("index should be non-negative: " + absoluteIndex);
        }
        return new Variable(this, absoluteIndex);
    }

    private static @SignatureUnknown int computeHashcode(@SignatureUnknown SimpleList<@SignatureUnknown Statement> statements) {
        int hashCode = 0;
        for (int i = 0; i < statements.size(); ++i) {
            Statement s2 = statements.get(i);
            hashCode += s2.hashCode();
        }
        return hashCode;
    }

    private static @SignatureUnknown int computeNetSize(@SignatureUnknown SimpleList<@SignatureUnknown Statement> statements) {
        int netSize = 0;
        for (int i = 0; i < statements.size(); ++i) {
            if (statements.get(i).isNonreceivingInitialization()) continue;
            ++netSize;
        }
        return netSize;
    }

    private void computeLastStatementInfo() {
        this.lastStatementTypes = new ArrayList<Type>();
        this.lastStatementVariables = new ArrayList<Variable>();
        if (!this.statements.isEmpty()) {
            int lastStatementIndex = this.statements.size() - 1;
            Statement lastStatement = this.statements.get(lastStatementIndex);
            if (!lastStatement.getOutputType().isVoid()) {
                this.lastStatementTypes.add(lastStatement.getOutputType());
                this.lastStatementVariables.add(new Variable(this, lastStatementIndex));
            }
            if (lastStatement.inputs.size() != lastStatement.getInputTypes().size()) {
                throw new RuntimeException(lastStatement.inputs + ", " + lastStatement.getInputTypes() + ", " + lastStatement.toString());
            }
            List<Variable> v = this.getInputs(lastStatementIndex);
            if (v.size() != lastStatement.getInputTypes().size()) {
                throw new RuntimeException();
            }
            for (int i = 0; i < v.size(); ++i) {
                Variable actualArgument = v.get(i);
                assert (lastStatement.getInputTypes().get(i).isAssignableFrom(actualArgument.getType()));
                this.lastStatementTypes.add(actualArgument.getType());
                this.lastStatementVariables.add(actualArgument);
            }
        }
    }

    private void checkRep() {
        if (!GenInputsAbstract.debug_checks) {
            return;
        }
        if (this.statements == null) {
            throw new RuntimeException("statements == null");
        }
        for (int si = 0; si < this.statements.size(); ++si) {
            Statement statementWithInputs = this.statements.get(si);
            if (statementWithInputs == null) {
                throw new IllegalStateException("Null statement in sequence: " + Globals.lineSep + this.toString());
            }
            if (statementWithInputs.inputs == null) {
                throw new IllegalArgumentException("parameters cannot be null.");
            }
            if (statementWithInputs.getInputTypes().size() != statementWithInputs.inputs.size()) {
                throw new IllegalArgumentException("statement.getInputConstraints().size()=" + statementWithInputs.getInputTypes().size() + " is different from inputIndices.length=" + statementWithInputs.inputs.size() + ", sequence: " + this.toString());
            }
            for (int i = 0; i < statementWithInputs.inputs.size(); ++i) {
                int index = statementWithInputs.inputs.get((int)i).index;
                if (index >= 0) {
                    throw new IllegalStateException();
                }
                Type newRefConstraint = this.statements.get(si + statementWithInputs.inputs.get((int)i).index).getOutputType();
                if (newRefConstraint == null) {
                    throw new IllegalStateException();
                }
                if (statementWithInputs.getInputTypes().get(i).isAssignableFrom(newRefConstraint)) continue;
                throw new IllegalArgumentException(i + "th input constraint " + newRefConstraint + " does not imply statement's " + i + "th input constraint " + statementWithInputs.getInputTypes().get(i) + Globals.lineSep + ".Sequence:" + Globals.lineSep + this.toString());
            }
        }
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public final @SignatureUnknown boolean equals(@SignatureUnknown Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sequence)) {
            return false;
        }
        Sequence other = (Sequence)o;
        if (this.getStatementsWithInputs().size() != other.getStatementsWithInputs().size()) {
            return GenInputsAbstract.debug_checks && this.verifyFalse("size", other);
        }
        for (int i = 0; i < this.statements.size(); ++i) {
            Statement thisStatement = this.statements.get(i);
            Statement otherStatement = other.statements.get(i);
            if (GenInputsAbstract.debug_checks) {
                assert (this.statements.get(i) == thisStatement);
                assert (other.statements.get(i) == otherStatement);
            }
            if (thisStatement.equals(otherStatement)) continue;
            return GenInputsAbstract.debug_checks && this.verifyFalse("statement index " + i, other);
        }
        return true;
    }

    private @SignatureUnknown boolean verifyFalse(@SignatureUnknown String message, @SignatureUnknown Sequence other) {
        if (this.toParsableString().equals(other.toParsableString())) {
            throw new IllegalStateException(message + " : " + this.toString());
        }
        return false;
    }

    @Pure
    public final @SignatureUnknown int hashCode() {
        return this.savedHashCode;
    }

    private @SignatureUnknown boolean isValidIndex(@SignatureUnknown int index) {
        return index >= 0 && index <= this.size() - 1;
    }

    private @SignatureUnknown SimpleList<@SignatureUnknown Statement> getStatementsWithInputs() {
        return this.statements;
    }

    private @SignatureUnknown Statement getStatementWithInputs(@SignatureUnknown int index) {
        if (!this.isValidIndex(index)) {
            throw new IllegalArgumentException("Index " + index + " not valid for sequence " + this);
        }
        return this.getStatementsWithInputs().get(index);
    }

    public @SignatureUnknown List<@SignatureUnknown Variable> allVariablesForTypeLastStatement(@SignatureUnknown Type type, @SignatureUnknown boolean onlyReceivers) {
        ArrayList<Variable> possibleVars = new ArrayList<Variable>(this.lastStatementVariables.size());
        for (Variable i : this.lastStatementVariables) {
            Statement s2 = this.statements.get(i.index);
            Type outputType = s2.getOutputType();
            if (!type.isAssignableFrom(outputType) || onlyReceivers && outputType.isNonreceiverType() || onlyReceivers && this.getCreatingStatement(i).isNonreceivingInitialization()) continue;
            possibleVars.add(i);
        }
        return possibleVars;
    }

    public @SignatureUnknown Variable randomVariableForTypeLastStatement(@SignatureUnknown Type type, @SignatureUnknown boolean onlyReceivers) {
        List<Variable> possibleVars = this.allVariablesForTypeLastStatement(type, onlyReceivers);
        if (possibleVars.isEmpty()) {
            Statement lastStatement = this.statements.get(this.statements.size() - 1);
            throw new RandoopBug(String.format("In rVFTLS, no candidates for %svariable with input type %s from statement %s", onlyReceivers ? "receiver " : "", type, lastStatement));
        }
        if (possibleVars.size() == 1) {
            return possibleVars.get(0);
        }
        return Randomness.randomMember(possibleVars);
    }

    public @SignatureUnknown Variable randomVariableForType(@SignatureUnknown Type type, @SignatureUnknown boolean onlyReceivers) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        ArrayList<Integer> possibleIndices = new ArrayList<Integer>();
        for (int i = 0; i < this.size(); ++i) {
            Type outputType;
            Statement s2 = this.statements.get(i);
            if (!this.isActive(i) || !type.isAssignableFrom(outputType = s2.getOutputType()) || onlyReceivers && outputType.isNonreceiverType()) continue;
            possibleIndices.add(i);
        }
        if (possibleIndices.isEmpty()) {
            throw new RandoopBug("Failed to select variable with input type " + type + " from sequence " + this);
        }
        int index = possibleIndices.size() == 1 ? ((Integer)possibleIndices.get(0)).intValue() : ((Integer)Randomness.randomMember(possibleIndices)).intValue();
        return new Variable(this, index);
    }

    void checkIndex(@SignatureUnknown int i) {
        if (i < 0 || i > this.size() - 1) {
            throw new IllegalArgumentException("index " + i + " out of range [0, " + (this.size() - 1) + "]");
        }
    }

    private void checkInputs(@SignatureUnknown TypedOperation operation, @SignatureUnknown List<@SignatureUnknown Variable> inputVariables) {
        if (operation.getInputTypes().size() != inputVariables.size()) {
            String msg = "statement.getInputTypes().size():" + operation.getInputTypes().size() + " inputVariables.size():" + inputVariables.size() + " statement:" + operation;
            throw new IllegalArgumentException(msg);
        }
        for (int i = 0; i < inputVariables.size(); ++i) {
            if (inputVariables.get((int)i).sequence != this) {
                String msg = "inputVariables.get(" + i + ").owner != this for" + Globals.lineSep + "sequence: " + this.toString() + Globals.lineSep + "statement:" + operation + Globals.lineSep + "inputVariables:" + inputVariables;
                throw new IllegalArgumentException(msg);
            }
            Type newRefConstraint = this.statements.get(inputVariables.get((int)i).index).getOutputType();
            if (newRefConstraint == null) {
                String msg = "newRefConstraint == null for" + Globals.lineSep + "sequence: " + this.toString() + Globals.lineSep + "statement:" + operation + Globals.lineSep + "inputVariables:" + inputVariables;
                throw new IllegalArgumentException(msg);
            }
            Type inputType = operation.getInputTypes().get(i);
            if (inputType.isAssignableFrom(newRefConstraint)) continue;
            String msg = String.format("Mismatch at %dth argument:%n  %s%n is not assignable from%n  %s%n", i, Log.toStringAndClass(inputType), Log.toStringAndClass(newRefConstraint)) + String.format("Sequence:%n%s%nstatement:%s%ninputVariables:%s", this, operation, inputVariables);
            throw new IllegalArgumentException(msg);
        }
    }

    public @SignatureUnknown List<@SignatureUnknown Integer> getInputsAsAbsoluteIndices(@SignatureUnknown int i) {
        ArrayList<Integer> inputsAsVariables = new ArrayList<Integer>();
        for (RelativeNegativeIndex relIndex : this.statements.get((int)i).inputs) {
            inputsAsVariables.add(this.getVariableForInput((int)i, (RelativeNegativeIndex)relIndex).index);
        }
        return inputsAsVariables;
    }

    public void appendCode(@SignatureUnknown StringBuilder b, @SignatureUnknown int index) {
        this.getStatement(index).appendCode(this.getVariable(index), this.getInputs(index), b);
    }

    public @SignatureUnknown String toParsableString() {
        return this.toParsableString(Globals.lineSep);
    }

    private @SignatureUnknown String toParsableString(@SignatureUnknown String statementSep) {
        assert (statementSep != null);
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            Statement sk = this.getStatement(i);
            b.append(sk.toParsableString(Variable.classToVariableName(sk.getOutputType()) + i, this.getInputs(i)));
            b.append(statementSep);
        }
        return b.toString();
    }

    public static @SignatureUnknown Sequence parse(@SignatureUnknown List<@SignatureUnknown String> statements) throws @SignatureUnknown SequenceParseException {
        LinkedHashMap<String, Integer> valueMap = new LinkedHashMap<String, Integer>();
        Sequence sequence = new Sequence();
        int statementCount = 0;
        try {
            for (String statement : statements) {
                TypedOperation operation;
                String msg;
                statement = statement.trim();
                int equalsInd = statement.indexOf(61);
                int colonInd = statement.lastIndexOf(58);
                if (equalsInd == -1) {
                    msg = "A statement must be of the form varname = <operation-name> : varname ... varname but the " + statementCount + "-th (1-based) is missing an \"=\" symbol.";
                    throw new SequenceParseException(msg, statements, statementCount);
                }
                if (colonInd == -1) {
                    msg = "A statement must be of the form varname = <operation-name> : varname ... varname but the " + statementCount + "-th (1-based) is missing a \":\" symbol.";
                    throw new SequenceParseException(msg, statements, statementCount);
                }
                String newVar = statement.substring(0, equalsInd).trim();
                String opStr = statement.substring(equalsInd + 1, colonInd).trim();
                String inVarsStr = statement.substring(colonInd + 1).trim();
                if (valueMap.containsKey(newVar)) {
                    String msg2 = "(Statement " + statementCount + ") result variable name " + newVar + " was already declared in a previous statement.";
                    throw new SequenceParseException(msg2, statements, statementCount);
                }
                System.out.println("operation string: " + opStr);
                try {
                    operation = OperationParser.parse(opStr);
                }
                catch (OperationParseException e) {
                    throw new SequenceParseException(e.getMessage(), statements, statementCount);
                }
                assert (operation != null);
                String[] inVars = new String[]{};
                if (!inVarsStr.trim().isEmpty()) {
                    inVars = inVarsStr.split("\\s");
                }
                if (inVars.length != operation.getInputTypes().size()) {
                    String msg3 = "Number of input variables given (" + inVarsStr + ") does not match expected (expected " + operation.getInputTypes().size() + ")";
                    throw new SequenceParseException(msg3, statements, statementCount);
                }
                ArrayList<Variable> inputs = new ArrayList<Variable>();
                for (String inVar : inVars) {
                    Integer index = (Integer)valueMap.get(inVar);
                    if (index == null) {
                        String msg4 = "(Statement " + statementCount + ") input variable name " + newVar + " is not declared by a previous statement.";
                        throw new IllegalArgumentException(msg4);
                    }
                    inputs.add(sequence.getVariable(index));
                }
                sequence = sequence.extend(operation, inputs);
                valueMap.put(newVar, sequence.getLastVariable().getDeclIndex());
                ++statementCount;
            }
        }
        catch (RuntimeException e) {
            StringBuilder b = new StringBuilder();
            b.append("Error while parsing the following list of strings as a sequence (error was at index ").append(statementCount).append("):").append(Globals.lineSep).append(Globals.lineSep);
            for (String s2 : statements) {
                b.append(s2).append(Globals.lineSep);
            }
            b.append("").append(Globals.lineSep).append(Globals.lineSep);
            b.append("Error: ").append(e.toString()).append(Globals.lineSep);
            b.append("Stack trace:").append(Globals.lineSep);
            for (StackTraceElement s3 : e.getStackTrace()) {
                b.append(s3.toString());
            }
            throw new Error(b.toString());
        }
        return sequence;
    }

    public static @SignatureUnknown Sequence parse(@SignatureUnknown String string) throws @SignatureUnknown SequenceParseException {
        return Sequence.parse(Arrays.asList(string.split(Globals.lineSep)));
    }

    public @SignatureUnknown boolean isNonreceiver() {
        return this.size() == 1 && this.getStatement(0).isNonreceivingInitialization();
    }

    public @SignatureUnknown boolean hasUseOfMatchingClass(@SignatureUnknown Pattern classNames) {
        for (int i = 0; i < this.statements.size(); ++i) {
            Type declaringType = this.statements.get(i).getDeclaringClass();
            if (declaringType == null || !classNames.matcher(declaringType.getBinaryName()).matches()) continue;
            return true;
        }
        return false;
    }

    @SignatureUnknown Sequence getSubsequence(@SignatureUnknown int index) {
        return new Sequence(this.statements.getSublist(index));
    }

    public void log() {
        if (!Log.isLoggingOn()) {
            return;
        }
        try {
            GenInputsAbstract.log.write(Globals.lineSep);
            GenInputsAbstract.log.write(this.toFullCodeString());
            GenInputsAbstract.log.write(Globals.lineSep);
            GenInputsAbstract.log.flush();
        }
        catch (IOException e) {
            throw new RandoopBug("Error while logging sequence", e);
        }
    }

    @SignatureUnknown boolean shouldInlineLiterals() {
        return this.shouldInlineLiterals;
    }

    public void doNotInlineLiterals() {
        this.shouldInlineLiterals = false;
    }

    public @SignatureUnknown TypedOperation getOperation() {
        return this.statements.get(this.statements.size() - 1).getOperation();
    }

    static final class RelativeNegativeIndex {
        public final @SignatureUnknown int index;

        RelativeNegativeIndex(@SignatureUnknown int index) {
            if (index >= 0) {
                throw new IllegalArgumentException("index should be non-positive: " + index);
            }
            this.index = index;
        }

        @SideEffectFree
        public @SignatureUnknown String toString() {
            return Integer.toString(this.index);
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @SignatureUnknown boolean equals(@SignatureUnknown Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RelativeNegativeIndex)) {
                return false;
            }
            return this.index == ((RelativeNegativeIndex)o).index;
        }

        @Pure
        public @SignatureUnknown int hashCode() {
            return this.index;
        }
    }
}

