/*
 * Decompiled with CFR 0.152.
 */
package randoop.sequence;

import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.util.Objects;
import randoop.types.ReferenceType;

public final class ReferenceValue {
    private final @SignatureUnknown ReferenceType type;
    private final @SignatureUnknown Object value;

    ReferenceValue(@SignatureUnknown ReferenceType type, @SignatureUnknown Object value) {
        this.type = type;
        this.value = value;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ReferenceValue)) {
            return false;
        }
        ReferenceValue refValue = (ReferenceValue)obj;
        return this.type.equals(refValue.type) && this.value == refValue.value;
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.type, System.identityHashCode(this.value));
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        return this.value.toString();
    }

    public @SignatureUnknown Object getObjectValue() {
        return this.value;
    }

    public @SignatureUnknown ReferenceType getType() {
        return this.type;
    }
}

