/*
 * Decompiled with CFR 0.152.
 */
package randoop.sequence;

import coveredclass.org.checkerframework.checker.signature.qual.SignatureBottom;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import randoop.sequence.Sequence;
import randoop.sequence.SequenceCollection;
import randoop.types.Type;
import randoop.util.ListOfLists;
import randoop.util.SimpleList;

public class MappedSequences<@SignatureBottom T> {
    private @SignatureUnknown Map<T, @SignatureUnknown SequenceCollection> map = new LinkedHashMap<T, SequenceCollection>();
    private static final @SignatureUnknown SimpleList<@SignatureUnknown Sequence> emptyList;

    public void addSequence(T key, @SignatureUnknown Sequence seq) {
        if (seq == null) {
            throw new IllegalArgumentException("seq is null");
        }
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        SequenceCollection c = this.map.get(key);
        if (c == null) {
            c = new SequenceCollection();
            this.map.put(key, c);
        }
        c.add(seq);
    }

    public @SignatureUnknown SimpleList<@SignatureUnknown Sequence> getSequences(T key, @SignatureUnknown Type desiredType) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        SequenceCollection c = this.map.get(key);
        if (c == null) {
            return emptyList;
        }
        return this.map.get(key).getSequencesForType(desiredType, true, false);
    }

    public @SignatureUnknown Set<@SignatureUnknown Sequence> getAllSequences() {
        LinkedHashSet<Sequence> result = new LinkedHashSet<Sequence>();
        for (SequenceCollection c : this.map.values()) {
            result.addAll(c.getAllSequences());
        }
        return result;
    }

    static {
        List emptyJDKList = Collections.emptyList();
        emptyList = new ListOfLists<Sequence>(emptyJDKList);
    }
}

