/*
 * Decompiled with CFR 0.152.
 */
package randoop.sequence;

import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureBottom;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import randoop.ExceptionalExecution;
import randoop.ExecutionOutcome;
import randoop.ExecutionVisitor;
import randoop.Globals;
import randoop.NormalExecution;
import randoop.NotExecuted;
import randoop.condition.ExpectedOutcomeTable;
import randoop.main.GenInputsAbstract;
import randoop.operation.TypedOperation;
import randoop.sequence.Execution;
import randoop.sequence.ReferenceValue;
import randoop.sequence.Sequence;
import randoop.sequence.SequenceExecutionException;
import randoop.sequence.Statement;
import randoop.sequence.Value;
import randoop.sequence.Variable;
import randoop.test.Check;
import randoop.test.ExceptionCheck;
import randoop.test.InvalidChecks;
import randoop.test.InvalidValueCheck;
import randoop.test.TestCheckGenerator;
import randoop.test.TestChecks;
import randoop.types.ReferenceType;
import randoop.types.Type;
import randoop.util.IdentityMultiMap;
import randoop.util.Log;
import randoop.util.ProgressDisplay;

public class ExecutableSequence {
    public @SignatureUnknown Sequence sequence;
    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown TestChecks<@SignatureUnknown @SignatureBottom ?> checks;
    private transient @SignatureUnknown Execution executionResults;
    public @SignatureUnknown long gentime = -1L;
    public @SignatureUnknown long exectime = -1L;
    private @SignatureUnknown boolean hasNullInput = false;
    private static @SignatureUnknown ByteArrayOutputStream output_buffer = new ByteArrayOutputStream();
    private static @SignatureUnknown PrintStream output_buffer_stream = new PrintStream(output_buffer);
    private @SignatureUnknown IdentityMultiMap<@SignatureUnknown Object, @SignatureUnknown Variable> variableMap = new IdentityMultiMap();
    public @SignatureUnknown List<@SignatureUnknown Sequence> componentSequences = Collections.emptyList();

    public ExecutableSequence(@SignatureUnknown Sequence sequence) {
        this.sequence = sequence;
        this.executionResults = new Execution(sequence);
    }

    private void reset() {
        this.executionResults = new Execution(this.sequence);
        this.exectime = -1L;
        this.hasNullInput = false;
        this.variableMap = new IdentityMultiMap();
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.sequence.size(); ++i) {
            this.sequence.appendCode(b, i);
            if (this.executionResults.size() > i) {
                b.append(" // ");
                b.append(this.executionResults.get(i).toString());
            }
            if (i == this.sequence.size() - 1 && this.checks != null) {
                for (Check check : this.checks.checks()) {
                    b.append(Globals.lineSep);
                    b.append(check.toString());
                }
            }
            b.append(Globals.lineSep);
        }
        return b.toString();
    }

    private @SignatureUnknown List<@SignatureUnknown String> toCodeLines() {
        ArrayList<String> lines = new ArrayList<String>();
        for (int i = 0; i < this.sequence.size(); ++i) {
            if (this.sequence.shouldInlineLiterals() && this.sequence.getStatement(i).getInlinedForm() != null && i < this.sequence.size() - 1) continue;
            StringBuilder oneStatement = new StringBuilder();
            this.sequence.appendCode(oneStatement, i);
            if (i == this.sequence.size() - 1 && this.checks != null) {
                ExceptionCheck exObs = this.checks.getExceptionCheck();
                if (exObs != null) {
                    oneStatement.insert(0, exObs.toCodeStringPreStatement());
                    oneStatement.append(exObs.toCodeStringPostStatement());
                }
                for (Check d : this.checks.checks()) {
                    oneStatement.insert(0, d.toCodeStringPreStatement());
                    oneStatement.append(Globals.lineSep).append(d.toCodeStringPostStatement());
                }
            }
            lines.add(oneStatement.toString());
        }
        return lines;
    }

    public @SignatureUnknown String toCodeString() {
        StringBuilder b = new StringBuilder();
        for (String line : this.toCodeLines()) {
            b.append(line).append(Globals.lineSep);
        }
        return b.toString();
    }

    public @SignatureUnknown String statementToCodeString(@SignatureUnknown int i) {
        StringBuilder oneStatement = new StringBuilder();
        this.sequence.appendCode(oneStatement, i);
        return oneStatement.toString();
    }

    public void execute(@SignatureUnknown ExecutionVisitor visitor, @SignatureUnknown TestCheckGenerator gen) {
        this.execute(visitor, gen, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(@SignatureUnknown ExecutionVisitor visitor, @SignatureUnknown TestCheckGenerator gen, @SignatureUnknown boolean ignoreException) {
        long startTime = System.nanoTime();
        try {
            visitor.initialize(this);
            this.reset();
            for (int i = 0; i < this.sequence.size(); ++i) {
                TypedOperation operation;
                Object[] inputValues = this.getRuntimeInputs(this.executionResults.outcomes, this.sequence.getInputs(i));
                if (i == this.sequence.size() - 1 && ((operation = this.sequence.getStatement(i).getOperation()).isConstructorCall() || operation.isMethodCall())) {
                    ExpectedOutcomeTable outcomeTable = operation.checkPrestate(inputValues);
                    if (outcomeTable.isInvalidCall()) {
                        this.checks = new InvalidChecks(new InvalidValueCheck(this, i));
                        return;
                    }
                    gen = outcomeTable.addPostCheckGenerator(gen);
                }
                visitor.visitBeforeStatement(this, i);
                ExecutableSequence.executeStatement(this.sequence, this.executionResults.outcomes, i, inputValues);
                ExecutionOutcome statementResult = this.getResult(i);
                if (statementResult instanceof NotExecuted) {
                    throw new Error("Unexecuted statement in sequence: " + this.toString());
                }
                if (statementResult instanceof ExceptionalExecution && i < this.sequence.size() - 1) {
                    if (ignoreException) break;
                    Throwable e = ((ExceptionalExecution)statementResult).getException();
                    String msg = String.format("Exception before final statement%n  statement %d = %s, input = %s):%n  %s%n%s", i, this.sequence.getStatement(i), Arrays.toString(inputValues), e.getMessage() == null ? "[no detail message]" : e.getMessage(), this.sequence);
                    throw new Error(msg, e);
                }
                visitor.visitAfterStatement(this, i);
            }
            visitor.visitAfterSequence(this);
            if (Value.lastValueSizeOk(this)) {
                this.checks = gen.generateTestChecks(this);
            } else {
                Log.logPrintf("Excluding from generateTestChecks due to value too large in last statement%n", new Object[0]);
            }
        }
        finally {
            this.exectime = System.nanoTime() - startTime;
        }
    }

    public @SignatureUnknown Object @SignatureUnknown [] getRuntimeInputs(@SignatureUnknown List<@SignatureUnknown Variable> inputs) {
        return this.getRuntimeInputs(this.executionResults.outcomes, inputs);
    }

    private @SignatureUnknown Object @SignatureUnknown [] getRuntimeInputs(@SignatureUnknown List<@SignatureUnknown ExecutionOutcome> outcome, @SignatureUnknown List<@SignatureUnknown Variable> inputs) {
        Object[] ros;
        for (Object ro : ros = ExecutableSequence.getRuntimeValuesForVars(inputs, outcome)) {
            if (ro != null) continue;
            this.hasNullInput = true;
        }
        return ros;
    }

    public static @SignatureUnknown Object @SignatureUnknown [] getRuntimeValuesForVars(@SignatureUnknown List<@SignatureUnknown Variable> vars, @SignatureUnknown Execution execution) {
        return ExecutableSequence.getRuntimeValuesForVars(vars, execution.outcomes);
    }

    private static @SignatureUnknown Object @SignatureUnknown [] getRuntimeValuesForVars(@SignatureUnknown List<@SignatureUnknown Variable> vars, @SignatureUnknown List<@SignatureUnknown ExecutionOutcome> execution) {
        Object[] runtimeObjects = new Object[vars.size()];
        for (int j = 0; j < runtimeObjects.length; ++j) {
            int creatingStatementIdx = vars.get(j).getDeclIndex();
            assert (execution.get(creatingStatementIdx) instanceof NormalExecution) : execution.get(creatingStatementIdx).getClass();
            NormalExecution ne = (NormalExecution)execution.get(creatingStatementIdx);
            runtimeObjects[j] = ne.getRuntimeValue();
        }
        return runtimeObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeStatement(@SignatureUnknown Sequence s2, @SignatureUnknown List<@SignatureUnknown ExecutionOutcome> outcome, @SignatureUnknown int index, @SignatureUnknown Object @SignatureUnknown [] inputVariables) {
        Statement statement = s2.getStatement(index);
        Object object = ProgressDisplay.print_synchro;
        synchronized (object) {
            ExecutionOutcome r;
            PrintStream orig_out = System.out;
            PrintStream orig_err = System.err;
            if (GenInputsAbstract.capture_output) {
                System.out.flush();
                System.err.flush();
                System.setOut(output_buffer_stream);
                System.setErr(output_buffer_stream);
            }
            try {
                r = statement.execute(inputVariables);
            }
            catch (SequenceExecutionException e) {
                throw new SequenceExecutionException("Problem while executing " + statement, e);
            }
            finally {
                if (GenInputsAbstract.capture_output) {
                    System.setOut(orig_out);
                    System.setErr(orig_err);
                }
            }
            assert (r != null);
            if (GenInputsAbstract.capture_output) {
                output_buffer_stream.flush();
                r.set_output(output_buffer.toString());
                output_buffer.reset();
            }
            outcome.set(index, r);
        }
    }

    public @SignatureUnknown ExecutionOutcome getResult(@SignatureUnknown int index) {
        return this.executionResults.get(index);
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown TestChecks<@SignatureUnknown @SignatureBottom ?> getChecks() {
        return this.checks;
    }

    private @SignatureUnknown Object getValue(@SignatureUnknown int index) {
        ExecutionOutcome result = this.getResult(index);
        if (result instanceof NormalExecution) {
            return ((NormalExecution)result).getRuntimeValue();
        }
        throw new Error("Abnormal execution in sequence: " + this);
    }

    public @SignatureUnknown List<@SignatureUnknown ReferenceValue> getLastStatementValues() {
        LinkedHashSet<ReferenceValue> values = new LinkedHashSet<ReferenceValue>();
        Object outputValue = this.getValue(this.sequence.size() - 1);
        Variable outputVariable = this.sequence.getLastVariable();
        this.addReferenceValue(outputVariable, outputValue, values);
        for (Variable inputVariable : this.sequence.getInputs(this.sequence.size() - 1)) {
            Object inputValue = this.getValue(inputVariable.index);
            this.addReferenceValue(inputVariable, inputValue, values);
        }
        return new ArrayList<ReferenceValue>(values);
    }

    private void addReferenceValue(@SignatureUnknown Variable variable, @SignatureUnknown Object value, @SignatureUnknown Set<@SignatureUnknown ReferenceValue> refValues) {
        Type type;
        if (value != null && (type = variable.getType()).isReferenceType() && !type.isString()) {
            refValues.add(new ReferenceValue((ReferenceType)type, value));
            this.variableMap.put(value, variable);
        }
    }

    public @SignatureUnknown List<@SignatureUnknown ReferenceValue> getInputValues() {
        HashSet<Integer> skipSet = new HashSet<Integer>();
        for (Variable inputVariable : this.sequence.getInputs(this.sequence.size() - 1)) {
            skipSet.add(inputVariable.index);
        }
        LinkedHashSet<ReferenceValue> values = new LinkedHashSet<ReferenceValue>();
        for (int i = 0; i < this.sequence.size() - 1; ++i) {
            if (skipSet.contains(i)) continue;
            Object value = this.getValue(i);
            Variable variable = this.sequence.getVariable(i);
            this.addReferenceValue(variable, value, values);
        }
        return new ArrayList<ReferenceValue>(values);
    }

    public @SignatureUnknown List<@SignatureUnknown Variable> getVariables(@SignatureUnknown Object value) {
        Set<Variable> variables = this.variableMap.get(value);
        if (variables == null) {
            return null;
        }
        return new ArrayList<Variable>(variables);
    }

    public @SignatureUnknown Variable getVariable(@SignatureUnknown Object value) {
        return this.variableMap.get(value).iterator().next();
    }

    private @SignatureUnknown boolean isNormalExecution(@SignatureUnknown int i) {
        return this.getResult(i) instanceof NormalExecution;
    }

    public @SignatureUnknown int getNonNormalExecutionIndex() {
        for (int i = 0; i < this.sequence.size(); ++i) {
            if (this.isNormalExecution(i)) continue;
            return i;
        }
        return -1;
    }

    public @SignatureUnknown boolean isNormalExecution() {
        return this.getNonNormalExecutionIndex() == -1;
    }

    private @SignatureUnknown int getExceptionIndex(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> exceptionClass) {
        if (exceptionClass == null) {
            throw new IllegalArgumentException("exceptionClass<?> cannot be null");
        }
        for (int i = 0; i < this.sequence.size(); ++i) {
            ExceptionalExecution e;
            if (!(this.getResult(i) instanceof ExceptionalExecution) || !exceptionClass.isAssignableFrom((e = (ExceptionalExecution)this.getResult(i)).getException().getClass())) continue;
            return i;
        }
        return -1;
    }

    public @SignatureUnknown boolean throwsException(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> exceptionClass) {
        return this.getExceptionIndex(exceptionClass) >= 0;
    }

    public @SignatureUnknown boolean hasNonExecutedStatements() {
        return this.getNonExecutedIndex() != -1;
    }

    public @SignatureUnknown int getNonExecutedIndex() {
        for (int i = this.sequence.size() - 1; i >= 0; --i) {
            if (!(this.getResult(i) instanceof NotExecuted)) continue;
            return i;
        }
        return -1;
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.sequence.hashCode(), this.checks.hashCode());
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ExecutableSequence)) {
            return false;
        }
        ExecutableSequence that = (ExecutableSequence)obj;
        return this.sequence.equals(that.sequence) && Objects.equals(this.checks, that.checks);
    }

    public @SignatureUnknown boolean hasNullInput() {
        return this.hasNullInput;
    }

    public @SignatureUnknown boolean hasFailure() {
        return this.checks != null && this.checks.hasErrorBehavior();
    }

    public @SignatureUnknown boolean hasInvalidBehavior() {
        return this.checks != null && this.checks.hasInvalidBehavior();
    }

    public void addCoveredClass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> c) {
        this.executionResults.addCoveredClass(c);
    }

    public @SignatureUnknown boolean coversClass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> c) {
        return this.executionResults.getCoveredClasses().contains(c);
    }

    public @SignatureUnknown TypedOperation getOperation() {
        return this.sequence.getOperation();
    }

    public @SignatureUnknown int size() {
        return this.sequence.size();
    }
}

