/*
 * Decompiled with CFR 0.152.
 */
package randoop.sequence;

import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import randoop.sequence.MappedSequences;
import randoop.sequence.Sequence;
import randoop.types.ClassOrInterfaceType;
import randoop.types.JavaTypes;
import randoop.types.Type;
import randoop.util.ListOfLists;
import randoop.util.SimpleList;

public class ClassLiterals
extends MappedSequences<ClassOrInterfaceType> {
    private static final @SignatureUnknown Map<@SignatureUnknown ClassOrInterfaceType, @SignatureUnknown Set<@SignatureUnknown ClassOrInterfaceType>> hashedSuperClasses = new LinkedHashMap<ClassOrInterfaceType, Set<ClassOrInterfaceType>>();

    @Override
    public void addSequence(@SignatureUnknown ClassOrInterfaceType key, @SignatureUnknown Sequence seq) {
        if (seq == null) {
            throw new IllegalArgumentException("seq is null");
        }
        if (!seq.isNonreceiver()) {
            throw new IllegalArgumentException("seq is not a primitive sequence");
        }
        super.addSequence(key, seq);
    }

    @Override
    public @SignatureUnknown SimpleList<@SignatureUnknown Sequence> getSequences(@SignatureUnknown ClassOrInterfaceType key, @SignatureUnknown Type desiredType) {
        Set<ClassOrInterfaceType> superClasses = hashedSuperClasses.get(key);
        if (superClasses == null) {
            superClasses = this.getSuperClasses(key);
            hashedSuperClasses.put(key, superClasses);
        }
        ArrayList listOfLists = new ArrayList();
        listOfLists.add(super.getSequences(key, desiredType));
        for (ClassOrInterfaceType c : superClasses) {
            listOfLists.add(super.getSequences(c, desiredType));
        }
        return new ListOfLists<Sequence>(listOfLists);
    }

    private @SignatureUnknown Set<@SignatureUnknown ClassOrInterfaceType> getSuperClasses(@SignatureUnknown ClassOrInterfaceType cls) {
        LinkedHashSet<ClassOrInterfaceType> ret = new LinkedHashSet<ClassOrInterfaceType>();
        for (ClassOrInterfaceType sup = cls.getSuperclass(); sup != null && !sup.equals(JavaTypes.OBJECT_TYPE); sup = sup.getSuperclass()) {
            ret.add(sup);
        }
        return ret;
    }
}

