/*
 * Decompiled with CFR 0.152.
 */
package randoop.reflection;

import coveredclass.org.checkerframework.checker.signature.qual.SignatureBottom;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public abstract class VisibilityPredicate {
    public static @SignatureUnknown VisibilityPredicate IS_PUBLIC = new PublicVisibilityPredicate();
    public static @SignatureUnknown VisibilityPredicate IS_NOT_PRIVATE = new NotPrivateVisibilityPredicate();
    public static @SignatureUnknown VisibilityPredicate IS_ANY = new AnyVisibilityPredicate();

    public abstract @SignatureUnknown boolean isVisible(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> var1);

    public abstract @SignatureUnknown boolean isVisible(@SignatureUnknown Method var1);

    public abstract @SignatureUnknown boolean isVisible(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Constructor<@SignatureUnknown @SignatureBottom ?> var1);

    public abstract @SignatureUnknown boolean isVisible(@SignatureUnknown Field var1);

    private static class NotPrivateVisibilityPredicate
    extends VisibilityPredicate {
        private NotPrivateVisibilityPredicate() {
        }

        @Override
        public @SignatureUnknown boolean isVisible(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> c) {
            return (c.getDeclaringClass() == null || this.isVisible(c.getDeclaringClass())) && this.isVisible(c.getModifiers() & Modifier.classModifiers());
        }

        @Override
        public @SignatureUnknown boolean isVisible(@SignatureUnknown Method m3) {
            return this.isVisible(m3.getModifiers() & Modifier.methodModifiers());
        }

        @Override
        public @SignatureUnknown boolean isVisible(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @SignatureUnknown Constructor<@SignatureUnknown @SignatureBottom ?> c) {
            return this.isVisible(c.getModifiers() & Modifier.constructorModifiers());
        }

        @Override
        public @SignatureUnknown boolean isVisible(@SignatureUnknown Field f) {
            return this.isVisible(f.getModifiers() & Modifier.fieldModifiers());
        }

        private @SignatureUnknown boolean isVisible(@SignatureUnknown int mods) {
            return !Modifier.isPrivate(mods);
        }

        @SideEffectFree
        public @SignatureUnknown String toString() {
            return "NotPrivateVisibilityPredicate";
        }
    }

    public static class PackageVisibilityPredicate
    extends VisibilityPredicate {
        private final @SignatureUnknown String packageName;

        public PackageVisibilityPredicate(@SignatureUnknown String packageName) {
            this.packageName = packageName;
        }

        @Override
        public @SignatureUnknown boolean isVisible(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> c) {
            int mods = c.getModifiers() & Modifier.classModifiers();
            return (c.getDeclaringClass() == null || this.isVisible(c.getDeclaringClass())) && this.isVisible(mods, c.getPackage());
        }

        @Override
        public @SignatureUnknown boolean isVisible(@SignatureUnknown Method m3) {
            int mods = m3.getModifiers() & Modifier.methodModifiers();
            return this.isVisible(mods, m3.getDeclaringClass().getPackage());
        }

        @Override
        public @SignatureUnknown boolean isVisible(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @SignatureUnknown Constructor<@SignatureUnknown @SignatureBottom ?> c) {
            int mods = c.getModifiers() & Modifier.constructorModifiers();
            return this.isVisible(mods, c.getDeclaringClass().getPackage());
        }

        @Override
        public @SignatureUnknown boolean isVisible(@SignatureUnknown Field f) {
            int mods = f.getModifiers() & Modifier.fieldModifiers();
            return this.isVisible(mods, f.getDeclaringClass().getPackage());
        }

        private @SignatureUnknown boolean isVisible(@SignatureUnknown int mods, @SignatureUnknown Package otherPackage) {
            String otherPackageName = otherPackage == null ? "" : otherPackage.getName();
            return Modifier.isPublic(mods) || this.packageName.equals(otherPackageName) && !Modifier.isPrivate(mods);
        }

        @SideEffectFree
        public @SignatureUnknown String toString() {
            return "PackageVisibilityPredicate(" + this.packageName + ")";
        }
    }

    private static class PublicVisibilityPredicate
    extends VisibilityPredicate {
        private PublicVisibilityPredicate() {
        }

        @Override
        public @SignatureUnknown boolean isVisible(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> c) {
            return (c.getDeclaringClass() == null || this.isVisible(c.getDeclaringClass())) && this.isVisible(c.getModifiers() & Modifier.classModifiers());
        }

        @Override
        public @SignatureUnknown boolean isVisible(@SignatureUnknown Method m3) {
            return this.isVisible(m3.getModifiers() & Modifier.methodModifiers());
        }

        @Override
        public @SignatureUnknown boolean isVisible(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @SignatureUnknown Constructor<@SignatureUnknown @SignatureBottom ?> c) {
            return this.isVisible(c.getModifiers() & Modifier.constructorModifiers());
        }

        @Override
        public @SignatureUnknown boolean isVisible(@SignatureUnknown Field f) {
            return this.isVisible(f.getModifiers() & Modifier.fieldModifiers());
        }

        private @SignatureUnknown boolean isVisible(@SignatureUnknown int mods) {
            return Modifier.isPublic(mods);
        }

        @SideEffectFree
        public @SignatureUnknown String toString() {
            return "PublicVisibilityPredicate";
        }
    }

    private static class AnyVisibilityPredicate
    extends VisibilityPredicate {
        private AnyVisibilityPredicate() {
        }

        @Override
        public @SignatureUnknown boolean isVisible(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> c) {
            return true;
        }

        @Override
        public @SignatureUnknown boolean isVisible(@SignatureUnknown Method m3) {
            return true;
        }

        @Override
        public @SignatureUnknown boolean isVisible(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @SignatureUnknown Constructor<@SignatureUnknown @SignatureBottom ?> c) {
            return true;
        }

        @Override
        public @SignatureUnknown boolean isVisible(@SignatureUnknown Field f) {
            return true;
        }

        @SideEffectFree
        public @SignatureUnknown String toString() {
            return "AnyVisibilityPredicate";
        }
    }
}

