/*
 * Decompiled with CFR 0.152.
 */
package randoop.reflection;

import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.plumelib.util.CollectionsPlume;
import org.plumelib.util.CombinationIterator;
import randoop.operation.TypedClassOperation;
import randoop.types.BoundsCheck;
import randoop.types.ClassOrInterfaceType;
import randoop.types.GenericClassType;
import randoop.types.InstantiatedType;
import randoop.types.JDKTypes;
import randoop.types.JavaTypes;
import randoop.types.ParameterBound;
import randoop.types.ParameterizedType;
import randoop.types.ReferenceArgument;
import randoop.types.ReferenceType;
import randoop.types.Substitution;
import randoop.types.Type;
import randoop.types.TypeArgument;
import randoop.types.TypeTuple;
import randoop.types.TypeVariable;
import randoop.util.Log;
import randoop.util.Randomness;

public class TypeInstantiator {
    private final @SignatureUnknown Set<@SignatureUnknown Type> inputTypes;

    public TypeInstantiator(@SignatureUnknown Set<@SignatureUnknown Type> inputTypes) {
        this.inputTypes = inputTypes;
    }

    public @SignatureUnknown TypedClassOperation instantiate(@SignatureUnknown TypedClassOperation operation) {
        assert (operation.isGeneric() || operation.hasWildcardTypes()) : "operation " + operation + " must be generic or have wildcards";
        ClassOrInterfaceType declaringType = operation.getDeclaringType();
        if (declaringType.isGeneric()) {
            Type outputType = operation.getOutputType();
            Substitution substitution = operation.isConstructorCall() || operation.isStatic() && ((InstantiatedType)outputType).getGenericClassType().equals(declaringType) ? (declaringType.isSubtypeOf(JDKTypes.SORTED_SET_TYPE) ? this.instantiateSortedSetType(operation) : this.instantiateClass(declaringType)) : this.selectSubstitution(declaringType);
            if (substitution == null) {
                return null;
            }
            operation = operation.substitute(substitution);
        }
        if (operation != null && operation.hasWildcardTypes()) {
            Log.logPrintf("Applying capture conversion to %s%n", operation);
            operation = operation.applyCaptureConversion();
        }
        if (operation != null) {
            operation = this.instantiateOperationTypes(operation);
        }
        return operation;
    }

    private @SignatureUnknown Substitution instantiateSortedSetType(@SignatureUnknown TypedClassOperation operation) {
        assert (operation.isConstructorCall()) : "only call with constructors of SortedSet subtype";
        TypeVariable typeParameter = operation.getDeclaringType().getTypeParameters().get(0);
        TypeTuple opInputTypes = operation.getInputTypes();
        if (opInputTypes.isEmpty()) {
            return this.selectSubstitutionForSortedSet(JavaTypes.COMPARABLE_TYPE, typeParameter);
        }
        if (opInputTypes.size() == 1) {
            ClassOrInterfaceType inputType = (ClassOrInterfaceType)opInputTypes.get(0);
            if (inputType.isInstantiationOf(JDKTypes.COMPARATOR_TYPE)) {
                return this.selectSubstitutionForSortedSet(JDKTypes.COMPARATOR_TYPE, typeParameter);
            }
            if (inputType.isInstantiationOf(JDKTypes.COLLECTION_TYPE)) {
                return this.selectSubstitutionForSortedSet(JavaTypes.COMPARABLE_TYPE, typeParameter);
            }
            if (inputType.isInstantiationOf(JDKTypes.SORTED_SET_TYPE)) {
                return this.selectSubstitutionForSortedSet(JDKTypes.SORTED_SET_TYPE, typeParameter);
            }
        }
        return null;
    }

    private @SignatureUnknown Substitution selectSubstitutionForSortedSet(@SignatureUnknown GenericClassType searchType, @SignatureUnknown TypeVariable typeParameter) {
        Substitution substitution = this.selectSubstitution(searchType);
        if (substitution == null) {
            return null;
        }
        TypeArgument argumentType = searchType.substitute(substitution).getTypeArguments().get(0);
        return new Substitution(typeParameter, ((ReferenceArgument)argumentType).getReferenceType());
    }

    private @SignatureUnknown Substitution instantiateClass(@SignatureUnknown ClassOrInterfaceType type) {
        Substitution substitution;
        boolean tryPrevious = Randomness.weightedCoinFlip(0.5);
        if (tryPrevious && (substitution = this.selectSubstitution(type)) != null) {
            return substitution;
        }
        List<TypeVariable> typeParameters = type.getTypeParameters();
        Substitution substitution2 = this.selectSubstitution(typeParameters);
        if (substitution2 != null) {
            ClassOrInterfaceType instantiatedType = type.substitute(substitution2);
            if (!instantiatedType.isGeneric()) {
                return substitution2;
            }
            Log.logPrintf("Didn't find types to satisfy bounds on generic type: %s%n", type);
        }
        if (!tryPrevious && (substitution = this.selectSubstitution(type)) != null) {
            return substitution;
        }
        return null;
    }

    private @SignatureUnknown Substitution selectSubstitution(@SignatureUnknown ClassOrInterfaceType type, @SignatureUnknown ClassOrInterfaceType patternType) {
        ArrayList<ReferenceType> matches = new ArrayList<ReferenceType>();
        for (Type inputType : this.inputTypes) {
            if (!inputType.isParameterized() || !((ReferenceType)inputType).isInstantiationOf(patternType)) continue;
            matches.add((ReferenceType)inputType);
        }
        if (matches.isEmpty()) {
            return null;
        }
        ReferenceType selectedType = (ReferenceType)Randomness.randomSetMember(matches);
        Substitution result = selectedType.getInstantiatingSubstitution(type);
        return result;
    }

    private @SignatureUnknown Substitution selectSubstitution(@SignatureUnknown ClassOrInterfaceType type) {
        return this.selectSubstitution(type, type);
    }

    private @SignatureUnknown TypedClassOperation instantiateOperationTypes(@SignatureUnknown TypedClassOperation operation) {
        Type paramType;
        LinkedHashSet<TypeVariable> typeParameters = new LinkedHashSet<TypeVariable>();
        Substitution substitution = new Substitution();
        for (Type origParamType : operation.getInputTypes()) {
            Type paramType2 = origParamType.substitute(substitution);
            if (!paramType2.isGeneric()) continue;
            if (paramType2.isClassOrInterfaceType()) {
                Substitution subst = this.selectSubstitution((ParameterizedType)origParamType, (ParameterizedType)paramType2);
                if (subst == null) {
                    return null;
                }
                substitution = substitution.extend(subst);
                continue;
            }
            typeParameters.addAll(((ReferenceType)paramType2).getTypeParameters());
        }
        if (operation.getOutputType().isReferenceType() && (paramType = operation.getOutputType().substitute(substitution)).isGeneric()) {
            typeParameters.addAll(((ReferenceType)paramType).getTypeParameters());
        }
        if (!typeParameters.isEmpty()) {
            typeParameters.removeAll(substitution.keySet());
        }
        if (!typeParameters.isEmpty() && (substitution = this.selectSubstitution(new ArrayList<TypeVariable>(typeParameters), substitution)) == null) {
            return null;
        }
        if ((operation = operation.substitute(substitution)).isGeneric(true)) {
            return null;
        }
        return operation;
    }

    private @SignatureUnknown Substitution selectSubstitution(@SignatureUnknown List<@SignatureUnknown TypeVariable> typeParameters) {
        Substitution substitution = new Substitution();
        return this.selectSubstitution(typeParameters, substitution);
    }

    private @SignatureUnknown Substitution selectSubstitution(@SignatureUnknown List<@SignatureUnknown TypeVariable> typeParameters, @SignatureUnknown Substitution substitution) {
        List<Substitution> substitutionList = this.allExtendingSubstitutions(typeParameters, substitution);
        if (substitutionList.isEmpty()) {
            return null;
        }
        return Randomness.randomMember(substitutionList);
    }

    private @SignatureUnknown List<@SignatureUnknown Substitution> allExtendingSubstitutions(@SignatureUnknown List<@SignatureUnknown TypeVariable> typeParameters, @SignatureUnknown Substitution substitution) {
        ArrayList<TypeVariable> genericParameters = new ArrayList<TypeVariable>();
        ArrayList<TypeVariable> nongenericParameters = new ArrayList<TypeVariable>();
        ArrayList<TypeVariable> captureParameters = new ArrayList<TypeVariable>();
        for (TypeVariable variable : typeParameters) {
            if (variable.hasGenericBound()) {
                genericParameters.add(variable);
                continue;
            }
            if (variable.isCaptureVariable()) {
                captureParameters.add(variable);
                continue;
            }
            nongenericParameters.add(variable);
        }
        List<Substitution> result = new ArrayList<Substitution>();
        if (!genericParameters.isEmpty()) {
            if (!nongenericParameters.isEmpty()) {
                List<List<ReferenceType>> nongenCandidates = this.candidateTypes(nongenericParameters);
                if (nongenCandidates.isEmpty()) {
                    return Collections.emptyList();
                }
                for (List list : CollectionsPlume.iteratorToIterable(new CombinationIterator<ReferenceType>(nongenCandidates))) {
                    Substitution initialSubstitution = substitution.extend(nongenericParameters, list);
                    ArrayList<TypeVariable> parameters = new ArrayList<TypeVariable>();
                    for (TypeVariable variable : genericParameters) {
                        ReferenceType paramType = variable.substitute(initialSubstitution);
                        if (!paramType.isVariable()) continue;
                        parameters.add(variable);
                    }
                    result.addAll(this.allExtendingSubstitutions(parameters, initialSubstitution));
                }
            } else {
                BoundsCheck boundsCheck = new BoundsCheck(genericParameters);
                result = this.allSubstitutions(genericParameters, substitution, boundsCheck);
            }
            if (result.isEmpty()) {
                return result;
            }
        } else if (!nongenericParameters.isEmpty()) {
            if ((substitution = this.selectSubstitutionIndependently(nongenericParameters, substitution)) == null) {
                return Collections.emptyList();
            }
            result.add(substitution);
        }
        if (!captureParameters.isEmpty()) {
            if (result.isEmpty()) {
                result.add(this.selectSubstitutionIndependently(captureParameters, substitution));
            } else {
                ArrayList<Substitution> substList = new ArrayList<Substitution>();
                for (Substitution substitution2 : result) {
                    substList.add(this.selectSubstitutionIndependently(captureParameters, substitution2));
                }
                result = substList;
            }
        }
        return result;
    }

    private @SignatureUnknown Substitution selectSubstitutionIndependently(@SignatureUnknown List<@SignatureUnknown TypeVariable> parameters, @SignatureUnknown Substitution substitution) {
        ArrayList<ReferenceType> selectedTypes = new ArrayList<ReferenceType>();
        for (TypeVariable typeArgument : parameters) {
            List<ReferenceType> candidates = this.candidateTypes(typeArgument);
            if (candidates.isEmpty()) {
                Log.logPrintf("TypeInstantiator.selectSubstitutionIndependently: No candidate types for %s%n", typeArgument);
                return null;
            }
            selectedTypes.add(Randomness.randomMember(candidates));
        }
        return substitution.extend(parameters, selectedTypes);
    }

    private @SignatureUnknown List<@SignatureUnknown Substitution> allSubstitutions(@SignatureUnknown List<@SignatureUnknown TypeVariable> parameters, @SignatureUnknown Substitution initialSubstitution, @SignatureUnknown BoundsCheck boundsCheck) {
        ArrayList<Substitution> substitutionList = new ArrayList<Substitution>();
        List<List<ReferenceType>> candidateTypes = this.candidateTypes(parameters);
        for (List list : CollectionsPlume.iteratorToIterable(new CombinationIterator<ReferenceType>(candidateTypes))) {
            Substitution substitution;
            if (!boundsCheck.test(list, substitution = initialSubstitution.extend(parameters, list))) continue;
            substitutionList.add(substitution);
        }
        return substitutionList;
    }

    private @SignatureUnknown List<@SignatureUnknown List<@SignatureUnknown ReferenceType>> candidateTypes(@SignatureUnknown List<@SignatureUnknown TypeVariable> parameters) {
        ArrayList<List<ReferenceType>> candidateTypes = new ArrayList<List<ReferenceType>>();
        for (TypeVariable typeArgument : parameters) {
            List<ReferenceType> candidates = this.candidateTypes(typeArgument);
            if (candidates.isEmpty()) {
                Log.logPrintf("No candidate types for %s%n", typeArgument);
                return Collections.emptyList();
            }
            candidateTypes.add(candidates);
        }
        return candidateTypes;
    }

    private @SignatureUnknown List<@SignatureUnknown ReferenceType> candidateTypes(@SignatureUnknown TypeVariable argument) {
        ParameterBound lowerBound = this.getLowerBound(argument);
        ParameterBound upperBound = this.getUpperBound(argument);
        ArrayList<ReferenceType> typeList = new ArrayList<ReferenceType>();
        for (Type inputType : this.inputTypes) {
            Substitution substitution;
            ReferenceType inputRefType;
            if (!inputType.isReferenceType() || !lowerBound.isLowerBound(inputRefType = (ReferenceType)inputType, substitution = new Substitution(argument, inputRefType)) || !upperBound.isUpperBound(inputRefType, substitution)) continue;
            typeList.add(inputRefType);
        }
        return typeList;
    }

    private @SignatureUnknown ParameterBound getUpperBound(@SignatureUnknown TypeVariable argument) {
        ParameterBound upperBound = argument.getUpperTypeBound();
        List<TypeVariable> parameters = upperBound.getTypeParameters();
        if (parameters.isEmpty() || parameters.size() == 1 && parameters.contains(argument)) {
            return upperBound;
        }
        return ParameterBound.forType(JavaTypes.OBJECT_TYPE);
    }

    private @SignatureUnknown ParameterBound getLowerBound(@SignatureUnknown TypeVariable argument) {
        ParameterBound lowerBound = argument.getLowerTypeBound();
        List<TypeVariable> parameters = lowerBound.getTypeParameters();
        if (parameters.isEmpty() || parameters.size() == 1 && parameters.contains(argument)) {
            return lowerBound;
        }
        return ParameterBound.forType(JavaTypes.NULL_TYPE);
    }
}

