/*
 * Decompiled with CFR 0.152.
 */
package randoop.reflection;

import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import randoop.TestValue;
import randoop.generation.SeedSequences;
import randoop.main.GenInputsAbstract;
import randoop.reflection.DefaultClassVisitor;
import randoop.sequence.Sequence;

public class TestValueExtractor
extends DefaultClassVisitor {
    private final @SignatureUnknown Set<@SignatureUnknown Sequence> valueSequences;

    public TestValueExtractor(@SignatureUnknown Set<@SignatureUnknown Sequence> valueSequences) {
        this.valueSequences = valueSequences;
    }

    @Override
    public void visit(@SignatureUnknown Field f) {
        if (f.getAnnotation(TestValue.class) != null) {
            if (!Modifier.isStatic(f.getModifiers())) {
                String msg = "RANDOOP ANNOTATION ERROR: Expected @TestValue-annotated field " + f.getName() + " in class " + f.getDeclaringClass() + " to be declared static but it was not.";
                throw new RuntimeException(msg);
            }
            this.valueSequences.addAll(SeedSequences.objectsToSeeds(this.getValue(f)));
        }
    }

    private @SignatureUnknown List<@SignatureUnknown Object> getValue(@SignatureUnknown Field f) {
        ArrayList<Object> valueList = new ArrayList<Object>();
        Class<?> fieldType = f.getType();
        if (fieldType.isPrimitive() || fieldType.equals(String.class) || fieldType.isArray() && (fieldType.getComponentType().isPrimitive() || fieldType.getComponentType().equals(String.class))) {
            Object value;
            if (GenInputsAbstract.progressdisplay) {
                TestValueExtractor.printDetectedAnnotatedFieldMsg(f);
            }
            f.setAccessible(true);
            try {
                value = f.get(null);
            }
            catch (IllegalAccessException e) {
                String msg = "RANDOOP ANNOTATION ERROR: IllegalAccessException when processing @TestValue-annotated field " + f.getName() + " in class " + f.getDeclaringClass() + ". (Is the class declaring this field publicly-visible?)";
                throw new RuntimeException(msg);
            }
            if (!fieldType.isArray()) {
                valueList.add(value);
            } else {
                int length = Array.getLength(value);
                for (int i = 0; i < length; ++i) {
                    valueList.add(Array.get(value, i));
                }
            }
        } else {
            String msg = "RANDOOP ANNOTATION ERROR: Expected @TestValue-annotated field " + f.getName() + " in class " + f.getDeclaringClass() + " to declare a primitive type, String, or an array of primitives of Strings, but the field's type is " + f.getType() + ".";
            throw new RuntimeException(msg);
        }
        return valueList;
    }

    private static void printDetectedAnnotatedFieldMsg(@SignatureUnknown Field f) {
        String msg = "ANNOTATION: Detected @TestValue-annotated field " + f.getType().getCanonicalName() + " \"" + f.getName() + "\" in class " + f.getDeclaringClass().getCanonicalName() + ". Will collect its primitive values to use in generation.";
        System.out.println(msg);
    }
}

