/*
 * Decompiled with CFR 0.152.
 */
package randoop.reflection;

import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import randoop.reflection.FailedPredicateException;
import randoop.reflection.ReflectionPredicate;
import randoop.reflection.SignatureParseException;
import randoop.reflection.VisibilityPredicate;
import randoop.types.Type;

public class SignatureParser {
    public static final @SignatureUnknown String ID_STRING = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    public static final @SignatureUnknown String DOT_DELIMITED_IDS = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*(?:\\.<init>)?";
    private static final @SignatureUnknown Pattern SIGNATURE_PATTERN = Pattern.compile("(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*(?:\\.<init>)?)\\(([^)]*)\\)");

    public static @SignatureUnknown AccessibleObject parse(@SignatureUnknown String signature, @SignatureUnknown VisibilityPredicate visibility, @SignatureUnknown ReflectionPredicate reflectionPredicate) throws @SignatureUnknown SignatureParseException, @SignatureUnknown FailedPredicateException {
        Method method;
        Class<?> clazz;
        Matcher signatureMatcher = SIGNATURE_PATTERN.matcher(signature);
        if (!signatureMatcher.matches()) {
            throw new IllegalArgumentException("Method signature expected: " + signature);
        }
        String qualifiedName = signatureMatcher.group(1);
        String argString = signatureMatcher.group(2);
        String[] arguments = argString.isEmpty() ? new String[]{} : argString.split("\\s*,\\s*");
        int dotPos = qualifiedName.lastIndexOf(46);
        if (dotPos <= 0) {
            throw new SignatureParseException("Expected fully-qualified name but got \"" + qualifiedName + "\" in signature " + signature);
        }
        String name = qualifiedName.substring(dotPos + 1);
        String qualifiedClassname = qualifiedName.substring(0, dotPos);
        boolean isConstructor = name.equals("<init>");
        try {
            clazz = Type.forFullyQualifiedName(qualifiedClassname);
        }
        catch (ClassNotFoundException first) {
            try {
                clazz = Type.forFullyQualifiedName(qualifiedName);
                isConstructor = true;
            }
            catch (ClassNotFoundException e) {
                throw new SignatureParseException("Class not found for method or constructor " + qualifiedName + " in signature " + signature, e);
            }
        }
        if (!visibility.isVisible(clazz)) {
            throw new FailedPredicateException("Ignoring signature " + signature + " from non-visible " + clazz);
        }
        Class[] argTypes = new Class[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            try {
                argTypes[i] = Type.forFullyQualifiedName(arguments[i]);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new SignatureParseException("Argument type \"" + arguments[i] + "\" not recognized in signature " + signature, e);
            }
        }
        if (isConstructor) {
            Constructor<?> constructor;
            try {
                constructor = clazz.getDeclaredConstructor(argTypes);
            }
            catch (NoSuchMethodException e) {
                throw new SignatureParseException("Class " + clazz + " found, but constructor not found for signature " + signature, e);
            }
            if (!visibility.isVisible(constructor)) {
                throw new FailedPredicateException("Non-visible constructor " + signature);
            }
            if (!reflectionPredicate.test(constructor)) {
                throw new FailedPredicateException("Constructor fails reflection predicate: " + signature);
            }
            return constructor;
        }
        try {
            method = clazz.getDeclaredMethod(name, argTypes);
        }
        catch (NoSuchMethodException e) {
            StringBuilder b = new StringBuilder();
            String argTypesString = Arrays.stream(argTypes).map(Class::toString).collect(Collectors.joining(", "));
            b.append(String.format("Class %s found, but method %s(%s) not found for signature %s%n", clazz, name, argTypesString, signature));
            b.append(String.format("Here are the declared methods:%n", new Object[0]));
            for (Method m3 : clazz.getDeclaredMethods()) {
                b.append(String.format("  %s%n", m3));
            }
            throw new SignatureParseException(b.toString(), e);
        }
        if (!visibility.isVisible(method)) {
            throw new FailedPredicateException("Ignoring non-visible method " + signature);
        }
        if (!reflectionPredicate.test(method)) {
            throw new FailedPredicateException("Method fails reflection predicate: " + signature);
        }
        return method;
    }
}

