/*
 * Decompiled with CFR 0.152.
 */
package randoop.reflection;

import coveredclass.org.checkerframework.checker.nullness.qual.Nullable;
import coveredclass.org.checkerframework.checker.signature.qual.ClassGetName;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureBottom;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.plumelib.util.EntryReader;
import org.plumelib.util.UtilPlume;
import randoop.Globals;
import randoop.condition.SpecificationCollection;
import randoop.contract.CompareToAntiSymmetric;
import randoop.contract.CompareToEquals;
import randoop.contract.CompareToReflexive;
import randoop.contract.CompareToSubs;
import randoop.contract.CompareToTransitive;
import randoop.contract.EqualsHashcode;
import randoop.contract.EqualsReflexive;
import randoop.contract.EqualsReturnsNormally;
import randoop.contract.EqualsSymmetric;
import randoop.contract.EqualsToNullRetFalse;
import randoop.contract.EqualsTransitive;
import randoop.contract.SizeToArrayLength;
import randoop.generation.ComponentManager;
import randoop.main.ClassNameErrorHandler;
import randoop.main.GenInputsAbstract;
import randoop.main.RandoopBug;
import randoop.main.RandoopClassNameError;
import randoop.main.RandoopUsageError;
import randoop.operation.OperationParseException;
import randoop.operation.TypedClassOperation;
import randoop.operation.TypedOperation;
import randoop.reflection.CheckRepExtractor;
import randoop.reflection.ClassLiteralExtractor;
import randoop.reflection.DeclarationExtractor;
import randoop.reflection.EverythingAllowedPredicate;
import randoop.reflection.FailedPredicateException;
import randoop.reflection.LiteralFileReader;
import randoop.reflection.OmitMethodsPredicate;
import randoop.reflection.OperationExtractor;
import randoop.reflection.ReflectionManager;
import randoop.reflection.ReflectionPredicate;
import randoop.reflection.SignatureParseException;
import randoop.reflection.SignatureParser;
import randoop.reflection.TestValueExtractor;
import randoop.reflection.TypeExtractor;
import randoop.reflection.TypeNames;
import randoop.reflection.VisibilityPredicate;
import randoop.sequence.Sequence;
import randoop.test.ContractSet;
import randoop.types.ClassOrInterfaceType;
import randoop.types.Type;
import randoop.util.Log;
import randoop.util.MultiMap;

public class OperationModel {
    private @SignatureUnknown Set<@SignatureUnknown ClassOrInterfaceType> classTypes = new TreeSet<ClassOrInterfaceType>();
    private @SignatureUnknown Set<@SignatureUnknown Type> inputTypes = new TreeSet<Type>();
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown LinkedHashSet<@SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?>> coveredClassesGoal;
    private @SignatureUnknown MultiMap<@SignatureUnknown ClassOrInterfaceType, @SignatureUnknown Sequence> classLiteralMap = new MultiMap();
    private @SignatureUnknown Set<@SignatureUnknown Sequence> annotatedTestValues = new LinkedHashSet<Sequence>();
    private @SignatureUnknown ContractSet contracts = new ContractSet();
    private final @SignatureUnknown Set<@SignatureUnknown TypedOperation> operations;
    private @SignatureUnknown List<@SignatureUnknown Pattern> omitMethods;
    private @SignatureUnknown OmitMethodsPredicate omitMethodsPredicate;

    private OperationModel() {
        this.contracts.add(EqualsReflexive.getInstance());
        this.contracts.add(EqualsSymmetric.getInstance());
        this.contracts.add(EqualsHashcode.getInstance());
        this.contracts.add(EqualsToNullRetFalse.getInstance());
        this.contracts.add(EqualsReturnsNormally.getInstance());
        this.contracts.add(EqualsTransitive.getInstance());
        this.contracts.add(CompareToReflexive.getInstance());
        this.contracts.add(CompareToAntiSymmetric.getInstance());
        this.contracts.add(CompareToEquals.getInstance());
        this.contracts.add(CompareToSubs.getInstance());
        this.contracts.add(CompareToTransitive.getInstance());
        this.contracts.add(SizeToArrayLength.getInstance());
        this.coveredClassesGoal = new LinkedHashSet();
        this.operations = new TreeSet<TypedOperation>();
    }

    public static @SignatureUnknown OperationModel createModel(@SignatureUnknown VisibilityPredicate visibility, @SignatureUnknown ReflectionPredicate reflectionPredicate, @SignatureUnknown List<@SignatureUnknown Pattern> omitMethods, @SignatureUnknown Set<@ClassGetName String> classnames, @SignatureUnknown Set<@ClassGetName String> coveredClassesGoalNames, @SignatureUnknown ClassNameErrorHandler errorHandler, @SignatureUnknown List<@SignatureUnknown String> literalsFileList, @SignatureUnknown SpecificationCollection operationSpecifications) throws @SignatureUnknown SignatureParseException, @SignatureUnknown NoSuchMethodException {
        OperationModel model = new OperationModel();
        model.omitMethods = omitMethods;
        model.addClassTypes(visibility, reflectionPredicate, classnames, coveredClassesGoalNames, errorHandler, literalsFileList);
        model.omitMethodsPredicate = new OmitMethodsPredicate(omitMethods);
        model.addOperationsFromClasses(visibility, reflectionPredicate, operationSpecifications);
        model.addOperationsUsingSignatures(GenInputsAbstract.methodlist, visibility, reflectionPredicate);
        model.addObjectConstructor();
        return model;
    }

    static @SignatureUnknown OperationModel createModel(@SignatureUnknown VisibilityPredicate visibility, @SignatureUnknown ReflectionPredicate reflectionPredicate, @SignatureUnknown Set<@ClassGetName String> classnames, @SignatureUnknown Set<@ClassGetName String> coveredClassnames, @SignatureUnknown ClassNameErrorHandler errorHandler, @SignatureUnknown List<@SignatureUnknown String> literalsFileList) throws @SignatureUnknown NoSuchMethodException, @SignatureUnknown SignatureParseException {
        return OperationModel.createModel(visibility, reflectionPredicate, new ArrayList<Pattern>(), classnames, coveredClassnames, errorHandler, literalsFileList, null);
    }

    public static @SignatureUnknown OperationModel createModel(@SignatureUnknown VisibilityPredicate visibility, @SignatureUnknown ReflectionPredicate reflectionPredicate, @SignatureUnknown List<@SignatureUnknown Pattern> omitMethods, @SignatureUnknown Set<@ClassGetName String> classnames, @SignatureUnknown Set<@ClassGetName String> coveredClassnames, @SignatureUnknown ClassNameErrorHandler errorHandler, @SignatureUnknown List<@SignatureUnknown String> literalsFileList) throws @SignatureUnknown NoSuchMethodException, @SignatureUnknown SignatureParseException {
        return OperationModel.createModel(visibility, reflectionPredicate, omitMethods, classnames, coveredClassnames, errorHandler, literalsFileList, null);
    }

    public void addClassLiterals(@SignatureUnknown ComponentManager compMgr, @SignatureUnknown List<@SignatureUnknown String> literalsFile, @SignatureUnknown GenInputsAbstract.ClassLiteralsMode literalsLevel) {
        for (String filename : literalsFile) {
            MultiMap<ClassOrInterfaceType, Sequence> literalmap = filename.equals("CLASSES") ? this.classLiteralMap : LiteralFileReader.parse(filename);
            for (ClassOrInterfaceType type : literalmap.keySet()) {
                Package pkg = literalsLevel == GenInputsAbstract.ClassLiteralsMode.PACKAGE ? type.getPackage() : null;
                block7: for (Sequence seq : literalmap.getValues(type)) {
                    switch (literalsLevel) {
                        case CLASS: {
                            compMgr.addClassLevelLiteral(type, seq);
                            continue block7;
                        }
                        case PACKAGE: {
                            assert (pkg != null);
                            compMgr.addPackageLevelLiteral(pkg, seq);
                            continue block7;
                        }
                        case ALL: {
                            compMgr.addGeneratedSequence(seq);
                            continue block7;
                        }
                    }
                    throw new Error("Unexpected error in GenTests.  Please report at https://github.com/randoop/randoop/issues , providing the information requested at https://randoop.github.io/randoop/manual/index.html#bug-reporting .");
                }
            }
        }
    }

    public static @SignatureUnknown MultiMap<@SignatureUnknown Type, @SignatureUnknown TypedClassOperation> readOperations(@Nullable @SignatureUnknown Path file) throws @SignatureUnknown OperationParseException {
        return OperationModel.readOperations(file, false);
    }

    public static @SignatureUnknown MultiMap<@SignatureUnknown Type, @SignatureUnknown TypedClassOperation> readOperations(@Nullable @SignatureUnknown Path file, @SignatureUnknown boolean ignoreParseError) throws @SignatureUnknown OperationParseException {
        if (file != null) {
            MultiMap<Type, TypedClassOperation> multiMap;
            EntryReader er = new EntryReader(file, "(//|#).*$", null);
            try {
                multiMap = OperationModel.readOperations(er, ignoreParseError);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        er.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    String message = String.format("Error while reading file %s: %s%n", file, e.getMessage());
                    throw new RandoopUsageError(message, e);
                }
            }
            er.close();
            return multiMap;
        }
        return new MultiMap<Type, TypedClassOperation>();
    }

    private static @SignatureUnknown MultiMap<@SignatureUnknown Type, @SignatureUnknown TypedClassOperation> readOperations(@SignatureUnknown EntryReader er, @SignatureUnknown boolean ignoreParseError) {
        MultiMap<Type, TypedClassOperation> operationsMap = new MultiMap<Type, TypedClassOperation>();
        for (String line : er) {
            TypedClassOperation operation;
            String sig = line.trim();
            try {
                operation = OperationModel.signatureToOperation(sig, VisibilityPredicate.IS_ANY, new EverythingAllowedPredicate());
            }
            catch (SignatureParseException e) {
                if (ignoreParseError) continue;
                throw new RandoopUsageError(String.format("%s:%d: %s", er.getFileName(), er.getLineNumber(), e));
            }
            catch (FailedPredicateException e) {
                throw new RandoopBug("This can't happen", e);
            }
            if (operation.getInputTypes().size() <= 0) continue;
            operationsMap.add(operation.getInputTypes().get(0), operation);
        }
        return operationsMap;
    }

    public static @SignatureUnknown MultiMap<@SignatureUnknown Type, @SignatureUnknown TypedClassOperation> readOperations(@SignatureUnknown InputStream is, @SignatureUnknown String filename) {
        return OperationModel.readOperations(is, filename, false);
    }

    public static @SignatureUnknown MultiMap<@SignatureUnknown Type, @SignatureUnknown TypedClassOperation> readOperations(@SignatureUnknown InputStream is, @SignatureUnknown String filename, @SignatureUnknown boolean ignoreParseError) {
        MultiMap<Type, TypedClassOperation> multiMap;
        if (is == null) {
            throw new RandoopBug("input stream is null for file " + filename);
        }
        EntryReader er = new EntryReader(is, filename, "^#.*", null);
        try {
            multiMap = OperationModel.readOperations(er, ignoreParseError);
        }
        catch (Throwable throwable) {
            try {
                try {
                    er.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                String message = String.format("Error while reading file %s: %s%n", filename, e.getMessage());
                throw new RandoopUsageError(message, e);
            }
        }
        er.close();
        return multiMap;
    }

    public @SignatureUnknown Set<@SignatureUnknown ClassOrInterfaceType> getClassTypes() {
        return this.classTypes;
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Set<@SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?>> getCoveredClassesGoal() {
        return this.coveredClassesGoal;
    }

    public @SignatureUnknown Set<@SignatureUnknown Type> getInputTypes() {
        return this.inputTypes;
    }

    public @SignatureUnknown List<@SignatureUnknown TypedOperation> getOperations() {
        return new ArrayList<TypedOperation>(this.operations);
    }

    public @SignatureUnknown ContractSet getContracts() {
        return this.contracts;
    }

    public @SignatureUnknown OmitMethodsPredicate getOmitMethodsPredicate() {
        return this.omitMethodsPredicate;
    }

    public @SignatureUnknown Set<@SignatureUnknown Sequence> getAnnotatedTestValues() {
        return this.annotatedTestValues;
    }

    public void log() {
        if (Log.isLoggingOn()) {
            this.logOperations(GenInputsAbstract.log);
        }
    }

    public void logOperations(@SignatureUnknown PrintStream out) {
        this.logOperations(new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8))));
    }

    public void logOperations(@SignatureUnknown Writer out) {
        try {
            out.write("Operations: (" + this.operations.size() + ")" + Globals.lineSep);
            for (TypedOperation t : this.operations) {
                out.write("  " + t.toString());
                out.write(Globals.lineSep);
                out.flush();
            }
        }
        catch (IOException e) {
            throw new RandoopBug("Error while logging operations", e);
        }
    }

    public void dumpModel() {
        if (Log.isLoggingOn()) {
            this.dumpModel(GenInputsAbstract.log);
        }
    }

    public void dumpModel(@SignatureUnknown PrintStream out) {
        this.dumpModel(new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8))));
    }

    public void dumpModel(@SignatureUnknown Writer out) {
        try {
            out.write(String.format("Model with hashcode %s:%n", this.hashCode()));
            out.write(String.format("  classTypes = %s%n", this.classTypes));
            out.write(String.format("  inputTypes = %s%n", this.inputTypes));
            out.write(String.format("  coveredClassesGoal = %s%n", this.coveredClassesGoal));
            out.write(String.format("  classLiteralMap = %s%n", this.classLiteralMap));
            out.write(String.format("  annotatedTestValues = %s%n", this.annotatedTestValues));
            out.write(String.format("  contracts = %s%n", this.contracts));
            out.write(String.format("  omitMethods = %s%n", this.omitMethods));
            this.logOperations(out);
        }
        catch (IOException ioe) {
            throw new Error(ioe);
        }
    }

    private void addClassTypes(@SignatureUnknown VisibilityPredicate visibility, @SignatureUnknown ReflectionPredicate reflectionPredicate, @SignatureUnknown Set<@ClassGetName String> classnames, @SignatureUnknown Set<@ClassGetName String> coveredClassesGoalNames, @SignatureUnknown ClassNameErrorHandler errorHandler, @SignatureUnknown List<@SignatureUnknown String> literalsFileList) {
        Class<?> c;
        ReflectionManager mgr = new ReflectionManager(visibility);
        mgr.add(new DeclarationExtractor(this.classTypes, reflectionPredicate));
        mgr.add(new TypeExtractor(this.inputTypes, visibility));
        mgr.add(new TestValueExtractor(this.annotatedTestValues));
        mgr.add(new CheckRepExtractor(this.contracts));
        if (literalsFileList.contains("CLASSES")) {
            mgr.add(new ClassLiteralExtractor(this.classLiteralMap));
        }
        int succeeded = 0;
        for (String classname : classnames) {
            try {
                c = OperationModel.getClass(classname, errorHandler);
            }
            catch (RandoopClassNameError e) {
                System.out.println();
                System.out.println(e.getMessage());
                System.out.println();
                continue;
            }
            if (c == null) continue;
            if (!visibility.isVisible(c)) {
                System.out.printf("Cannot instantiate non-visible %s specified via --testclass or --classlist.%n", c.getName());
                continue;
            }
            try {
                mgr.apply(c);
                ++succeeded;
            }
            catch (Throwable e) {
                System.out.printf("Cannot get methods for %s specified via --testclass or --classlist due to exception:%n%s%n", c.getName(), UtilPlume.stackTraceToString(e));
            }
        }
        if (GenInputsAbstract.progressdisplay) {
            if (succeeded == classnames.size()) {
                System.out.printf("%nWill try to generate tests for %d classes.%n", succeeded);
            } else {
                System.out.printf("%nWill try to generate tests for %d out of %d classes.%n", succeeded, classnames.size());
            }
        }
        for (String classname : coveredClassesGoalNames) {
            c = OperationModel.getClass(classname, errorHandler);
            if (c == null || c.isInterface()) continue;
            this.coveredClassesGoal.add(c);
        }
    }

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> getClass(@ClassGetName String classname, @SignatureUnknown ClassNameErrorHandler errorHandler) {
        try {
            return TypeNames.getTypeForName(classname);
        }
        catch (ClassNotFoundException e) {
            errorHandler.handle(classname, e);
        }
        catch (Throwable e) {
            if (e.getCause() != null) {
                e = e.getCause();
            }
            errorHandler.handle(classname, e);
        }
        return null;
    }

    private void addOperationsFromClasses(@SignatureUnknown VisibilityPredicate visibility, @SignatureUnknown ReflectionPredicate reflectionPredicate, @SignatureUnknown SpecificationCollection operationSpecifications) {
        Iterator<ClassOrInterfaceType> itor = this.classTypes.iterator();
        while (itor.hasNext()) {
            ClassOrInterfaceType classType = itor.next();
            try {
                List<TypedOperation> oneClassOperations = OperationExtractor.operations(classType, reflectionPredicate, this.omitMethodsPredicate, visibility, operationSpecifications);
                this.operations.addAll(oneClassOperations);
            }
            catch (Throwable e) {
                System.out.printf("Removing %s from the classes under test due to problem extracting operations:%n%s%n", classType, UtilPlume.stackTraceToString(e));
                itor.remove();
            }
        }
    }

    private void addOperationsUsingSignatures(@SignatureUnknown Path methodSignatures_file, @SignatureUnknown VisibilityPredicate visibility, @SignatureUnknown ReflectionPredicate reflectionPredicate) throws @SignatureUnknown SignatureParseException {
        if (methodSignatures_file == null) {
            return;
        }
        try (EntryReader reader = new EntryReader(methodSignatures_file, "(//|#).*$", null);){
            for (String line : reader) {
                String sig = line.trim();
                if (sig.isEmpty()) continue;
                try {
                    TypedClassOperation operation = OperationModel.signatureToOperation(sig, visibility, reflectionPredicate);
                    if (this.omitMethodsPredicate.shouldOmit(operation)) continue;
                    this.operations.add(operation);
                }
                catch (FailedPredicateException e) {
                    System.out.printf("Ignoring %s that failed predicate: %s%n", sig, e.getMessage());
                }
            }
        }
        catch (IOException e) {
            throw new RandoopUsageError("Problem reading file " + methodSignatures_file, e);
        }
    }

    public static @SignatureUnknown TypedClassOperation signatureToOperation(@SignatureUnknown String signature, @SignatureUnknown VisibilityPredicate visibility, @SignatureUnknown ReflectionPredicate reflectionPredicate) throws @SignatureUnknown SignatureParseException, @SignatureUnknown FailedPredicateException {
        AccessibleObject accessibleObject = SignatureParser.parse(signature, visibility, reflectionPredicate);
        if (accessibleObject == null) {
            throw new FailedPredicateException(String.format("accessibleObject is null for %s, typically due to predicates: %s, %s", signature, visibility, reflectionPredicate));
        }
        if (accessibleObject instanceof Constructor) {
            return TypedOperation.forConstructor((Constructor)accessibleObject);
        }
        return TypedOperation.forMethod((Method)accessibleObject);
    }

    private void addObjectConstructor() {
        Constructor objectConstructor;
        try {
            objectConstructor = Object.class.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RandoopBug("unable to load java.lang.Object() constructor", e);
        }
        TypedClassOperation operation = TypedOperation.forConstructor(objectConstructor);
        this.classTypes.add(operation.getDeclaringType());
        this.operations.add(operation);
    }
}

