/*
 * Decompiled with CFR 0.152.
 */
package randoop.reflection;

import coveredclass.org.checkerframework.checker.signature.qual.ClassGetName;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.util.ArrayList;
import java.util.List;
import randoop.Globals;
import randoop.operation.NonreceiverTerm;
import randoop.operation.OperationParseException;
import randoop.operation.TypedOperation;
import randoop.reflection.TypeNames;
import randoop.sequence.Sequence;
import randoop.sequence.Variable;
import randoop.types.ClassOrInterfaceType;
import randoop.util.MultiMap;
import randoop.util.RecordListReader;
import randoop.util.RecordProcessor;

public class LiteralFileReader {
    private LiteralFileReader() {
        throw new Error("Do not instantiate");
    }

    public static @SignatureUnknown MultiMap<@SignatureUnknown ClassOrInterfaceType, @SignatureUnknown Sequence> parse(@SignatureUnknown String inFile) {
        final MultiMap<ClassOrInterfaceType, Sequence> map = new MultiMap<ClassOrInterfaceType, Sequence>();
        RecordProcessor processor = new RecordProcessor(){

            @Override
            public void processRecord(@SignatureUnknown List<@SignatureUnknown String> lines) {
                if (lines.size() < 1 || !lines.get(0).trim().toUpperCase().equals("CLASSNAME")) {
                    LiteralFileReader.throwRecordSyntaxError("record does not begin with \"CLASSNAME\"", lines, 0);
                }
                if (lines.size() < 2) {
                    LiteralFileReader.throwRecordSyntaxError("class name missing", lines, 1);
                }
                Class<?> cls = null;
                try {
                    @ClassGetName String className = lines.get(1);
                    cls = TypeNames.getTypeForName(className);
                }
                catch (ClassNotFoundException e) {
                    LiteralFileReader.throwRecordSyntaxError(e);
                }
                assert (cls != null);
                ClassOrInterfaceType classType = ClassOrInterfaceType.forClass(cls);
                if (lines.size() < 3 || !lines.get(2).trim().toUpperCase().equals("LITERALS")) {
                    LiteralFileReader.throwRecordSyntaxError("Missing field \"LITERALS\"", lines, 2);
                }
                for (int i = 3; i < lines.size(); ++i) {
                    try {
                        TypedOperation operation = NonreceiverTerm.parse(lines.get(i));
                        map.add(classType, new Sequence().extend(operation, new ArrayList<Variable>()));
                        continue;
                    }
                    catch (OperationParseException e) {
                        LiteralFileReader.throwRecordSyntaxError(e);
                    }
                }
            }
        };
        RecordListReader reader = new RecordListReader("CLASSLITERALS", processor);
        reader.parse(inFile);
        return map;
    }

    private static void throwRecordSyntaxError(@SignatureUnknown Exception e) {
        throw new Error(e);
    }

    private static void throwRecordSyntaxError(@SignatureUnknown String string, @SignatureUnknown List<@SignatureUnknown String> lines, @SignatureUnknown int i) {
        StringBuilder b = new StringBuilder();
        b.append("RECORD PROCESSING ERROR: ").append(string).append(Globals.lineSep);
        LiteralFileReader.appendRecord(b, lines, i);
        throw new Error(b.toString());
    }

    private static void appendRecord(@SignatureUnknown StringBuilder b, @SignatureUnknown List<@SignatureUnknown String> lines, @SignatureUnknown int i) {
        b.append("INVALID RECORD (error is at index ").append(i).append("):").append(Globals.lineSep);
        b.append("------------------------------").append(Globals.lineSep);
        for (String l : lines) {
            b.append("   ").append(l).append(Globals.lineSep);
        }
        b.append("------------------------------").append(Globals.lineSep);
    }
}

