/*
 * Decompiled with CFR 0.152.
 */
package randoop.reflection;

import coveredclass.org.checkerframework.checker.signature.qual.SignatureBottom;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import randoop.CheckRep;
import randoop.reflection.ReflectionPredicate;
import randoop.util.Log;

public class DefaultReflectionPredicate
implements ReflectionPredicate {
    private @SignatureUnknown Collection<@SignatureUnknown String> omitFields;

    public DefaultReflectionPredicate() {
        this(null);
    }

    public DefaultReflectionPredicate(@SignatureUnknown Collection<@SignatureUnknown String> omitFields) {
        this.omitFields = omitFields;
    }

    @Override
    public @SignatureUnknown boolean test(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> c) {
        return !c.isAnonymousClass();
    }

    @Override
    public @SignatureUnknown boolean test(@SignatureUnknown Method m3) {
        if (this.isRandoopInstrumentation(m3)) {
            return false;
        }
        Class<?>[] paramTypes = m3.getParameterTypes();
        if (m3.getName().equals("main") && paramTypes.length == 1 && paramTypes[0].isArray() && paramTypes[0].getComponentType().equals(String.class)) {
            Log.logPrintf("Will not use main method: %s%n", m3);
            return false;
        }
        if (m3.isBridge()) {
            if (this.discardBridge(m3)) {
                return false;
            }
            Log.logPrintf("Using visibility bridge method: %s%n", m3);
        }
        if (!m3.isBridge() && m3.isSynthetic()) {
            Log.logPrintf("Will not use synthetic method: %s%n", m3);
            return false;
        }
        if (m3.getDeclaringClass().equals(Object.class)) {
            return m3.getName().equals("getClass");
        }
        if (m3.getDeclaringClass().equals(Thread.class)) {
            return false;
        }
        if (m3.getAnnotation(CheckRep.class) != null) {
            return false;
        }
        String reason = this.doNotUseSpecialCase(m3);
        if (reason != null) {
            Log.logPrintf("Will not use: %s%n  reason: %s%n", m3, reason);
            return false;
        }
        return true;
    }

    private @SignatureUnknown boolean isRandoopInstrumentation(@SignatureUnknown Method m3) {
        return m3.getName().contains("randoop_");
    }

    private @SignatureUnknown boolean discardBridge(@SignatureUnknown Method m3) {
        if (!this.isVisibilityBridge(m3)) {
            Log.logPrintf("Will not use bridge method: %s%n", m3);
            return true;
        }
        return m3.getDeclaringClass().isAnonymousClass() && m3.getDeclaringClass().getEnclosingClass() != null && m3.getDeclaringClass().getEnclosingClass().isEnum();
    }

    private @SignatureUnknown boolean isVisibilityBridge(@SignatureUnknown Method m3) throws @SignatureUnknown Error {
        Class<?> c = m3.getDeclaringClass();
        if (!this.isPublic(c)) {
            return false;
        }
        for (c = c.getSuperclass(); c != null; c = c.getSuperclass()) {
            if (this.isPublic(c) || !this.definesNonBridgeMethod(c, m3)) continue;
            return true;
        }
        return false;
    }

    private @SignatureUnknown boolean definesNonBridgeMethod(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> c, @SignatureUnknown Method goalMethod) {
        try {
            Method defined = c.getDeclaredMethod(goalMethod.getName(), goalMethod.getParameterTypes());
            return !defined.isBridge();
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (SecurityException e) {
            String msg = "Cannot access method " + goalMethod.getName() + " in class " + c.getCanonicalName();
            throw new Error(msg);
        }
    }

    private @SignatureUnknown boolean isPublic(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> c) {
        return Modifier.isPublic(c.getModifiers() & Modifier.classModifiers());
    }

    private @SignatureUnknown String doNotUseSpecialCase(@SignatureUnknown Method m3) {
        String mName = m3.getName().intern();
        Class<?> mClass = m3.getDeclaringClass();
        if (!mClass.isAnonymousClass() && mClass.getCanonicalName().equals("java.lang.Enum") && mName == "compareTo" && m3.getParameterTypes().length == 1 && m3.getParameterTypes()[0].equals(Enum.class)) {
            return "Enum compareTo method has restrictions on argument types";
        }
        if (mName == "randomUUID") {
            return "randomUUID() is nondeterministic";
        }
        if (mName == "hashCode" && !mClass.equals(String.class)) {
            return "hashCode may be nondeterministic";
        }
        if (mName == "deepHashCode" && mClass.equals(Arrays.class)) {
            return "deepHashCode is nondeterministic because hashCode() is";
        }
        if (mName == "getAvailableLocales") {
            return "getAvailableLocales differs too much between JDK installations";
        }
        if (mName == "fillInStackTrace" || mName == "getCause" || mName == "getLocalizedMessage" || mName == "getMessage" || mName == "getStackTrace" || mName == "initCause" || mName == "printStackTrace" || mName == "setStackTrace") {
            return "Randoop avoids exploring Exception class methods, to avoid nontermination.";
        }
        return null;
    }

    @Override
    public @SignatureUnknown boolean test(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Constructor<@SignatureUnknown @SignatureBottom ?> c) {
        if (c.isSynthetic()) {
            for (Class<?> p : c.getParameterTypes()) {
                if (!p.isAnonymousClass()) continue;
                return false;
            }
        }
        return !Modifier.isAbstract(c.getDeclaringClass().getModifiers());
    }

    @Override
    public @SignatureUnknown boolean test(@SignatureUnknown Field f) {
        boolean result;
        if (this.isRandoopInstrumentation(f)) {
            return false;
        }
        String name = f.getDeclaringClass().getName() + "." + f.getName();
        if (this.omitFields == null) {
            Log.logPrintf("Field '%s' included, no omit-field arguments%n", name);
            return true;
        }
        boolean bl = result = !this.omitFields.contains(name);
        if (result) {
            Log.logPrintf("Field '%s' does not match omit-field, including field%n", name);
        } else {
            Log.logPrintf("Field '%s' matches omit-field, not including field%n", name);
        }
        return result;
    }

    private @SignatureUnknown boolean isRandoopInstrumentation(@SignatureUnknown Field f) {
        return f.getName().contains("randoop_");
    }
}

