/*
 * Decompiled with CFR 0.152.
 */
package randoop.reflection;

import coveredclass.org.checkerframework.checker.signature.qual.SignatureBottom;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.util.LinkedHashSet;
import java.util.Set;
import randoop.reflection.DefaultClassVisitor;
import randoop.reflection.ReflectionManager;
import randoop.reflection.ReflectionPredicate;
import randoop.reflection.VisibilityPredicate;
import randoop.types.ClassOrInterfaceType;

public class DeclarationExtractor
extends DefaultClassVisitor {
    private final @SignatureUnknown Set<@SignatureUnknown ClassOrInterfaceType> classDeclarationTypes;
    private @SignatureUnknown ReflectionPredicate reflectionPredicate;

    public DeclarationExtractor(@SignatureUnknown Set<@SignatureUnknown ClassOrInterfaceType> classDeclarationTypes, @SignatureUnknown ReflectionPredicate reflectionPredicate) {
        this.classDeclarationTypes = classDeclarationTypes;
        this.reflectionPredicate = reflectionPredicate;
    }

    @Override
    public void visit(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> c, @SignatureUnknown ReflectionManager reflectionManager) {
        if (!this.reflectionPredicate.test(c)) {
            return;
        }
        this.classDeclarationTypes.add(ClassOrInterfaceType.forClass(c));
        reflectionManager.apply(this, c);
    }

    @Override
    public void visitBefore(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> c) {
        if (!this.reflectionPredicate.test(c)) {
            return;
        }
        this.classDeclarationTypes.add(ClassOrInterfaceType.forClass(c));
    }

    public static @SignatureUnknown Set<@SignatureUnknown ClassOrInterfaceType> classTypes(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> c, @SignatureUnknown ReflectionPredicate reflectionPredicate, @SignatureUnknown VisibilityPredicate visibilityPredicate) {
        ReflectionManager typeManager = new ReflectionManager(visibilityPredicate);
        LinkedHashSet<ClassOrInterfaceType> result = new LinkedHashSet<ClassOrInterfaceType>();
        typeManager.apply(new DeclarationExtractor(result, reflectionPredicate), c);
        return result;
    }
}

