/*
 * Decompiled with CFR 0.152.
 */
package randoop.reflection;

import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import randoop.CheckRep;
import randoop.contract.CheckRepContract;
import randoop.main.GenInputsAbstract;
import randoop.reflection.DefaultClassVisitor;
import randoop.test.ContractSet;

class CheckRepExtractor
extends DefaultClassVisitor {
    private @SignatureUnknown ContractSet contracts;

    CheckRepExtractor(@SignatureUnknown ContractSet contracts) {
        this.contracts = contracts;
    }

    @Override
    public void visit(@SignatureUnknown Method m3) {
        if (m3.getAnnotation(CheckRep.class) != null) {
            if (Modifier.isStatic(m3.getModifiers())) {
                String msg = "RANDOOP ANNOTATION ERROR: Expected @CheckRep-annotated method " + m3.getName() + " in class " + m3.getDeclaringClass() + " to be an instance method, but it is declared static.";
                throw new RuntimeException(msg);
            }
            if (m3.getParameterTypes().length > 0) {
                String msg = "RANDOOP ANNOTATION ERROR: Expected @CheckRep-annotated method " + m3.getName() + " in class " + m3.getDeclaringClass() + " to declare no parameters but it does (method signature:" + m3.toString() + ").";
                throw new RuntimeException(msg);
            }
            if (!m3.getReturnType().equals(Boolean.TYPE) && !m3.getReturnType().equals(Void.TYPE)) {
                String msg = "RANDOOP ANNOTATION ERROR: Expected @CheckRep-annotated method " + m3.getName() + " in class " + m3.getDeclaringClass() + " to have void or boolean return type but it does not (method signature:" + m3.toString() + ").";
                throw new RuntimeException(msg);
            }
            if (GenInputsAbstract.progressdisplay) {
                CheckRepExtractor.printDetectedAnnotatedCheckRepMethod(m3);
            }
            this.contracts.add(new CheckRepContract(m3));
        }
    }

    private static void printDetectedAnnotatedCheckRepMethod(@SignatureUnknown Method m3) {
        String msg = "ANNOTATION: Detected @CheckRep-annotated method \"" + m3.toString() + "\". Will use it to check rep invariant of class " + m3.getDeclaringClass().getCanonicalName() + " during generation.";
        System.out.println(msg);
    }
}

