/*
 * Decompiled with CFR 0.152.
 */
package randoop.operation;

import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureBottom;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.plumelib.util.UtilPlume;
import randoop.ExecutionOutcome;
import randoop.condition.ExecutableSpecification;
import randoop.condition.ExpectedOutcomeTable;
import randoop.field.AccessibleField;
import randoop.operation.ArrayCreation;
import randoop.operation.ArrayElementSet;
import randoop.operation.CallableOperation;
import randoop.operation.ConstructorCall;
import randoop.operation.FieldGet;
import randoop.operation.FieldSet;
import randoop.operation.InitializedArrayCreation;
import randoop.operation.MethodCall;
import randoop.operation.NonreceiverTerm;
import randoop.operation.Operation;
import randoop.operation.TypedClassOperation;
import randoop.operation.TypedClassOperationWithCast;
import randoop.operation.TypedTermOperation;
import randoop.operation.UncheckedCast;
import randoop.reflection.ReflectionPredicate;
import randoop.sequence.Variable;
import randoop.types.ArrayType;
import randoop.types.ClassOrInterfaceType;
import randoop.types.GenericClassType;
import randoop.types.InstantiatedType;
import randoop.types.JavaTypes;
import randoop.types.Substitution;
import randoop.types.TypeTuple;
import randoop.types.TypeVariable;

public abstract class TypedOperation
implements Operation,
Comparable<TypedOperation> {
    private final @SignatureUnknown CallableOperation operation;
    protected final @SignatureUnknown TypeTuple inputTypes;
    private final @SignatureUnknown randoop.types.Type outputType;
    private @SignatureUnknown ExecutableSpecification execSpec;
    public static final @SignatureUnknown Comparator<@SignatureUnknown RankedTypeOperation> compareRankedTypeOperation = (t, t1) -> {
        int rankingComparison = Double.valueOf(t.ranking).compareTo(t1.ranking);
        if (rankingComparison != 0) {
            return rankingComparison;
        }
        return t.operation.getName().compareTo(t1.operation.getName());
    };

    TypedOperation(@SignatureUnknown CallableOperation operation, @SignatureUnknown TypeTuple inputTypes, @SignatureUnknown randoop.types.Type outputType) {
        this.operation = operation;
        this.inputTypes = inputTypes;
        this.outputType = outputType;
        this.execSpec = null;
    }

    public void setExecutableSpecification(@SignatureUnknown ExecutableSpecification execSpec) {
        this.execSpec = execSpec;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TypedOperation)) {
            return false;
        }
        TypedOperation op = (TypedOperation)obj;
        return this.getOperation().equals(op.getOperation()) && this.inputTypes.equals(op.inputTypes) && this.outputType.equals(op.outputType);
    }

    @Override
    @Pure
    public final @SignatureUnknown int compareTo(@SignatureUnknown TypedOperation other) {
        if (this instanceof TypedTermOperation && other instanceof TypedClassOperation) {
            return -1;
        }
        if (this instanceof TypedClassOperation && other instanceof TypedTermOperation) {
            return 1;
        }
        int result = this.getName().compareTo(other.getName());
        if (result != 0) {
            return result;
        }
        result = this.inputTypes.compareTo(other.inputTypes);
        if (result != 0) {
            return result;
        }
        if (this instanceof TypedClassOperation) {
            TypedClassOperation thisOp = (TypedClassOperation)this;
            TypedClassOperation otherOp = (TypedClassOperation)other;
            result = thisOp.getDeclaringType().compareTo(otherOp.getDeclaringType());
            if (result != 0) {
                return result;
            }
        }
        if ((result = this.outputType.compareTo(other.outputType)) != 0) {
            return result;
        }
        assert (result == 0);
        return result;
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.getOperation(), this.inputTypes, this.outputType);
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        String specString = this.execSpec == null ? "" : " [spec: " + this.execSpec.toString() + "]";
        return UtilPlume.escapeJava(this.getName()) + " : " + this.inputTypes + " -> " + this.outputType + specString;
    }

    @Override
    public @SignatureUnknown String getName() {
        return this.operation.getName();
    }

    public @SignatureUnknown String getSignatureString() {
        return this.getName() + this.inputTypes;
    }

    public @SignatureUnknown TypeTuple getInputTypes() {
        return this.inputTypes;
    }

    public @SignatureUnknown randoop.types.Type getOutputType() {
        return this.outputType;
    }

    public @SignatureUnknown CallableOperation getOperation() {
        return this.operation;
    }

    public abstract @SignatureUnknown boolean hasWildcardTypes();

    public final @SignatureUnknown boolean isGeneric() {
        return this.isGeneric(false);
    }

    public @SignatureUnknown boolean isGeneric(@SignatureUnknown boolean ignoreWildcards) {
        return this.inputTypes.isGeneric(ignoreWildcards) || this.outputType.isGeneric(ignoreWildcards);
    }

    @Override
    public @SignatureUnknown boolean isStatic() {
        return this.operation.isStatic();
    }

    @Override
    public @SignatureUnknown boolean isMessage() {
        return this.operation.isMessage();
    }

    @Override
    public @SignatureUnknown boolean isMethodCall() {
        return this.operation.isMethodCall();
    }

    @Override
    public @SignatureUnknown boolean isConstantField() {
        return this.operation.isConstantField();
    }

    @Override
    public @SignatureUnknown boolean isConstructorCall() {
        return this.operation.isConstructorCall();
    }

    @Override
    public @SignatureUnknown boolean isNonreceivingValue() {
        return this.operation.isNonreceivingValue();
    }

    @Override
    public @SignatureUnknown Object getValue() {
        return this.operation.getValue();
    }

    @Override
    public @SignatureUnknown boolean satisfies(@SignatureUnknown ReflectionPredicate reflectionPredicate) {
        return this.operation.satisfies(reflectionPredicate);
    }

    public abstract void appendCode(@SignatureUnknown List<@SignatureUnknown Variable> var1, @SignatureUnknown StringBuilder var2);

    public @SignatureUnknown ExecutionOutcome execute(@SignatureUnknown Object @SignatureUnknown [] input) {
        assert (input.length == this.inputTypes.size()) : "operation execute expected " + this.inputTypes.size() + ", but got " + input.length;
        return this.getOperation().execute(input);
    }

    public abstract @SignatureUnknown TypedOperation substitute(@SignatureUnknown Substitution var1);

    public abstract @SignatureUnknown TypedOperation applyCaptureConversion();

    public @SignatureUnknown List<@SignatureUnknown TypeVariable> getTypeParameters() {
        return new ArrayList<TypeVariable>();
    }

    public abstract @SignatureUnknown String toParsableString();

    public static @SignatureUnknown TypedClassOperation forConstructor(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Constructor<@SignatureUnknown @SignatureBottom ?> constructor) {
        ConstructorCall op = new ConstructorCall(constructor);
        ClassOrInterfaceType declaringType = ClassOrInterfaceType.forClass(constructor.getDeclaringClass());
        ArrayList<randoop.types.Type> paramTypes = new ArrayList<randoop.types.Type>();
        for (Type t : constructor.getGenericParameterTypes()) {
            paramTypes.add(randoop.types.Type.forType(t));
        }
        TypeTuple inputTypes = new TypeTuple(paramTypes);
        return new TypedClassOperation(op, declaringType, inputTypes, declaringType);
    }

    public static @SignatureUnknown TypedClassOperation forMethod(@SignatureUnknown Method method) {
        ArrayList<randoop.types.Type> methodParamTypes = new ArrayList<randoop.types.Type>();
        for (Type t : method.getGenericParameterTypes()) {
            methodParamTypes.add(randoop.types.Type.forType(t));
        }
        Class<?> declaringClass = method.getDeclaringClass();
        if (declaringClass.isAnonymousClass() && declaringClass.getEnclosingClass() != null && declaringClass.getEnclosingClass().isEnum()) {
            return TypedOperation.getAnonEnumOperation(method, methodParamTypes, declaringClass.getEnclosingClass());
        }
        ArrayList<randoop.types.Type> paramTypes = new ArrayList<randoop.types.Type>();
        MethodCall op = new MethodCall(method);
        ClassOrInterfaceType declaringType = ClassOrInterfaceType.forClass(method.getDeclaringClass());
        if (!op.isStatic()) {
            paramTypes.add(declaringType);
        }
        paramTypes.addAll(methodParamTypes);
        TypeTuple inputTypes = new TypeTuple(paramTypes);
        randoop.types.Type outputType = randoop.types.Type.forType(method.getGenericReturnType());
        if (outputType.isVariable()) {
            return new TypedClassOperationWithCast(op, declaringType, inputTypes, outputType);
        }
        return new TypedClassOperation(op, declaringType, inputTypes, outputType);
    }

    private static @SignatureUnknown TypedClassOperation getAnonEnumOperation(@SignatureUnknown Method method, @SignatureUnknown List<@SignatureUnknown randoop.types.Type> methodParamTypes, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> enumClass) {
        ClassOrInterfaceType enumType = ClassOrInterfaceType.forClass(enumClass);
        for (Method m3 : enumClass.getMethods()) {
            int i;
            if (!m3.getName().equals(method.getName()) || m3.getGenericParameterTypes().length != method.getGenericParameterTypes().length) continue;
            ArrayList<randoop.types.Type> paramTypes = new ArrayList<randoop.types.Type>();
            MethodCall op = new MethodCall(m3);
            if (!op.isStatic()) {
                paramTypes.add(enumType);
            }
            for (Type t : m3.getGenericParameterTypes()) {
                paramTypes.add(randoop.types.Type.forType(t));
            }
            TypeTuple inputTypes = new TypeTuple(paramTypes);
            randoop.types.Type outputType = randoop.types.Type.forType(m3.getGenericReturnType());
            ClassOrInterfaceType methodDeclaringType = ClassOrInterfaceType.forClass(m3.getDeclaringClass());
            if (methodDeclaringType.isGeneric()) {
                GenericClassType genDeclaringType = (GenericClassType)methodDeclaringType;
                InstantiatedType superType = enumType.getMatchingSupertype(genDeclaringType);
                assert (superType != null) : "should exist a super type of enum instantiating " + genDeclaringType;
                Substitution substitution = superType.getTypeSubstitution();
                inputTypes = inputTypes.substitute(substitution);
                outputType = outputType.substitute(substitution);
            }
            int d = op.isStatic() ? 0 : 1;
            for (i = 0; i < methodParamTypes.size() && methodParamTypes.get(i).equals(inputTypes.get(i + d)); ++i) {
            }
            if (i != methodParamTypes.size()) continue;
            return new TypedClassOperation(op, enumType, inputTypes, outputType);
        }
        System.out.println(method.getName() + " is bridge? " + method.isBridge() + " is synthetic? " + method.isSynthetic());
        return null;
    }

    public static @SignatureUnknown TypedClassOperation createGetterForField(@SignatureUnknown Field field, @SignatureUnknown ClassOrInterfaceType declaringType) {
        randoop.types.Type fieldType = randoop.types.Type.forType(field.getGenericType());
        AccessibleField accessibleField = new AccessibleField(field, declaringType);
        ArrayList<randoop.types.Type> inputTypes = new ArrayList<randoop.types.Type>();
        if (!accessibleField.isStatic()) {
            inputTypes.add(declaringType);
        }
        return new TypedClassOperation(new FieldGet(accessibleField), declaringType, new TypeTuple(inputTypes), fieldType);
    }

    public static @SignatureUnknown TypedClassOperation createSetterForField(@SignatureUnknown Field field, @SignatureUnknown ClassOrInterfaceType declaringType) {
        randoop.types.Type fieldType = randoop.types.Type.forType(field.getGenericType());
        AccessibleField accessibleField = new AccessibleField(field, declaringType);
        ArrayList<randoop.types.Type> inputTypes = new ArrayList<randoop.types.Type>();
        if (!accessibleField.isStatic()) {
            inputTypes.add(declaringType);
        }
        inputTypes.add(fieldType);
        return new TypedClassOperation(new FieldSet(accessibleField), declaringType, new TypeTuple(inputTypes), JavaTypes.VOID_TYPE);
    }

    public static @SignatureUnknown TypedOperation createNullOrZeroInitializationForType(@SignatureUnknown randoop.types.Type type) {
        return TypedOperation.createNonreceiverInitialization(NonreceiverTerm.createNullOrZeroTerm(type));
    }

    public static @SignatureUnknown TypedOperation createPrimitiveInitialization(@SignatureUnknown randoop.types.Type type, @SignatureUnknown Object value) {
        randoop.types.Type valueType = randoop.types.Type.forValue(value);
        assert (valueType.isNonreceiverType()) : "must be nonreceiver type, got " + type.getBinaryName();
        return TypedOperation.createNonreceiverInitialization(new NonreceiverTerm(type, value));
    }

    public static @SignatureUnknown TypedOperation createNonreceiverInitialization(@SignatureUnknown NonreceiverTerm term) {
        return new TypedTermOperation(term, new TypeTuple(), term.getType());
    }

    public static @SignatureUnknown TypedOperation createInitializedArrayCreation(@SignatureUnknown ArrayType arrayType, @SignatureUnknown int size) {
        ArrayList<randoop.types.Type> typeList = new ArrayList<randoop.types.Type>();
        for (int i = 0; i < size; ++i) {
            typeList.add(arrayType.getComponentType());
        }
        TypeTuple inputTypes = new TypeTuple(typeList);
        return new TypedTermOperation(new InitializedArrayCreation(arrayType, size), inputTypes, arrayType);
    }

    public static @SignatureUnknown TypedOperation createArrayCreation(@SignatureUnknown ArrayType arrayType) {
        List<randoop.types.Type> typeList = Collections.singletonList(JavaTypes.INT_TYPE);
        TypeTuple inputTypes = new TypeTuple(typeList);
        return new TypedTermOperation(new ArrayCreation(arrayType), inputTypes, arrayType);
    }

    public static @SignatureUnknown TypedOperation createCast(@SignatureUnknown randoop.types.Type fromType, @SignatureUnknown randoop.types.Type toType) {
        List<randoop.types.Type> typeList = Collections.singletonList(fromType);
        TypeTuple inputTypes = new TypeTuple(typeList);
        return new TypedTermOperation(new UncheckedCast(toType), inputTypes, toType);
    }

    public static @SignatureUnknown TypedOperation createArrayElementAssignment(@SignatureUnknown ArrayType arrayType) {
        ArrayList<randoop.types.Type> typeList = new ArrayList<randoop.types.Type>();
        typeList.add(arrayType);
        typeList.add(JavaTypes.INT_TYPE);
        typeList.add(arrayType.getComponentType());
        TypeTuple inputTypes = new TypeTuple(typeList);
        return new TypedTermOperation(new ArrayElementSet(arrayType.getComponentType()), inputTypes, JavaTypes.VOID_TYPE);
    }

    @Override
    public @SignatureUnknown boolean isUncheckedCast() {
        return this.operation.isUncheckedCast();
    }

    public @SignatureUnknown ExpectedOutcomeTable checkPrestate(@SignatureUnknown Object @SignatureUnknown [] values) {
        if (this.execSpec == null) {
            return new ExpectedOutcomeTable();
        }
        return this.execSpec.checkPrestate(this.addNullReceiverIfStatic(values));
    }

    private @SignatureUnknown Object @SignatureUnknown [] addNullReceiverIfStatic(@SignatureUnknown Object @SignatureUnknown [] values) {
        Object[] args = values;
        if (this.isStatic()) {
            args = new Object[values.length + 1];
            args[0] = null;
            System.arraycopy(values, 0, args, 1, values.length);
        }
        return args;
    }

    public static class RankedTypeOperation {
        public final @SignatureUnknown double ranking;
        public final @SignatureUnknown TypedClassOperation operation;

        public RankedTypeOperation(@SignatureUnknown double ranking, @SignatureUnknown TypedClassOperation operation) {
            this.ranking = ranking;
            this.operation = operation;
        }
    }
}

