/*
 * Decompiled with CFR 0.152.
 */
package randoop.operation;

import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.ExceptionalExecution;
import randoop.ExecutionOutcome;
import randoop.NormalExecution;
import randoop.operation.CallableOperation;
import randoop.operation.TypedClassOperation;
import randoop.types.ClassOrInterfaceType;
import randoop.types.Substitution;
import randoop.types.Type;
import randoop.types.TypeTuple;

public class TypedClassOperationWithCast
extends TypedClassOperation {
    TypedClassOperationWithCast(@SignatureUnknown CallableOperation op, @SignatureUnknown ClassOrInterfaceType declaringType, @SignatureUnknown TypeTuple inputTypes, @SignatureUnknown Type outputType) {
        super(op, declaringType, inputTypes, outputType);
    }

    @Override
    public @SignatureUnknown TypedClassOperationWithCast substitute(@SignatureUnknown Substitution substitution) {
        if (substitution.isEmpty()) {
            return this;
        }
        ClassOrInterfaceType declaringType = this.getDeclaringType().substitute(substitution);
        TypeTuple inputTypes = this.getInputTypes().substitute(substitution);
        Type outputType = this.getOutputType().substitute(substitution);
        return new TypedClassOperationWithCast(this.getOperation(), declaringType, inputTypes, outputType);
    }

    @Override
    public @SignatureUnknown TypedClassOperationWithCast applyCaptureConversion() {
        return new TypedClassOperationWithCast(this.getOperation(), this.getDeclaringType(), this.getInputTypes().applyCaptureConversion(), this.getOutputType());
    }

    @Override
    public @SignatureUnknown ExecutionOutcome execute(@SignatureUnknown Object @SignatureUnknown [] input) {
        ExecutionOutcome outcome = super.execute(input);
        if (outcome instanceof NormalExecution) {
            NormalExecution execution = (NormalExecution)outcome;
            Object result = null;
            try {
                result = this.getOutputType().getRuntimeClass().cast(execution.getRuntimeValue());
            }
            catch (ClassCastException e) {
                return new ExceptionalExecution(e, 0L);
            }
            if (result != null) {
                return new NormalExecution(result, execution.getExecutionTime());
            }
        }
        return outcome;
    }
}

