/*
 * Decompiled with CFR 0.152.
 */
package randoop.operation;

import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import randoop.ExecutionOutcome;
import randoop.operation.CallableOperation;
import randoop.operation.OperationParseException;
import randoop.operation.TypeArguments;
import randoop.operation.TypedClassOperation;
import randoop.reflection.ReflectionPredicate;
import randoop.sequence.Variable;
import randoop.types.Type;
import randoop.types.TypeTuple;
import randoop.util.Log;
import randoop.util.MethodReflectionCode;
import randoop.util.ReflectionExecutor;

public final class MethodCall
extends CallableOperation {
    private final @SignatureUnknown Method method;
    private final @SignatureUnknown boolean isStatic;

    public @SignatureUnknown Method getMethod() {
        return this.method;
    }

    public MethodCall(@SignatureUnknown Method method) {
        if (method == null) {
            throw new IllegalArgumentException("method should not be null.");
        }
        this.method = method;
        this.method.setAccessible(true);
        this.isStatic = Modifier.isStatic(method.getModifiers() & Modifier.methodModifiers());
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        return this.method.toString();
    }

    @Override
    public void appendCode(@SignatureUnknown Type declaringType, @SignatureUnknown TypeTuple inputTypes, @SignatureUnknown Type outputType, @SignatureUnknown List<@SignatureUnknown Variable> inputVars, @SignatureUnknown StringBuilder sb) {
        int startIndex;
        String receiverString;
        String string = receiverString = this.isStatic() ? null : inputVars.get(0).getName();
        if (this.isStatic()) {
            sb.append(declaringType.getCanonicalName().replace('$', '.'));
        } else {
            Type expectedType = inputTypes.get(0);
            if (expectedType.isPrimitive()) {
                sb.append("((").append(expectedType.getFqName()).append(")").append(receiverString).append(")");
            } else {
                sb.append(receiverString);
            }
        }
        sb.append(".");
        sb.append(this.getMethod().getName()).append("(");
        for (int i = startIndex = this.isStatic() ? 0 : 1; i < inputVars.size(); ++i) {
            if (i > startIndex) {
                sb.append(", ");
            }
            if (!inputVars.get(i).getType().equals(inputTypes.get(i))) {
                sb.append("(").append(inputTypes.get(i).getFqName()).append(")");
            }
            String param = this.getArgumentString(inputVars.get(i));
            sb.append(param);
        }
        sb.append(")");
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodCall)) {
            return false;
        }
        MethodCall other = (MethodCall)o;
        return this.method.equals(other.method);
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.method);
    }

    @Override
    public @SignatureUnknown ExecutionOutcome execute(@SignatureUnknown Object @SignatureUnknown [] input) {
        Log.logPrintf("MethodCall.execute: this = %s%n", this);
        Object receiver = null;
        int paramsLength = input.length;
        int paramsStartIndex = 0;
        if (!this.isStatic()) {
            receiver = input[0];
            --paramsLength;
            paramsStartIndex = 1;
        }
        Object[] params = new Object[paramsLength];
        for (int i = 0; i < params.length; ++i) {
            params[i] = input[i + paramsStartIndex];
            if (!Log.isLoggingOn()) continue;
            Log.logPrintf("  Param %d = %s%n", i, Log.toStringAndClass(params[i]));
        }
        MethodReflectionCode code = new MethodReflectionCode(this.method, receiver, params);
        return ReflectionExecutor.executeReflectionCode(code);
    }

    @Override
    public @SignatureUnknown boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public @SignatureUnknown String toParsableString(@SignatureUnknown Type declaringType, @SignatureUnknown TypeTuple inputTypes, @SignatureUnknown Type outputType) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.method.getDeclaringClass().getName()).append(".");
        sb.append(this.method.getName()).append("(");
        Class<?>[] params = this.method.getParameterTypes();
        TypeArguments.getTypeArgumentString(sb, params);
        sb.append(")");
        return sb.toString();
    }

    public static @SignatureUnknown TypedClassOperation parse(@SignatureUnknown String signature) throws @SignatureUnknown OperationParseException {
        Object[] typeArguments;
        Type classType;
        if (signature == null) {
            throw new IllegalArgumentException("signature may not be null");
        }
        int openParPos = signature.indexOf(40);
        int closeParPos = signature.indexOf(41);
        String prefix = signature.substring(0, openParPos);
        int lastDotPos = prefix.lastIndexOf(46);
        assert (lastDotPos >= 0);
        String classname = prefix.substring(0, lastDotPos);
        String opname = prefix.substring(lastDotPos + 1);
        String arguments = signature.substring(openParPos + 1, closeParPos);
        try {
            classType = Type.getTypeforFullyQualifiedName(classname);
        }
        catch (ClassNotFoundException e) {
            String msg = "Class " + classname + " is not on classpath while parsing \"" + signature + "\"";
            throw new OperationParseException(msg);
        }
        try {
            typeArguments = TypeArguments.getTypeArgumentsForString(arguments);
        }
        catch (OperationParseException e) {
            throw new OperationParseException(e.getMessage() + " while parsing \"" + signature + "\"");
        }
        Method m3 = null;
        try {
            m3 = classType.getRuntimeClass().getDeclaredMethod(opname, (Class<?>[])typeArguments);
        }
        catch (NoSuchMethodException e) {
            try {
                m3 = classType.getRuntimeClass().getMethod(opname, (Class<?>[])typeArguments);
            }
            catch (NoSuchMethodException e2) {
                String msg = "Method " + opname + " with parameters " + Arrays.toString(typeArguments) + " does not exist in " + classType + ": " + e;
                throw new OperationParseException(msg);
            }
        }
        return TypedClassOperation.forMethod(m3);
    }

    @Override
    public @SignatureUnknown boolean isMessage() {
        return true;
    }

    @Override
    public @SignatureUnknown boolean isMethodCall() {
        return true;
    }

    @Override
    public @SignatureUnknown String getName() {
        return this.method.getName();
    }

    @Override
    public @SignatureUnknown Method getReflectionObject() {
        return this.method;
    }

    @Override
    public @SignatureUnknown boolean satisfies(@SignatureUnknown ReflectionPredicate reflectionPredicate) {
        return reflectionPredicate.test(this.method);
    }
}

