/*
 * Decompiled with CFR 0.152.
 */
package randoop.operation;

import coveredclass.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import coveredclass.org.checkerframework.checker.signature.qual.SignatureUnknown;
import coveredclass.org.checkerframework.dataflow.qual.Pure;
import coveredclass.org.checkerframework.dataflow.qual.SideEffectFree;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Objects;
import randoop.ExecutionOutcome;
import randoop.NormalExecution;
import randoop.operation.CallableOperation;
import randoop.operation.OperationParseException;
import randoop.operation.TypedOperation;
import randoop.sequence.Variable;
import randoop.types.ArrayType;
import randoop.types.Type;
import randoop.types.TypeTuple;

public final class InitializedArrayCreation
extends CallableOperation {
    private final @SignatureUnknown int length;
    private final @SignatureUnknown Type elementType;

    InitializedArrayCreation(@SignatureUnknown ArrayType arrayType, @SignatureUnknown int length) {
        assert (length >= 0) : "array length may not be negative: " + length;
        this.elementType = arrayType.getComponentType();
        this.length = length;
    }

    public @SignatureUnknown int getLength() {
        return this.length;
    }

    @Override
    public @SignatureUnknown ExecutionOutcome execute(@SignatureUnknown Object @SignatureUnknown [] statementInput) {
        if (statementInput.length > this.length) {
            throw new IllegalArgumentException("Too many arguments: " + statementInput.length + ", capacity: " + this.length);
        }
        long startTime = System.currentTimeMillis();
        assert (statementInput.length == this.length);
        Object theArray = Array.newInstance(this.elementType.getRuntimeClass(), this.length);
        for (int i = 0; i < statementInput.length; ++i) {
            Array.set(theArray, i, statementInput[i]);
        }
        long totalTime = System.currentTimeMillis() - startTime;
        return new NormalExecution(theArray, totalTime);
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        return this.elementType.getBinaryName() + "[" + this.length + "]";
    }

    @Override
    public void appendCode(@SignatureUnknown Type declaringType, @SignatureUnknown TypeTuple inputTypes, @SignatureUnknown Type outputType, @SignatureUnknown List<@SignatureUnknown Variable> inputVars, @SignatureUnknown StringBuilder b) {
        if (inputVars.size() > this.length) {
            throw new IllegalArgumentException("Too many arguments: " + inputVars.size() + ", capacity: " + this.length);
        }
        String arrayTypeName = this.elementType.getFqName();
        b.append("new ").append(arrayTypeName).append("[] { ");
        for (int i = 0; i < inputVars.size(); ++i) {
            if (i > 0) {
                b.append(", ");
            }
            String param = this.getArgumentString(inputVars.get(i));
            b.append(param);
        }
        b.append(" }");
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.elementType, this.length);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InitializedArrayCreation)) {
            return false;
        }
        InitializedArrayCreation otherArrayDecl = (InitializedArrayCreation)o;
        return this.elementType.equals(otherArrayDecl.elementType) && this.length == otherArrayDecl.length;
    }

    @Override
    public @SignatureUnknown String toParsableString(@SignatureUnknown Type declaringType, @SignatureUnknown TypeTuple inputTypes, @SignatureUnknown Type outputType) {
        return this.elementType.getBinaryName() + "[" + Integer.toString(this.length) + "]";
    }

    @Override
    public @SignatureUnknown String getName() {
        return this.toString();
    }

    public static @SignatureUnknown TypedOperation parse(@SignatureUnknown String str) throws @SignatureUnknown OperationParseException {
        Type elementType;
        int openBr = str.indexOf(91);
        int closeBr = str.indexOf(93);
        String elementTypeName = str.substring(0, openBr);
        String lengthStr = str.substring(openBr + 1, closeBr);
        int length = Integer.parseInt(lengthStr);
        try {
            elementType = Type.forName(elementTypeName);
        }
        catch (ClassNotFoundException e) {
            throw new OperationParseException("Type not found for array element type " + elementTypeName);
        }
        if (elementType.isGeneric()) {
            throw new OperationParseException("Array element type may not be generic " + elementTypeName);
        }
        return TypedOperation.createInitializedArrayCreation(ArrayType.ofComponentType(elementType), length);
    }
}

